/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools;

import com.ats.element.AtsBaseElement;
import com.ats.generator.variables.CalculatedValue;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.ahocorasick.trie.Emit;
import org.ahocorasick.trie.Trie;

public final class Operators {
    public static final String REGEXP = "=~";
    public static final String DIFFERENT = "<>";
    public static final String LOWER_EQUAL = "<=";
    public static final String GREATER_EQUAL = ">=";
    public static final String EQUAL = "=";
    public static final String LOWER = "<";
    public static final String GREATER = ">";
    public static final Pattern REGEXP_PATTERN = Pattern.compile("(.*)=~(.*)");
    public static final Pattern EQUAL_PATTERN = Pattern.compile("(.*)=(.*)");
    private static final Trie trieOperator = Trie.builder().ignoreOverlaps().addKeywords(new String[]{"=~"}).addKeyword(">=").addKeyword("<=").addKeyword("=").addKeyword("<").addKeyword(">").build();
    private String type = "=";
    private Pattern regexpPattern = Pattern.compile(".*");

    public Operators() {
    }

    public Operators(String value) {
        this.setType(value);
    }

    public Predicate<AtsBaseElement> getPredicate(Predicate<AtsBaseElement> predicate, String name, CalculatedValue value) {
        if (REGEXP.equals(this.getType())) {
            return predicate.and(p -> this.regexpMatch(p.getAttribute(name)));
        }
        return predicate.and(p -> this.textEquals(p.getAttribute(name), value.getCalculated()));
    }

    public void updatePattern(String calculated) {
        try {
            this.regexpPattern = Pattern.compile(calculated);
        }
        catch (PatternSyntaxException e) {
            this.regexpPattern = Pattern.compile(".*");
        }
    }

    public String check(String data, String calculated) {
        block23: {
            if (REGEXP.equals(this.getType())) {
                if (!this.regexpMatch(data)) {
                    return "does not match regex pattern";
                }
            } else if (DIFFERENT.equals(this.getType())) {
                if (this.textEquals(data, calculated)) {
                    return "is not different than";
                }
            } else {
                if (GREATER.equals(this.getType())) {
                    try {
                        if (Double.parseDouble(data) <= Double.parseDouble(calculated)) {
                            return "is not greater than";
                        }
                        break block23;
                    }
                    catch (NumberFormatException e) {
                        return "cannot be compared as number with";
                    }
                }
                if (LOWER.equals(this.getType())) {
                    try {
                        if (Double.parseDouble(data) >= Double.parseDouble(calculated)) {
                            return "is not lower than";
                        }
                        break block23;
                    }
                    catch (NumberFormatException e) {
                        return "cannot be compared as number with";
                    }
                }
                if (GREATER_EQUAL.equals(this.getType())) {
                    try {
                        if (Double.parseDouble(data) < Double.parseDouble(calculated)) {
                            return "is not greater or equals to";
                        }
                        break block23;
                    }
                    catch (NumberFormatException e) {
                        return "cannot be compared as number with";
                    }
                }
                if (LOWER_EQUAL.equals(this.getType())) {
                    try {
                        if (Double.parseDouble(data) > Double.parseDouble(calculated)) {
                            return "is not lower or equals to";
                        }
                        break block23;
                    }
                    catch (NumberFormatException e) {
                        return "cannot be compared as number with";
                    }
                }
                if (!this.textEquals(data, calculated)) {
                    return "is not equals to";
                }
            }
        }
        return null;
    }

    public boolean textEquals(String data, String calculated) {
        if (data == null) {
            return false;
        }
        return data.equals(calculated);
    }

    public boolean regexpMatch(String data) {
        if (data == null) {
            return false;
        }
        return this.regexpPattern.matcher(data).matches();
    }

    public static String getJavaCode(String op) {
        String code = Operators.class.getSimpleName() + ".";
        switch (op) {
            case "<": {
                return code + "LOWER";
            }
            case ">": {
                return code + "GREATER";
            }
            case "<>": {
                return code + "DIFFERENT";
            }
            case "<=": {
                return code + "LOWER_EQUAL";
            }
            case ">=": {
                return code + "GREATER_EQUAL";
            }
            case "=~": {
                return code + "REGEXP";
            }
        }
        return code + "EQUAL";
    }

    public String getJavaCode() {
        return Operators.getJavaCode(this.type);
    }

    public boolean isRegexp() {
        return REGEXP.equals(this.type);
    }

    public String[] initData(String data) {
        Optional opt = trieOperator.parseText((CharSequence)data).stream().findFirst();
        if (opt.isPresent()) {
            Emit emit = (Emit)opt.get();
            this.setType(emit.getKeyword());
            return new String[]{data.substring(0, emit.getStart()).trim(), data.substring(emit.getEnd() + 1).trim()};
        }
        return new String[]{data.trim(), ""};
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

