/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import java.util.Map;
import org.testng.TestRunner;

public class SuitesReportItem {
    public String name;
    public String description;
    public Map<String, String> parameters;
    public String[] tests;
    public String logLevel = "";

    public SuitesReportItem(TestRunner runner) {
        this.name = runner.getSuite().getName();
        this.parameters = runner.getTest().getAllParameters();
        this.tests = (String[])runner.getTest().getClasses().stream().map(c -> c.getName()).toArray(String[]::new);
        if (this.parameters != null) {
            this.setLogLevel(this.parameters.remove("ats.log.level"));
            this.setDescription(this.parameters.remove("ats.suite.description"));
        }
    }

    private void setLogLevel(String value) {
        if (value != null) {
            this.logLevel = value;
        }
    }

    private void setDescription(String value) {
        if (value != null) {
            this.description = value;
        }
    }
}

