/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.messaging.amf.io.util;

import com.exadel.flamingo.flex.messaging.amf.io.util.JavaClassDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class LazyUtil {
    private static final String HIBERNATE_CLASS = "org.hibernate.Hibernate";
    private static final String IS_INITIALIZED = "isInitialized";

    private static Class<?> getHibernateClass() {
        Class<?> cl = null;
        try {
            cl = Class.forName(HIBERNATE_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cl;
    }

    private static Method getInitializeMethod(Class<?> cl) {
        Method method = null;
        try {
            method = cl.getDeclaredMethod(IS_INITIALIZED, Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    private static boolean isPropertyInitialized(Method method, Object obj) {
        boolean isInitialized = true;
        try {
            isInitialized = (Boolean)method.invoke(null, obj);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return isInitialized;
    }

    public static void removeLazyFields(JavaClassDescriptor desc, Object o) {
        Class<?> cl = LazyUtil.getHibernateClass();
        if (cl == null) {
            return;
        }
        Method method = LazyUtil.getInitializeMethod(cl);
        ArrayList<Integer> deleteIndexes = new ArrayList<Integer>();
        for (int i = 0; i < desc.getPropertiesCount(); ++i) {
            Object obj = desc.getPropertyValue(i, o);
            if (LazyUtil.isPropertyInitialized(method, obj)) continue;
            deleteIndexes.add(i);
        }
        LazyUtil.deleteProperties(deleteIndexes, desc);
    }

    private static void deleteProperties(List<Integer> deleteIndexes, JavaClassDescriptor desc) {
        if (deleteIndexes != null && !deleteIndexes.isEmpty()) {
            for (int i = deleteIndexes.size() - 1; i >= 0; --i) {
                desc.removeProperty(deleteIndexes.get(i));
            }
        }
    }

    public static boolean isProxy(Object object) {
        boolean isProxy = false;
        try {
            if (Class.forName("org.hibernate.proxy.HibernateProxy").isInstance(object)) {
                isProxy = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return isProxy;
    }
}

