/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.messaging.amf.io.util.externalizer;

import com.exadel.flamingo.flex.messaging.amf.io.util.externalizer.DefaultConstructorFactory;
import com.exadel.flamingo.flex.messaging.util.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

class SunDefaultConstructorFactory
implements DefaultConstructorFactory {
    private final Object reflectionFactory;
    private final Method newConstructorForSerialization;

    public SunDefaultConstructorFactory() {
        try {
            Class<?> factoryClass = ClassUtil.forName("sun.reflect.ReflectionFactory");
            Method getReflectionFactory = factoryClass.getDeclaredMethod("getReflectionFactory", new Class[0]);
            this.reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            this.newConstructorForSerialization = factoryClass.getDeclaredMethod("newConstructorForSerialization", Class.class, Constructor.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Sun Factory", e);
        }
    }

    @Override
    public <T> Constructor<T> findDefaultConstructor(Class<T> clazz) {
        try {
            Constructor constructor = Object.class.getDeclaredConstructor(new Class[0]);
            constructor = (Constructor)this.newConstructorForSerialization.invoke(this.reflectionFactory, clazz, constructor);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

