/*
 * Decompiled with CFR 0.152.
 */
package com.exadel.flamingo.flex.messaging.util;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLUtil {
    private DocumentBuilderFactory documentBuilderFactory = null;
    private TransformerFactory transformerFactory = null;

    public Document buildDocument(String xml) {
        try {
            DocumentBuilder builder = this.getDocumentBuilderFactory().newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse XML string", e);
        }
    }

    public String toString(Document doc) {
        try {
            Transformer transformer = this.getTransformerFactory().newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not serialize document", e);
        }
    }

    private TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = TransformerFactory.newInstance();
        }
        return this.transformerFactory;
    }

    private DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        }
        return this.documentBuilderFactory;
    }
}

