/*
 * Decompiled with CFR 0.152.
 */
package com.naturalnessanalysis;

import com.ats.generator.ATS;
import com.naturalnessanalysis.Analyzer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class ProcessResults {
    final int DEPTH = 5;
    final double PROBA_OF_UNKNOWN = 1.0E-6;
    private Analyzer analyzer;
    private ArrayList<File> xmlReports = new ArrayList();

    public static void main(String[] args) {
        if (args.length > 0) {
            new ProcessResults(args[0]);
        } else {
            ATS.logError("No xml reports folder defined !");
        }
    }

    public ProcessResults(String reportsFolderPath) {
        this(new File(reportsFolderPath));
    }

    public ProcessResults(File reportsFolder) {
        this.analyzer = new Analyzer(5, 1.0E-6);
        if (!reportsFolder.exists()) {
            ATS.logError("xml reports folder does not exists -> " + reportsFolder.getAbsolutePath());
            return;
        }
        if (!reportsFolder.isDirectory()) {
            ATS.logError("This path is not a directory -> " + reportsFolder.getAbsolutePath());
            return;
        }
        try {
            Files.find(reportsFolder.toPath(), 99999, (p, f) -> f.isRegularFile(), new FileVisitOption[0]).forEach(p -> this.xmlReports.add(p.toFile()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("files: " + this.xmlReports.size());
        for (File xml : this.xmlReports) {
            String testName = xml.getParentFile().getName().replaceAll("\\_xml$", "");
            try {
                this.analyzer.recordSequenceFromLogFile(xml);
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                e.printStackTrace();
            }
        }
        String csvGlobal = this.analyzer.globalAnalysis().toCSV();
        System.out.println(csvGlobal);
        String csvRanking = this.analyzer.rankAnalysis().toCSV();
        System.out.println(csvRanking);
        String csvSequence = this.analyzer.sequenceAnalysis().toCSV();
        System.out.println(csvSequence);
        try {
            File report = new File(reportsFolder.getPath() + File.separator + "analysis.csv");
            boolean isCreated = report.createNewFile();
            if (isCreated) {
                PrintWriter pw = new PrintWriter(report);
                pw.println(csvGlobal);
                pw.println(csvRanking);
                pw.println(csvSequence);
                pw.close();
            }
        }
        catch (IOException ex) {
            System.out.println("Can't write file");
        }
    }
}

