/*
 * Decompiled with CFR 0.152.
 */
package com.ats.element;

import com.ats.driver.AtsManager;
import com.ats.element.AtsBaseElement;
import com.ats.element.FoundElement;
import com.ats.element.SearchedElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendKeyData;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.engines.IDriverEngine;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.recorder.IVisualRecorder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public class TestElement {
    public static final String CLIENT_WIDTH = "clientWidth";
    public static final String CLIENT_HEIGTH = "clientHeight";
    public static final String ATS_OCCURRENCES = "-ats-occurences";
    public static final String ATS_OCCURRENCES_INDEX = "-ats-occurences-index";
    public static final String ATS_TABLE_DATA = "-ats-table-data";
    public static final String ATS_MAX_TRY = "-ats-max-try";
    public static final String ATS_SEARCH_DURATION = "-ats-search-duration";
    public static final String ATS_SEARCH_TAG = "-ats-search-tag";
    private static final String MAT_SELECT = "MAT-SELECT";
    private static final String PRE = "PRE";
    private static final String ALERT_BOX = "AlertBox";
    public static final String BODY = "BODY";
    public static final String SYSCOMP = "SYSCOMP";
    protected Channel channel;
    protected IDriverEngine engine;
    private Predicate<Integer> occurrences;
    private int count = 0;
    private long searchDuration = 0L;
    private long totalSearchDuration = 0L;
    protected TestElement parent;
    private List<FoundElement> foundElements = new ArrayList<FoundElement>();
    private int maxTry = 20;
    private int maxTryInteractable = AtsManager.getInstance().getMaxTryInteractable();
    private int index = 0;
    private int evalIndex = 0;
    private String criterias = "";
    private String searchedTag = "";
    protected IVisualRecorder recorder;
    private boolean sysComp = false;

    public TestElement() {
    }

    public TestElement(Channel channel) {
        this(channel, 1, 0);
        this.foundElements = new ArrayList<FoundElement>(Arrays.asList(new FoundElement(channel)));
    }

    public TestElement(Channel channel, int count, int index) {
        this.channel = channel;
        this.count = count;
        this.index = index;
        this.occurrences = p -> true;
        this.engine = channel.getDriverEngine();
    }

    public TestElement(Channel channel, int maxTry) {
        this.channel = channel;
        this.maxTry = maxTry;
    }

    public TestElement(FoundElement element, Channel currentChannel) {
        this(currentChannel);
        this.foundElements.add(element);
        this.count = this.getElementsCount();
    }

    public TestElement(Channel channel, int maxTry, Predicate<Integer> occurrences) {
        this(channel, maxTry);
        this.occurrences = occurrences;
    }

    public TestElement(Channel channel, int maxTry, Predicate<Integer> predicate, int index) {
        this(channel, maxTry, predicate);
        this.setIndex(index);
    }

    public TestElement(Channel channel, SearchedElement searchedElement) {
        this(channel, 1, (Integer p) -> true, searchedElement);
    }

    public TestElement(Channel channel, int maxTry, Predicate<Integer> predicate, SearchedElement searchedElement) {
        this(channel, maxTry, predicate, searchedElement.getIndex());
        if (searchedElement.getParent() != null) {
            this.parent = new TestElement(channel, maxTry, predicate, searchedElement.getParent());
        }
        this.setEngine(channel.getDriverEngine());
        this.startSearch(false, searchedElement);
    }

    public String getNotFoundDescription() {
        StringBuilder builder = new StringBuilder("element not found ");
        builder.append("[").append(this.criterias).append("]");
        return builder.toString();
    }

    protected void setEngine(IDriverEngine engine) {
        this.engine = engine;
    }

    protected void reloadFoundElements() {
        this.foundElements = new ArrayList<FoundElement>(Arrays.asList(new FoundElement(this.channel)));
    }

    public void dispose() {
        this.channel = null;
        this.engine = null;
        this.recorder = null;
        this.occurrences = null;
        if (this.parent != null) {
            this.parent.dispose();
            this.parent = null;
        }
        while (this.foundElements.size() > 0) {
            this.foundElements.remove(0).dispose();
        }
    }

    public boolean isAngularSelect() {
        return MAT_SELECT.equalsIgnoreCase(this.searchedTag);
    }

    public boolean isPreElement() {
        return PRE.equalsIgnoreCase(this.searchedTag);
    }

    public boolean isSysComp() {
        return this.sysComp;
    }

    protected int getMaxTry() {
        return this.maxTry;
    }

    protected Channel getChannel() {
        return this.channel;
    }

    protected void startSearch(boolean sysComp, SearchedElement searchedElement) {
        this.sysComp = sysComp;
        if (this.channel != null) {
            this.criterias = this.searchedTag = searchedElement.getTag();
            this.searchDuration = System.currentTimeMillis();
            if (this.parent == null || this.parent != null && this.parent.getCount() > 0) {
                this.foundElements = this.loadElements(searchedElement);
            }
            this.searchDuration = System.currentTimeMillis() - this.searchDuration;
            this.totalSearchDuration = this.getTotalDuration();
            this.count = this.getElementsCount();
        }
    }

    protected List<FoundElement> loadElements(SearchedElement searchedElement) {
        int criteriasCount = searchedElement.getCriterias().size();
        String[] attributes = new String[criteriasCount];
        String[] attributesValues = new String[criteriasCount];
        Predicate<AtsBaseElement> fullPredicate = Objects::nonNull;
        for (int i = 0; i < criteriasCount; ++i) {
            CalculatedProperty property = searchedElement.getCriterias().get(i);
            this.criterias = this.criterias + "," + property.getName() + ":" + property.getValue().getCalculated();
            fullPredicate = property.getPredicate(fullPredicate);
            attributes[i] = property.getName();
            attributesValues[i] = property.isRegexp() ? property.getName() : property.getName() + "\t" + property.getValue().getCalculated();
        }
        try {
            return this.engine.findElements(this.sysComp, this, this.searchedTag, attributes, attributesValues, fullPredicate, null);
        }
        catch (StaleElementReferenceException e) {
            return Collections.emptyList();
        }
    }

    public int getElementsCount() {
        int size = this.foundElements.size();
        if (size > 0) {
            if (this.index >= 0) {
                int i = this.index;
                if (i > 0) {
                    --i;
                }
                if (size > i) {
                    return size;
                }
            } else {
                if (this.index == -1) {
                    return size;
                }
                if (size > -this.index - 1) {
                    return size;
                }
            }
        }
        return 0;
    }

    private long getTotalDuration() {
        if (this.parent != null) {
            return this.searchDuration + this.parent.getTotalDuration();
        }
        return this.searchDuration;
    }

    public FoundElement getFoundElement() {
        FoundElement result = null;
        int size = this.getElementsCount();
        if (size > 0) {
            int i = 0;
            if (this.index >= 0) {
                if (this.index > 0) {
                    i = this.index - 1;
                }
            } else {
                i = size - 1;
                if (this.index != -1 && (i += this.index + 1) < 0) {
                    i = 0;
                }
            }
            try {
                result = this.foundElements.get(i);
                this.evalIndex = i;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result;
    }

    public int getEvalIndex() {
        return this.evalIndex;
    }

    public boolean isPassword() {
        return this.getFoundElement().isPassword();
    }

    public boolean isNumeric() {
        return this.getFoundElement().isNumeric();
    }

    public WebElement getWebElement() {
        return this.getFoundElement().getValue();
    }

    public boolean isBody() {
        return this.getFoundElement().getTag().equalsIgnoreCase(BODY);
    }

    public String getWebElementId() {
        return this.getFoundElement().getId();
    }

    public Rectangle getWebElementRectangle() {
        return this.getFoundElement().getRectangle();
    }

    public boolean isValidated() {
        return this.occurrences.test(this.getElementsCount());
    }

    public boolean isIframe() {
        if (this.getElementsCount() > 0) {
            return this.getFoundElement().isIframe();
        }
        return false;
    }

    public String getSearchedTag() {
        return this.searchedTag;
    }

    protected void setDialogBox() {
        this.searchedTag = ALERT_BOX;
        this.criterias = "";
    }

    public TestElement getParent() {
        return this.parent;
    }

    public void setParent(TestElement parent) {
        this.parent = parent;
    }

    public long getSearchDuration() {
        return this.searchDuration;
    }

    public void setSearchDuration(long searchDuration) {
        this.searchDuration = searchDuration;
    }

    public long getTotalSearchDuration() {
        return this.totalSearchDuration;
    }

    public void setTotalSearchDuration(long totalSearchDuration) {
        this.totalSearchDuration = totalSearchDuration;
    }

    public List<FoundElement> getFoundElements() {
        return this.foundElements;
    }

    public void setFoundElements(ArrayList<FoundElement> data) {
        this.foundElements = data;
    }

    public String getCriterias() {
        return this.criterias;
    }

    public void setCriterias(String criterias) {
        this.criterias = criterias;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int value) {
        this.index = value;
    }

    public void checkOccurrences(ActionTestScript ts, ActionStatus status, String operator, int expected) {
        int error = 0;
        if (this.isValidated()) {
            status.setNoError();
        } else {
            error = -8;
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(expected).append("] expected occurrence(s) but [").append(this.count).append("] occurrence(s) found using criterias [").append(this.criterias).append("]");
            status.setError(-8, sb.toString(), this.count);
        }
        status.endDuration();
        ts.getRecorder().updateScreen(status);
        this.terminateExecution(status, ts, error, status.getDuration(), "" + this.count, operator + " " + expected);
    }

    public void clearText(ActionStatus status, MouseDirection md) {
        this.engine.clearText(status, this, md);
    }

    public String enterText(ActionStatus status, CalculatedValue text, ActionTestScript script, int waitChar) {
        MouseDirection md = new MouseDirection();
        this.over(status, md, false, 0, 0);
        return this.finalizeEnterText(status, text, md, script, waitChar);
    }

    protected String finalizeEnterText(ActionStatus status, CalculatedValue text, MouseDirection md, ActionTestScript script, int waitChar) {
        if (status.isPassed()) {
            this.recorder.updateScreen(false);
            if (!text.getCalculated().startsWith("$key")) {
                this.clearText(status, md);
            }
            String enteredText = this.sendText(script, status, text, waitChar);
            if (this.isPassword() || text.isCrypted()) {
                return "########";
            }
            return enteredText;
        }
        return "";
    }

    public String sendText(ActionTestScript script, ActionStatus status, CalculatedValue text, int waitChar) {
        this.waitTextInteractable(this.maxTry, status, text.getCalculatedText(script, waitChar > 0), waitChar);
        this.channel.actionTerminated(status);
        return text.getCalculated();
    }

    private void waitAnimation(int loop) {
        Rectangle rect;
        if (loop > 0 && (rect = this.engine.getBoundRect(this)) != null) {
            this.channel.sleep(100);
            if (rect.equals(this.engine.getBoundRect(this))) {
                this.getFoundElement().updateBounding(rect.getX(), rect.getY(), this.channel, rect.getWidth(), rect.getHeight());
            } else {
                this.channel.sendLog(50, "Element is moving, wait before execute action", --loop);
                this.waitAnimation(loop);
            }
        }
    }

    private void waitTextInteractable(int loop, ActionStatus status, ArrayList<SendKeyData> text, int waitChar) {
        long start = System.currentTimeMillis();
        String errorMessage = null;
        while (loop > 0) {
            try {
                this.engine.sendTextData(status, this, text, waitChar);
                return;
            }
            catch (ElementNotInteractableException e) {
                errorMessage = e.getMessage();
                this.channel.sendLog(50, "Element is not interactable, wait before try action again", --loop);
                this.channel.sleep(300);
            }
        }
        this.channel.sleep(200);
        status.setError(-3, errorMessage, start);
    }

    private void waitInteractable(int loop, ActionStatus status) {
        long start = System.currentTimeMillis();
        String errorMessage = null;
        while (loop > 0) {
            try {
                this.engine.mouseMoveToElement(this.getFoundElement());
                return;
            }
            catch (ElementNotInteractableException e) {
                errorMessage = e.getMessage();
                this.channel.sendLog(50, "Element is not interactable, wait before try action again", --loop);
                this.channel.sleep(300);
            }
        }
        this.channel.sleep(200);
        status.setError(-3, errorMessage, start);
    }

    private void waitSelectInteractable(int loop, ActionStatus status, CalculatedProperty selectProperty) {
        long start = System.currentTimeMillis();
        String errorMessage = null;
        while (loop > 0) {
            try {
                this.engine.selectOptionsItem(status, this, selectProperty);
                return;
            }
            catch (ElementNotInteractableException e) {
                errorMessage = e.getMessage();
                this.channel.sendLog(50, "Element is not interactable, wait before try action again", --loop);
                this.channel.sleep(300);
            }
        }
        this.channel.sleep(200);
        status.setError(-3, errorMessage, start);
    }

    public void select(ActionStatus status, CalculatedProperty selectProperty) {
        if (this.isValidated()) {
            this.waitSelectInteractable(this.maxTry, status, selectProperty);
        }
    }

    public void over(ActionStatus status, MouseDirection position, boolean desktopDragDrop, int offsetX, int offsetY) {
        this.waitAnimation(this.maxTryInteractable);
        this.waitInteractable(this.maxTry, status);
        if (status.isPassed()) {
            this.engine.mouseMoveToElement(status, this.getFoundElement(), position, desktopDragDrop, offsetX, offsetY);
        }
    }

    public void click(ActionStatus status, MouseDirection position, Keys key) {
        this.engine.keyDown(key);
        this.click(status, position);
        this.engine.keyUp(key);
    }

    public void click(ActionStatus status, MouseDirection position) {
        this.mouseClick(status, position, 0, 0);
        for (int tryLoop = this.maxTry; tryLoop > 0 && !status.isPassed(); --tryLoop) {
            this.channel.progressiveWait(tryLoop);
            this.mouseClick(status, position, 0, 0);
        }
    }

    protected void mouseClick(ActionStatus status, MouseDirection position, int offsetX, int offsetY) {
        this.engine.mouseClick(status, this.getFoundElement(), position, offsetX, offsetY);
        this.channel.actionTerminated(status);
    }

    public void drag(ActionStatus status, MouseDirection md, int offsetX, int offsetY) {
        this.engine.drag(status, this.getFoundElement(), md, offsetX, offsetY);
        this.channel.actionTerminated(status);
    }

    public void drop(ActionStatus status, MouseDirection md, boolean desktopDragDrop) {
        this.engine.drop(md, desktopDragDrop);
        status.setPassed(true);
    }

    public void swipe(ActionStatus status, MouseDirection position, MouseDirection direction) {
        this.drag(status, position, 0, 0);
        this.engine.moveByOffset(direction.getHorizontalDirection(), direction.getVerticalDirection());
        this.drop(status, null, false);
    }

    public void swipe(int direction) {
        this.drag(null, new MouseDirection(), 0, 0);
        this.engine.moveByOffset(0, direction);
    }

    public void mouseWheel(int delta) {
        this.engine.scroll(this.getFoundElement(), delta);
    }

    public void wheelClick(ActionStatus status, MouseDirection position) {
        this.engine.middleClick(status, position, this);
    }

    public void doubleClick() {
        this.engine.doubleClick();
    }

    public void rightClick() {
        this.engine.rightClick();
    }

    public void tap(int count) {
        this.engine.tap(count, this.getFoundElement());
    }

    public void press(int duration, ArrayList<String> paths) {
        this.engine.press(duration, paths, this.getFoundElement());
    }

    protected CalculatedProperty getAtsProperty(String name) {
        return new CalculatedProperty(name, new CalculatedValue(this.getAtsAttribute(name)));
    }

    protected String getAtsAttribute(String name) {
        if (ATS_OCCURRENCES.equals(name)) {
            return String.valueOf(this.count);
        }
        if (ATS_OCCURRENCES_INDEX.equals(name)) {
            return String.valueOf(this.index);
        }
        if (ATS_TABLE_DATA.equals(name)) {
            return this.getTableData();
        }
        if (ATS_MAX_TRY.equals(name)) {
            return String.valueOf(this.maxTry);
        }
        if (ATS_SEARCH_DURATION.equals(name)) {
            return String.valueOf(this.totalSearchDuration);
        }
        if (ATS_SEARCH_TAG.equals(name)) {
            return this.searchedTag;
        }
        return null;
    }

    protected String getAtsAttributeNotFound(String name) {
        if (ATS_OCCURRENCES.equals(name)) {
            return "0";
        }
        if (ATS_OCCURRENCES_INDEX.equals(name)) {
            return "-1";
        }
        if (ATS_TABLE_DATA.equals(name)) {
            return "";
        }
        if (ATS_MAX_TRY.equals(name)) {
            return String.valueOf(this.maxTry);
        }
        if (ATS_SEARCH_DURATION.equals(name)) {
            return String.valueOf(this.totalSearchDuration);
        }
        if (ATS_SEARCH_TAG.equals(name)) {
            return this.searchedTag;
        }
        return "";
    }

    protected String getTableData() {
        JsonArray dataArray = new JsonArray();
        this.getTextData().parallelStream().forEach(l -> this.addJsonData(dataArray, l.getList()));
        return dataArray.toString();
    }

    private void addJsonData(JsonArray array, List<Parameter> pl) {
        JsonObject jso = new JsonObject();
        pl.parallelStream().forEach(p -> jso.addProperty(p.getName(), p.getCalculated()));
        array.add((JsonElement)jso);
    }

    public String getAttribute(ActionStatus status, String name) {
        FoundElement element = this.getFoundElement();
        if (element == null) {
            return this.getAtsAttributeNotFound(name);
        }
        String attr = this.getAtsAttribute(name);
        if (attr != null) {
            return attr;
        }
        if (this.isValidated()) {
            return this.engine.getAttribute(status, element, name, this.maxTry);
        }
        return null;
    }

    public CalculatedProperty[] getAttributes(boolean reload) {
        CalculatedProperty[] props = this.engine.getAttributes(this.getFoundElement(), reload);
        CalculatedProperty[] result = new CalculatedProperty[props.length + 5];
        result[0] = this.getAtsProperty(ATS_OCCURRENCES);
        result[1] = this.getAtsProperty(ATS_OCCURRENCES_INDEX);
        result[2] = this.getAtsProperty(ATS_TABLE_DATA);
        result[3] = this.getAtsProperty(ATS_MAX_TRY);
        result[4] = this.getAtsProperty(ATS_SEARCH_DURATION);
        result[5] = this.getAtsProperty(ATS_SEARCH_TAG);
        int pos = 5;
        CalculatedProperty[] calculatedPropertyArray = props;
        int n = calculatedPropertyArray.length;
        for (int i = 0; i < n; ++i) {
            CalculatedProperty prop;
            result[pos] = prop = calculatedPropertyArray[i];
            ++pos;
        }
        return result;
    }

    public CalculatedProperty[] getCssAttributes() {
        return this.engine.getCssAttributes(this.getFoundElement());
    }

    public List<ParameterList> getTextData() {
        ArrayList<ParameterList> result = new ArrayList<ParameterList>();
        if (this.getFoundElements().size() > 1 && this.index == 0) {
            this.getFoundElements().parallelStream().forEach(e -> TestElement.addParameters(result, this.engine.getAttributes((FoundElement)e, true)));
        } else if ("select".equalsIgnoreCase(this.getFoundElement().getTag())) {
            List<String[]> options = this.engine.loadSelectOptions(this);
            if (options.size() > 0) {
                for (String[] option : options) {
                    if (option.length > 0) {
                        ParameterList plist = new ParameterList(option.length);
                        for (int i = 0; i < option.length; ++i) {
                            plist.addParameter(new Parameter(i, option[i]));
                        }
                        result.add(plist);
                        continue;
                    }
                    result.add(new ParameterList(0, Arrays.asList(new Parameter(0, ""))));
                }
            } else {
                result.add(new ParameterList(0, Arrays.asList(new Parameter(0, ""))));
            }
        } else {
            String data = this.getFoundElement().getInnerText();
            if (data != null && data.length() > 0) {
                String[] lines = data.split("\n");
                if (lines.length > 0) {
                    for (String l : lines) {
                        String[] cols = l.split("\t");
                        if (cols.length > 0) {
                            ParameterList plist = new ParameterList(cols.length);
                            for (int i = 0; i < cols.length; ++i) {
                                plist.addParameter(new Parameter(i, cols[i]));
                            }
                            result.add(plist);
                            continue;
                        }
                        result.add(new ParameterList(0, Arrays.asList(new Parameter(0, ""))));
                    }
                } else {
                    result.add(new ParameterList(0, Arrays.asList(new Parameter(0, ""))));
                }
            } else {
                result.add(new ParameterList(0, Arrays.asList(new Parameter(0, ""))));
            }
        }
        return Collections.unmodifiableList(result);
    }

    private static void addParameters(ArrayList<ParameterList> result, CalculatedProperty[] properties) {
        ParameterList plist = new ParameterList(properties.length);
        for (int i = 0; i < properties.length; ++i) {
            plist.addParameter(new Parameter(i, properties[i]));
        }
        result.add(plist);
    }

    public Object executeScript(ActionStatus status, String script, boolean returnValue) {
        if (this.isValidated()) {
            return this.engine.executeJavaScript(status, script, this);
        }
        return null;
    }

    public void terminateExecution(ActionStatus status, ActionTestScript script, int error, long duration) {
        this.recorder = script.getRecorder();
        this.recorder.update(error, duration, this);
        this.channel.actionTerminated(status);
    }

    public void terminateExecution(ActionStatus status, ActionTestScript script, int error, long duration, String value, String data) {
        this.recorder = script.getRecorder();
        this.recorder.update(error, duration, value, data, this);
        this.channel.actionTerminated(status);
    }

    public void updateScreen() {
        this.recorder.updateScreen(this);
    }

    public void updateScreen(ActionStatus status, IVisualRecorder rec) {
        rec.updateScreen(status);
    }
}

