/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor;

import com.ats.generator.ATS;
import com.ats.tools.report.CampaignReportGenerator;
import com.ats.tools.report.SuitesReport;
import com.ats.tools.report.SuitesReportItem;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.testng.IExecutionListener;
import org.xml.sax.SAXException;

public class ExecutionListener
implements IExecutionListener {
    private static final String[] JASPER_PROPERTY_NAME = new String[]{"jasper", "jasper.home", "jasper-home"};
    private static final String JASPER_HOME_ENVIRONMENT = "JASPER_HOME";
    private static final String ATS_JSON_SUITES = "atsJsonSuitesFile";
    private static final String ATS_OUTPUT_FOLDER = "atsOutputFolder";
    private static final Gson gson = new Gson();

    private static File getSuitesFile() {
        String filePath = System.getProperty(ATS_JSON_SUITES);
        if (filePath != null && !filePath.isBlank()) {
            return Paths.get(filePath, new String[0]).toFile();
        }
        return null;
    }

    private static void setSuitesFile(File value) {
        System.setProperty(ATS_JSON_SUITES, value.getAbsolutePath());
        File outputDir = value.getParentFile();
        outputDir.mkdirs();
        System.setProperty(ATS_OUTPUT_FOLDER, outputDir.getAbsolutePath());
    }

    private static String getOutputFolderPath() {
        return System.getProperty(ATS_OUTPUT_FOLDER);
    }

    public static void startSuite(SuitesReportItem suiteItem) {
        SuitesReport suiteReport = null;
        try {
            File jsonSuiteFile = ExecutionListener.getSuitesFile();
            if (jsonSuiteFile == null) {
                jsonSuiteFile = suiteItem.getSuitesFile();
                ExecutionListener.setSuitesFile(jsonSuiteFile);
                suiteReport = new SuitesReport(suiteItem);
            } else {
                JsonReader reader = new JsonReader((Reader)new FileReader(jsonSuiteFile));
                suiteReport = (SuitesReport)gson.fromJson(reader, SuitesReport.class);
                reader.close();
                suiteReport.add(suiteItem);
            }
            FileWriter writer = new FileWriter(jsonSuiteFile);
            gson.toJson((Object)suiteReport, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void onExecutionStart() {
        super.onExecutionStart();
        System.out.println("[ATS-SCRIPT] -------------------------------------");
        System.out.println("[ATS-SCRIPT]      ATS " + ATS.VERSION + " execution start");
        System.out.println("[ATS-SCRIPT] -------------------------------------");
    }

    public void onExecutionFinish() {
        super.onExecutionFinish();
        System.out.println("[ATS-SCRIPT] ----------------------------------");
        System.out.println("[ATS-SCRIPT]       ATS execution complete");
        System.out.println("[ATS-SCRIPT] ----------------------------------");
        String outputFolder = ExecutionListener.getOutputFolderPath();
        Path outputFolderPath = Paths.get(outputFolder, new String[0]);
        String atsReport = System.getProperty("ats-report");
        if (atsReport != null) {
            System.out.println("[ATS-SCRIPT] Generate ATS report -> " + outputFolder);
            File jsonSuiteFile = ExecutionListener.getSuitesFile();
            if (jsonSuiteFile != null && jsonSuiteFile.exists()) {
                String s;
                String jasperHome = null;
                String[] stringArray = JASPER_PROPERTY_NAME;
                int n = stringArray.length;
                for (int i = 0; i < n && ((jasperHome = System.getProperty(s = stringArray[i])) == null || jasperHome.length() <= 0); ++i) {
                }
                if (jasperHome == null) {
                    jasperHome = System.getenv(JASPER_HOME_ENVIRONMENT);
                }
                try {
                    new CampaignReportGenerator(outputFolderPath, jsonSuiteFile, atsReport, jasperHome);
                }
                catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

