/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.openqa.selenium.Keys;

public class SendKeyData {
    public static final String EMPTY_DATA = "&empty;";
    private static final String KEY_DOWN_SHIFT = "SHIFT";
    private static final String KEY_DOWN_ALT = "ALT";
    private static final String KEY_DOWN_CONTROL = "CONTROL";
    private static final String KEY_PREFIX = "$KEY-";
    private String data;
    private boolean enterKey = false;
    private Keys downKey;
    private String specialKeyString;
    private StringBuffer specialKeys;

    public SendKeyData(String key, String spare) {
        this.data = spare;
        this.downKey = null;
        StringBuffer sequence = new StringBuffer();
        if (spare != null && spare.length() > 0) {
            if (KEY_DOWN_SHIFT.equals(key)) {
                sequence.append((CharSequence)Keys.SHIFT);
                this.downKey = Keys.SHIFT;
            } else if (KEY_DOWN_ALT.equals(key)) {
                sequence.append((CharSequence)Keys.ALT);
                this.downKey = Keys.ALT;
            } else if (KEY_DOWN_CONTROL.equals(key)) {
                sequence.append((CharSequence)Keys.CONTROL);
                this.enterKey = true;
                this.downKey = Keys.CONTROL;
            }
            sequence.append(spare.toLowerCase());
        } else {
            try {
                sequence.append((CharSequence)Keys.valueOf((String)key));
                this.specialKeyString = KEY_PREFIX + key;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (sequence.length() > 0) {
            this.specialKeys = sequence;
        }
    }

    public SendKeyData(String data) {
        char[] dataArray = data.toCharArray();
        StringBuffer sequence = new StringBuffer();
        this.data = "";
        for (char val : dataArray) {
            Keys k = Keys.getKeyFromUnicode((char)val);
            if (k != null) {
                switch (k.name()) {
                    case "CONTROL": {
                        this.enterKey = true;
                        this.downKey = Keys.CONTROL;
                        break;
                    }
                    case "SHIFT": {
                        this.downKey = Keys.SHIFT;
                        break;
                    }
                    case "ALT": {
                        this.downKey = Keys.ALT;
                    }
                }
                continue;
            }
            sequence.append(val);
            this.data = this.data + String.valueOf(val);
        }
    }

    private Keys getNumpad(char d) {
        switch (Character.getNumericValue(d)) {
            case 1: {
                return Keys.NUMPAD1;
            }
            case 2: {
                return Keys.NUMPAD2;
            }
            case 3: {
                return Keys.NUMPAD3;
            }
            case 4: {
                return Keys.NUMPAD4;
            }
            case 5: {
                return Keys.NUMPAD5;
            }
            case 6: {
                return Keys.NUMPAD6;
            }
            case 7: {
                return Keys.NUMPAD7;
            }
            case 8: {
                return Keys.NUMPAD8;
            }
            case 9: {
                return Keys.NUMPAD9;
            }
        }
        return Keys.NUMPAD0;
    }

    public String getData() {
        return this.data;
    }

    public boolean isEnterKey() {
        return this.enterKey;
    }

    public Keys getDownKey() {
        return this.downKey;
    }

    public CharSequence getSequenceWeb(boolean withDigit) {
        if (this.specialKeys != null) {
            return this.specialKeys;
        }
        StringBuffer sequence = new StringBuffer();
        int n = this.data.length();
        for (int i = 0; i < n; ++i) {
            char c = this.data.charAt(i);
            if (withDigit && Character.isDigit(c)) {
                sequence.append((CharSequence)this.getNumpad(c));
                continue;
            }
            sequence.append(c);
        }
        return sequence;
    }

    public String getSequenceDesktop() {
        String sequenceData = "";
        if (this.specialKeyString != null) {
            sequenceData = this.specialKeyString;
        } else if (this.data.length() > 0) {
            sequenceData = this.data;
        }
        return Base64.getEncoder().encodeToString(sequenceData.getBytes(StandardCharsets.UTF_8));
    }

    public String getSequenceMobile() {
        if (this.specialKeyString != null) {
            return this.specialKeyString;
        }
        if (this.data.length() > 0) {
            return this.data;
        }
        return EMPTY_DATA;
    }
}

