/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.webservices;

import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.engines.webservices.ApiExecutor;
import com.ats.executor.drivers.engines.webservices.AtsCookieJar;
import com.ats.script.actions.ActionApi;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class RestApiExecutor
extends ApiExecutor {
    private static final String contentTypeHeader = "Content-Type";

    public RestApiExecutor(PrintStream logStream, AtsCookieJar cookieJar, OkHttpClient client, int timeout, int maxTry, Channel channel, String wsUrl) {
        super(logStream, cookieJar, client, timeout, maxTry, channel);
        if (!((String)wsUrl).endsWith("/")) {
            wsUrl = (String)wsUrl + "/";
        }
        this.setUri((String)wsUrl);
    }

    private String getContentType(String value) {
        if ((value = value.trim()).startsWith("[") && value.endsWith("]") || value.startsWith("{") && value.endsWith("}")) {
            return "application/json";
        }
        if (value.startsWith("<") && value.endsWith(">")) {
            return "application/xml";
        }
        return "application/x-www-form-urlencoded";
    }

    @Override
    public void execute(ActionStatus status, ActionApi api) {
        super.execute(status, api);
        String fullUri = this.getMethodUri().toString();
        Object parameters = "";
        if (api.getData() != null) {
            parameters = api.getData().getCalculated();
        }
        boolean addContentType = true;
        Request.Builder requestBuilder = new Request.Builder();
        for (Map.Entry header : this.headerProperties.entrySet()) {
            if (contentTypeHeader.equals(header.getKey())) {
                addContentType = false;
            }
            requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
        }
        String apiType = api.getType().toUpperCase();
        if ("GET".equals(apiType) || "DELETE".equals(apiType)) {
            if (((String)parameters).length() > 0) {
                parameters = "/" + URLEncoder.encode((String)parameters, StandardCharsets.UTF_8);
            }
            requestBuilder.url(fullUri + (String)parameters);
            if ("GET".equals(apiType)) {
                requestBuilder.get();
            } else {
                requestBuilder.delete();
            }
        } else {
            requestBuilder.url(fullUri);
            if (addContentType) {
                requestBuilder.addHeader(contentTypeHeader, this.getContentType((String)parameters));
            }
            RequestBody body = RequestBody.create(null, (String)parameters);
            if ("PATCH".equals(apiType)) {
                requestBuilder.patch(body);
            } else if ("PUT".equals(apiType)) {
                requestBuilder.put(body);
            } else {
                requestBuilder.post(body);
            }
        }
        this.executeRequest(status, requestBuilder.build());
    }
}

