/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.element.AtsBaseElement;
import com.ats.executor.ActionStatus;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.tools.Operators;
import com.ats.tools.Utils;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.function.Predicate;

public class CalculatedProperty
implements Comparable<CalculatedProperty> {
    private final String defaultName = "name";
    private CalculatedValue value;
    private String name = "name";
    private Operators operatorExec = new Operators();

    public CalculatedProperty() {
    }

    public CalculatedProperty(Script script, String data) {
        String[] operatorData = this.operatorExec.initData(data);
        this.setName(operatorData[0]);
        this.setValue(new CalculatedValue(script, operatorData[1]));
    }

    public CalculatedProperty(String name, String data) {
        this.setName(name);
        this.setValue(new CalculatedValue(data));
    }

    public CalculatedProperty(String operator, String name, CalculatedValue value) {
        this.setOperator(operator);
        this.setName(name);
        this.setValue(value);
    }

    public CalculatedProperty(String name, CalculatedValue calc) {
        this.setName(name);
        this.setValue(calc);
    }

    public void dispose() {
        this.value.dispose();
        this.value = null;
    }

    public String getJavaCode() {
        return "prp(" + this.operatorExec.getJavaCode() + ", \"" + this.name + "\", " + this.value.getJavaCode() + ")";
    }

    public Predicate<AtsBaseElement> getPredicate(Predicate<AtsBaseElement> predicate) {
        return this.operatorExec.getPredicate(predicate, this.name, this.value);
    }

    public int checkProperty(ActionStatus status, String data) {
        String errorDescription = this.operatorExec.check(data, this.value.getCalculated());
        String shortValue = Utils.truncateString(data, 200);
        if (errorDescription == null) {
            status.setNoError(shortValue);
            return 0;
        }
        StringBuilder builder = new StringBuilder("property '");
        builder.append(this.name).append("' with actual value '").append(shortValue).append("' ").append(errorDescription).append(" '").append(this.value.getCalculated()).append("'");
        status.setError(-6, builder.toString(), new String[]{shortValue, this.getValue().getCalculated()});
        return -6;
    }

    public String getExpectedResult() {
        String result = this.getName();
        if (this.isRegexp()) {
            return result + " match " + this.getValue().getCalculated();
        }
        return result + " == " + this.getValue().getCalculated();
    }

    public boolean isRegexp() {
        return this.operatorExec.isRegexp();
    }

    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = new ArrayList<String>();
        keywords.add(this.name);
        keywords.add(this.value.getKeywords());
        return keywords;
    }

    public String getOperator() {
        return this.operatorExec.getType();
    }

    public void setOperator(String operator) {
        this.operatorExec.setType(operator);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!Strings.isNullOrEmpty((String)name)) {
            this.name = name;
        }
    }

    public CalculatedValue getValue() {
        return this.value;
    }

    public void setValue(CalculatedValue value) {
        this.value = value;
        this.operatorExec.updatePattern(value.getCalculated());
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(CalculatedProperty prop) {
        return this.toString().compareTo(prop.toString());
    }
}

