/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables;

import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.Variable;
import com.ats.script.Script;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ConditionalValue {
    public static final String EQUALS = "=";
    public static final String DIFFERENT = "<>";
    private Variable variable;
    private String operator = "=";
    private CalculatedValue value;
    private boolean exec = false;

    public ConditionalValue(Script script, String variableName, String value) {
        this.setVariable(script.getVariable(variableName, false));
        this.setValue(new CalculatedValue(script, value));
    }

    public ConditionalValue(Script script, String variableName, String value, String operator) {
        this(script, variableName, value);
        this.setOperator(operator);
    }

    public ConditionalValue(String op, Variable va, CalculatedValue cv) {
        this.operator = op;
        this.variable = va;
        this.value = cv;
    }

    public boolean isExec() {
        boolean isEquals = this.variable.getCalculatedValue().equals(this.value.getCalculated());
        this.exec = isEquals && EQUALS.equals(this.operator) || !isEquals && DIFFERENT.equals(this.operator);
        return this.exec;
    }

    public JsonObject getLog() {
        return this.getLog(new JsonObject());
    }

    public JsonObject getLog(JsonObject log) {
        JsonObject varData = new JsonObject();
        varData.addProperty(this.variable.getName(), this.variable.getCalculatedValue());
        JsonObject compareData = new JsonObject();
        compareData.addProperty("operator", this.operator);
        compareData.addProperty("value", this.value.getCalculated());
        JsonObject data = new JsonObject();
        data.add("variable", (JsonElement)varData);
        data.add("compare", (JsonElement)compareData);
        data.addProperty("continue", Boolean.valueOf(this.exec));
        log.add("condition", (JsonElement)data);
        return log;
    }

    public StringBuilder getJavaCode(StringBuilder builder, int codeLine) {
        StringBuilder codeBuilder = new StringBuilder("if(").append("condition").append("(").append(this.getClass().getSimpleName()).append(".");
        if (DIFFERENT.equals(this.operator)) {
            codeBuilder.append("DIFFERENT");
        } else {
            codeBuilder.append("EQUALS");
        }
        codeBuilder.append(", ").append(codeLine).append(", ").append(this.variable.getName()).append(", ").append(this.value.getJavaCode()).append(")) ").append((CharSequence)builder);
        return codeBuilder;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public CalculatedValue getValue() {
        return this.value;
    }

    public void setValue(CalculatedValue value) {
        this.value = value;
    }
}

