/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.parameter;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.parameter.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class ParameterList {
    private int iteration;
    private List<Parameter> list;

    public ParameterList() {
    }

    public ParameterList(int iteration) {
        this.iteration = iteration;
        this.list = new ArrayList<Parameter>();
    }

    public ParameterList(int iteration, List<Parameter> list) {
        this.iteration = iteration;
        this.list = list;
    }

    public void updateCalculated(ActionTestScript ts) {
        this.list.forEach(p -> p.updateCalculated(ts));
    }

    public void getJavaCode(StringBuilder codeBuilder) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Parameter param : this.list) {
            joiner.add(param.getJavaCode());
        }
        codeBuilder.append(", ").append("prm").append("(").append(joiner.toString()).append(")");
    }

    public void addParameter(Parameter param) {
        this.list.add(param);
    }

    public String getParameterValue(String name, String defaultValue) {
        for (Parameter item : this.list) {
            if (!name.equals(item.getName())) continue;
            return item.getCalculated();
        }
        return defaultValue;
    }

    public String getParameterValue(int index, String defaultValue) {
        if (this.list.size() > index) {
            return this.list.get(index).getCalculated();
        }
        return defaultValue;
    }

    public String[] getParameters() {
        String[] result = new String[this.list.size()];
        int loop = 0;
        for (Parameter item : this.list) {
            result[loop] = item.getValue().getCalculated();
        }
        return result;
    }

    public int getParametersSize() {
        if (this.list != null) {
            return this.list.size();
        }
        return 0;
    }

    public int getIteration() {
        return this.iteration;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public List<Parameter> getList() {
        return this.list;
    }

    public void setList(List<Parameter> list) {
        this.list = list;
    }
}

