/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform;

import com.ats.generator.variables.transform.Transformer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.commons.lang3.StringUtils;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;

public class NumericTransformer
extends Transformer {
    private DecimalFormat formatter = new DecimalFormat();
    private int decimal = -1;
    private boolean comma = false;

    public NumericTransformer() {
    }

    public NumericTransformer(int dp) {
        this.setDecimal(dp);
        this.setComma(false);
    }

    public NumericTransformer(int dp, boolean useComma) {
        this.setDecimal(dp);
        this.setComma(useComma);
    }

    public NumericTransformer(String data) {
        if (data.contains(",")) {
            data = data.replace(",", "");
            this.setComma(true);
        }
        this.setDecimal(this.getInt(data.replace("dp", "").trim()));
    }

    @Override
    public String getJavaCode() {
        return "nm(" + this.decimal + ", " + this.comma + ")";
    }

    @Override
    public String format(String data) {
        this.formatter.setGroupingSize(0);
        data = StringUtils.replace((String)data, (String)" ", (String)"");
        if (data.length() == 0) {
            return "0";
        }
        DecimalFormatSymbols decimalSymbols = DecimalFormatSymbols.getInstance();
        if (this.comma) {
            data = StringUtils.replace((String)data, (String)",", (String)".");
            decimalSymbols.setDecimalSeparator(',');
        } else {
            decimalSymbols.setDecimalSeparator('.');
        }
        this.formatter.setDecimalFormatSymbols(decimalSymbols);
        double calc = new Expression(data, new PrimitiveElement[0]).calculate();
        int fractionDigit = 13;
        if (this.decimal > -1) {
            if (this.decimal < 16) {
                fractionDigit = this.decimal;
            }
            this.formatter.setMinimumFractionDigits(fractionDigit);
            this.formatter.setMaximumFractionDigits(fractionDigit);
        } else {
            this.formatter.setMaximumFractionDigits(fractionDigit);
        }
        String result = this.formatter.format(calc);
        if (this.comma) {
            return StringUtils.replace((String)result, (String)".", (String)",");
        }
        return result;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public boolean getComma() {
        return this.comma;
    }

    public void setComma(boolean value) {
        this.comma = value;
    }
}

