/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.ats.executor.TestBound;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import javax.imageio.ImageIO;

public class VisualImage {
    private byte[] data;
    private String type;
    private boolean drawBound = false;
    private int x;
    private int y;
    private int w;
    private int h;
    private File file;

    public VisualImage(Path folder, String name, String type, byte[] data) {
        this.type = type;
        this.data = data;
        this.file = folder.resolve(name).toFile();
    }

    public VisualImage(Path folder, String name, String type, byte[] data, TestBound bound) {
        this(folder, name, type, data);
        this.drawBound = true;
        this.x = bound.getX().intValue() - 6;
        this.y = bound.getY().intValue() - 7;
        this.w = bound.getWidth().intValue();
        this.h = bound.getHeight().intValue();
    }

    public void save() {
        if (this.data != null && this.data.length > 0) {
            try {
                if (this.drawBound) {
                    BufferedImage buffImage = ImageIO.read(new ByteArrayInputStream(this.data));
                    Graphics2D g2d = buffImage.createGraphics();
                    g2d.setColor(new Color(255, 0, 255));
                    g2d.setStroke(new BasicStroke(3.0f));
                    g2d.drawRect(this.x, this.y, this.w, this.h);
                    g2d.dispose();
                    ImageIO.write((RenderedImage)buffImage, this.type, this.file);
                } else {
                    FileOutputStream fos = new FileOutputStream(this.file);
                    fos.write(this.data);
                    fos.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

