/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.generator.parsers.Lexer;
import com.ats.script.Project;
import com.ats.script.ScriptHeader;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionCallscript;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ScriptInfo {
    private int actions = 0;
    private int callscripts = 0;
    private String author;
    private String description;
    private String id;
    private List<String> groups;
    private String prerequisite;
    private Date createdAt;
    private Date modifiedAt;
    private String name;
    private String packageName;
    private String nativePath;
    private long size;

    public ScriptInfo(ScriptHeader header, File f) {
        this.author = header.getAuthor();
        this.description = header.getDescription();
        this.id = header.getId();
        this.groups = header.getGroups();
        this.prerequisite = header.getPrerequisite();
        this.createdAt = header.getCreatedAt();
        this.packageName = header.getPackageName();
        this.name = header.getName();
        this.size = f.length();
        this.modifiedAt = new Date(f.lastModified());
        this.nativePath = f.getAbsolutePath();
    }

    public ScriptInfo(ScriptHeader header) {
        this(header, new File(header.getPath()));
    }

    public ScriptInfo(Lexer lexer, File f) {
        this(lexer.loadScript(f), f);
    }

    public ScriptInfo(ScriptLoader sc, File f) {
        this(sc.getHeader(), f);
        Arrays.asList(sc.getActions()).parallelStream().forEach(this::count);
    }

    public ScriptInfo(Project project, File scriptFile) {
        this(new ScriptHeader(project, scriptFile), scriptFile);
    }

    private void count(Action a) {
        if (a instanceof ActionCallscript) {
            ++this.callscripts;
        } else {
            ++this.actions;
        }
    }

    public int getActions() {
        return this.actions;
    }

    public void setActions(int actions) {
        this.actions = actions;
    }

    public int getCallscripts() {
        return this.callscripts;
    }

    public void setCallscripts(int callscripts) {
        this.callscripts = callscripts;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(String prerequisite) {
        this.prerequisite = prerequisite;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getNativePath() {
        return this.nativePath;
    }

    public void setNativePath(String nativePath) {
        this.nativePath = nativePath;
    }
}

