/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.driver.AtsManager;
import com.ats.element.SearchedElement;
import com.ats.element.TestElement;
import com.ats.element.TestElementDialog;
import com.ats.element.TestElementImage;
import com.ats.element.TestElementRoot;
import com.ats.element.TestElementSystem;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElementAbstract;
import com.google.gson.JsonObject;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;

public class ActionExecuteElement
extends ActionExecuteElementAbstract {
    private static final String ELEMENT_NOT_FOUND_MESSAGE = "Element not found, wait and try again";
    private SearchedElement searchElement;
    private TestElement testElement;
    private boolean async;
    private int actionMaxTry;

    public ActionExecuteElement() {
    }

    public ActionExecuteElement(Script script, int stopPolicy, ArrayList<String> options, ArrayList<String> element) {
        super(script, stopPolicy, options);
        if (element != null && element.size() > 0) {
            this.setSearchElement(new SearchedElement(script, element));
        }
    }

    public ActionExecuteElement(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element) {
        super(script, stopPolicy, maxTry, delay);
        this.setSearchElement(element);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        if (this.searchElement == null) {
            codeBuilder.append("null");
        } else {
            codeBuilder.append(this.searchElement.getJavaCode());
        }
        return codeBuilder;
    }

    @Override
    public boolean execute(ActionTestScript ts, String testName, int testLine) {
        for (int maxTry = AtsManager.getMaxStaleOrJavaScriptError(); maxTry > 0; --maxTry) {
            try {
                this.execute(ts, testName, testLine, ">", 0);
                return true;
            }
            catch (JavascriptException e) {
                ts.getTopScript().sendWarningLog("Javascript error", "try again : " + maxTry);
                this.status.setException(-13, (Exception)((Object)e));
            }
            catch (StaleElementReferenceException e) {
                ts.getTopScript().sendWarningLog("StaleReference error", "try again : " + maxTry);
                this.status.setException(-16, (Exception)((Object)e));
            }
            ts.getCurrentChannel().sleep(500);
            this.setTestElement(null);
        }
        throw new WebDriverException("execute element error : " + this.status.getFailMessage());
    }

    public void execute(ActionTestScript ts, String testName, int testLine, String operator, int value) {
        super.execute(ts, testName, testLine);
        if (this.status.isPassed()) {
            Channel channel = this.getCurrentChannel();
            int delay = this.getDelay();
            if (delay > 0) {
                ts.getTopScript().sendInfoLog("Delay before action", delay + "s");
                channel.sleep(delay * 1000);
            }
            this.actionMaxTry = ts.getChannelManager().getMaxTry() + this.getMaxTry();
            if (this.actionMaxTry < 1) {
                this.actionMaxTry = 1;
            }
            if (this.testElement == null) {
                if (this.searchElement == null) {
                    this.setTestElement(new TestElementRoot(channel));
                } else {
                    int trySearch = 0;
                    Predicate<Integer> predicate = this.getPredicate(operator, value);
                    if (this.searchElement.isDialog()) {
                        while (trySearch < this.actionMaxTry) {
                            this.setTestElement(new TestElementDialog(channel, this.actionMaxTry, this.searchElement, predicate));
                            if (this.testElement.isValidated()) {
                                trySearch = this.actionMaxTry;
                                continue;
                            }
                            channel.sendLog(50, ELEMENT_NOT_FOUND_MESSAGE, this.actionMaxTry - ++trySearch);
                            channel.progressiveWait(trySearch);
                        }
                    } else if (this.searchElement.isSysComp()) {
                        while (trySearch < this.actionMaxTry) {
                            this.setTestElement(new TestElementSystem(channel, this.actionMaxTry, predicate, this.searchElement));
                            if (this.testElement.isValidated()) {
                                trySearch = this.actionMaxTry;
                                continue;
                            }
                            channel.sendLog(50, ELEMENT_NOT_FOUND_MESSAGE, this.actionMaxTry - ++trySearch);
                            channel.progressiveWait(trySearch);
                        }
                    } else {
                        SearchedElement parent = this.searchElement.getParent();
                        if (parent != null && parent.isScrollable()) {
                            TestElement parentElement = new TestElement(channel, this.actionMaxTry, predicate, parent);
                            Rectangle parentRect = parentElement.getFoundElement().getRectangle();
                            int tryScrollSearch = 0;
                            int tryScrollSearchMax = ts.getChannelManager().getMaxTryScroll();
                            while (tryScrollSearch < tryScrollSearchMax) {
                                if (tryScrollSearch > 0) {
                                    parentElement.swipe(-200);
                                    channel.sleep(2000);
                                }
                                if (this.searchElement.isImageSearch()) {
                                    this.setTestElement(new TestElementImage(channel, 1, predicate, this.searchElement));
                                } else {
                                    this.setTestElement(new TestElement(channel, 1, predicate, this.searchElement));
                                }
                                if (this.testElement.isValidated() && parentRect.contains(this.testElement.getFoundElement().getRectangle())) {
                                    tryScrollSearch = tryScrollSearchMax;
                                    continue;
                                }
                                parentElement = new TestElement(channel, this.actionMaxTry, predicate, parent);
                                ++tryScrollSearch;
                            }
                        } else {
                            while (trySearch < this.actionMaxTry) {
                                if (this.searchElement.isImageSearch()) {
                                    this.setTestElement(new TestElementImage(channel, this.actionMaxTry, predicate, this.searchElement));
                                } else {
                                    this.setTestElement(new TestElement(channel, this.actionMaxTry, predicate, this.searchElement));
                                }
                                if (this.testElement.isValidated()) {
                                    trySearch = this.actionMaxTry;
                                    continue;
                                }
                                channel.sendLog(50, ELEMENT_NOT_FOUND_MESSAGE, this.actionMaxTry - ++trySearch);
                                channel.progressiveWait(trySearch);
                            }
                        }
                    }
                }
                this.status.setElement(this.testElement);
                this.status.setSearchDuration(this.testElement.getTotalSearchDuration());
                this.status.setData(this.testElement.getCount());
                ts.getCurrentChannel().sleep(this.getDelay());
                this.asyncExec(ts);
            } else {
                this.terminateExecution(ts);
            }
        }
    }

    private Predicate<Integer> getPredicate(String operator, int value) {
        switch (operator) {
            case "<>": {
                return p -> p != value;
            }
            case ">": {
                return p -> p > value;
            }
            case ">=": {
                return p -> p >= value;
            }
            case "<": {
                return p -> p < value;
            }
            case "<=": {
                return p -> p <= value;
            }
        }
        return p -> p == value;
    }

    private void asyncExec(ActionTestScript ts) {
        if (!this.async) {
            this.terminateExecution(ts);
        }
    }

    public void terminateExecution(ActionTestScript ts) {
        int error = 0;
        if (this.testElement.isValidated()) {
            this.status.setPassed(true);
        } else {
            this.status.setError(-1, this.testElement.getNotFoundDescription());
            error = -1;
        }
        this.status.endDuration();
        this.testElement.terminateExecution(this.status, ts, error, this.status.getDuration());
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("searchDuration", (Number)this.status.getSearchDuration());
        data.addProperty("delay", (Number)this.getDelay());
        data.addProperty("occurrences", (Number)this.status.getElement().getCount());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        if (this.searchElement != null) {
            keywords.addAll(this.searchElement.getKeywords());
        }
        return keywords;
    }

    public SearchedElement getSearchElement() {
        return this.searchElement;
    }

    public void setSearchElement(SearchedElement value) {
        this.searchElement = value;
    }

    public TestElement getTestElement() {
        return this.testElement;
    }

    private void setTestElement(TestElement element) {
        if (this.testElement != null) {
            this.testElement.dispose();
        }
        this.testElement = element;
    }

    public int getActionMaxTry() {
        return this.actionMaxTry;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean value) {
        this.async = value;
    }
}

