/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionExecuteElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionSelect
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL_SELECT = "select";
    public static final String SELECT_TEXT = "text";
    public static final String SELECT_VALUE = "value";
    public static final String SELECT_INDEX = "index";
    private CalculatedProperty selectValue;

    public ActionSelect() {
    }

    public ActionSelect(ScriptLoader script, String data, int stopPolicy, ArrayList<String> options, ArrayList<String> objectArray) {
        super((Script)script, stopPolicy, options, objectArray);
        this.setSelectValue(new CalculatedProperty(script, data));
    }

    public ActionSelect(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedProperty selectValue) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setSelectValue(selectValue);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(", ").append(this.selectValue.getJavaCode()).append(")");
        return codeBuilder;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            this.getTestElement().over(this.status, new MouseDirection(), false, 0, 0);
            ts.getRecorder().updateScreen(this.status);
            this.getTestElement().select(this.status, this.selectValue);
        }
        this.status.endAction();
        ts.getRecorder().updateScreen(this.status);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty(SCRIPT_LABEL_SELECT, this.selectValue.getValue().getCalculated());
        data.addProperty("regexp", Boolean.valueOf(this.selectValue.isRegexp()));
        data.addProperty("name", this.selectValue.getName());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.addAll(this.selectValue.getKeywords());
        return keywords;
    }

    public CalculatedProperty getSelectValue() {
        return this.selectValue;
    }

    public void setSelectValue(CalculatedProperty value) {
        this.selectValue = value;
    }
}

