/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.logger;

import com.ats.script.actions.Action;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.logger.levels.ErrorLevelLogger;
import com.ats.tools.logger.levels.FullLevelLogger;
import com.ats.tools.logger.levels.InfoLevelLogger;
import com.ats.tools.logger.levels.WarningLevelLogger;
import java.io.PrintStream;
import org.testng.Reporter;

public class ExecutionLogger {
    private static final String ERROR_LEVEL = "error";
    private static final String ALL_LEVEL = "all";
    private static final String WARNING_LEVEL = "warning";
    private static final String INFO_LEVEL = "info";
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_RED = "\u001b[31m";
    public static final String ANSI_GREEN = "\u001b[32m";
    public static final String ANSI_YELLOW = "\u001b[33m";
    public static final String ANSI_BLUE = "\u001b[34m";
    private AtsLogger levelLogger;

    public ExecutionLogger() {
        this.levelLogger = new AtsLogger();
    }

    public ExecutionLogger(PrintStream sysout) {
        this(sysout, INFO_LEVEL);
    }

    public ExecutionLogger(PrintStream sysout, String verbose) {
        this.levelLogger = ERROR_LEVEL.equalsIgnoreCase(verbose) ? new ErrorLevelLogger(sysout, "Error") : (INFO_LEVEL.equalsIgnoreCase(verbose) ? new InfoLevelLogger(sysout, "Error + Info") : (WARNING_LEVEL.equalsIgnoreCase(verbose) ? new WarningLevelLogger(sysout, "Error + Info + Warning") : (ALL_LEVEL.equalsIgnoreCase(verbose) ? new FullLevelLogger(sysout, "Error + Info + Warning + Details") : new AtsLogger(sysout, "Disabled"))));
    }

    public void sendLog(int code, String message, Object value) {
        if (code < 100) {
            this.sendInfo(message, value.toString());
        } else if (code < 399) {
            this.sendWarning(message, value.toString());
        } else {
            this.sendError(message, value.toString());
        }
    }

    public void sendExecLog(String type, String message) {
        this.levelLogger.log(type, message);
        Reporter.log((String)("- " + message));
    }

    public void sendAction(Action action, String testName, int line) {
        this.levelLogger.action(action, testName, line);
    }

    public void sendWarning(String message, String value) {
        this.levelLogger.warning(message + " -> " + value);
    }

    public void sendInfo(String message, String value) {
        this.levelLogger.info(message + " -> " + value);
    }

    public void sendError(String message, String value) {
        this.levelLogger.error(message + " -> " + value);
    }
}

