/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.lang.module.ModuleDescriptor;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AtsLauncher {
    private static final String ATS_SERVER = "http://actiontestscript.com";
    private static final String ATS_LAUNCHER_VERSION = "#ATS_LAUNCHER_VERSION#";
    private static final String DEFAULT_ATS_VERSION = "#DEFAULT_ATS_VERSION#";
    private static final String OS_TAG = "#OS#";
    private static final String ATS_VERSION = System.getenv("ATS_VERSION");
    private static final String OS = System.getProperty("os.name").toLowerCase();
    private static final int MINIMUM_JAVA_JDK_VERSION = 17;
    private static final String ATS_RELEASES_DIRECTORY_SERVER = "/releases";
    private static final String ATS_TOOLS_DIRECTORY_SERVER = "/tools/";
    private static final String ATS_JENKINS_TOOLS = "userContent/tools/versions.csv";
    private static final String TARGET = "target";
    private static final String SRC_EXEC = "src/exec";
    private static final String ATS_OUTPUT = "ats-output";
    private static final String BUILD_PROPERTIES = "build.properties";
    private static final String ATS_PROJECT_PROPERTIES = ".atsProjectProperties";
    private static final String LINUX = "linux";
    private static final String WINDOWS = "windows";
    private static final String MACOS = "macos";
    private static final String LINUX_DRIVER_NAME = "linuxdriver";
    private static final String MACOS_DRIVER_NAME = "macosdriver";
    private static final String TGZ = "tgz";
    private static final String ZIP = "zip";
    private static final String ATS = "ats";
    private static final String JDK = "jdk";
    private static final String JASPER = "jasper";
    private static final List<String> TRUE_LIST = Arrays.asList("on", "true", "1", "yes", "y");
    private static final List<String> FALSE_LIST = Arrays.asList("off", "false", "0", "no", "n");
    private static final List<String> REPORT_LEVEL_LIST = Arrays.asList("1", "2", "3");
    private static String operatingSystem = "linux";
    private static String archiveExtension = "tgz";
    private static String suiteFiles = "";
    private static String atsScripts = "";
    private static String tempSuiteName = "tempSuite";
    private static String reportLevel = "";
    private static String validationReport = "0";
    private static String systemDriverUrl = "";
    private static String outputBase = "target/ats-output";
    private static String output = null;
    private static boolean asSuiteExecution = true;
    private static String atsToolsFolderProperty = "atsToolsFolder";
    private static String atsToolsUrlProperty = "atsToolsUrl";
    private static String outboundProperty = "outbound";
    private static String disableSSLParam = "disableSSL";
    private static String htmlReportParam = "1";
    private static String atsToolsFolder = null;
    private static Boolean atsToolsFolderIsDefine = false;
    private static String atsUrl = null;
    private static String atsToolsUrl = null;
    private static String atsServerReleasesUrl = "http://actiontestscript.com/releases";
    private static String atsHomePath = null;
    private static String projectAtsVersion = null;
    private static final String atsEnvHome = System.getenv("ATS_HOME");
    private static String jdkHomePath = null;
    private static String atsFolder = null;
    private static Map<String, String> atsToolsList = new HashMap<String, String>();
    private static ArrayList<AtsToolEnvironment> atsToolsEnvLocal = null;
    private static Map<String, String> atsExecEnv = new HashMap<String, String>();
    private static ArrayList<AtsToolEnvironment> atsToolsEnv = new ArrayList();
    private static String atsHomeInstall = System.getProperty("user.home");
    private static String atsToolsInstall = "/ats/tools";
    private static String atsCacheInstall = "/ats/cache";
    private static String jenkinsToolsUrl = null;
    private static HashMap<String, String> helpMap = new HashMap();
    private static Set<PosixFilePermission> posixFilePermission = null;
    private static Path projectFolderPath = null;
    private static final Pattern SYS_VERSION_PATTERN = Pattern.compile("<a href\\s?=\\s?\"([^\"]+\\.(zip|tgz))\">");
    private static String systemDriverVersion = "";

    public static void main(String[] args) throws Exception, InterruptedException {
        String reportParam;
        Path atsOutput;
        helpMap.put("general", "This script is a Java class used as a simple script file with Java >= 14\nIt will will try to update ATS tools from https://actiontesscript.com server and it will launch ATS suite tests\nusing ATS components downloaded or already installed.\nfor more detail information <command> help : example java AtsLauncher.java atsReport help\nAvailable options for launching ATS suites :\n'clean' : Clean all downloaded ATS components (libs + drivers) already installed on current system\n'prepareMaven' : Prepare 'build.properties' file that maven can use to find ATS tools for ATS tests executions\n'buildEnvironment' : Only try to get ATS tools path and create 'build.properties' file that can be used by Maven launch test process\n'suiteXmlFiles' : Comma separated names of ATS suites xml files in 'exec' folder of current project, to be launched by this script\n'atsReport' : Report details level\n'validationReport' : Generate proof of functional execution with screen-shot\n'atsListScripts' : List of ats scripts that can be launched using a temp suite execution\n'tempSuiteName' : If 'atsListScripts' option is defined this option override default suite name ('tempSuite')\n'disableSsl' : Disable trust certificat check when using ActionTestScript tools server\n'atsUrl' : Alternative url path to ActionTestScript server.\n'atsToolsUrl' : Alternative url path to ActionTestScript tools server.\n'jenkinsUrl' : Url of a Jenkins server with saved ATS tools archives, tools will be available at [Jenkins_Url_Server]/userContent/tools using 'version.csv' files with names, versions and path of ATS tools\n'reportsDirectory' (or 'output') : This is the output folder for all files generated during execution of ATS tests suites\n'outbound' : By default, this script will try to contact ActionTestScript tools server.\n'systemdriverurl' or (system-driver-url) Url or IP address of a remote system driver server with or without port. ex systemdriverurl=192.168.0.1:9700\n\nIn priority, this script will try to find ATS tools on local installation using following ordered methods :\n- 'atsToolsFolder' property in command line. exemple : (linux) atsToolsFolder=/home/user/ats/tools || (windows) atsToolsFolder=C:/ats/tools\n- 'ATS_TOOLS' environment variable set on current machine : (linux) export ATS_TOOLS=/home/user/ats/tools || (windows) set ATS_TOOLS=C:/ats/tools\n- 'atsToolsFolder' property in '.atsProjectProperties' file in current project folder\n\nIn priority, this script will try to find ATS on local installation using following ordered methods :\n- 'ATS_PATH' environment variable set on current machine : (linux) export ATS_PATH=/home/user/ats || (windows) set ATS_TOOLS=C:/ats\n\nAbout '.atsProjectProperties' file in current project folder in xml format :\n- if tag 'atsToolsFolder' found : the value will define the local folder path of ATS tools\n- if tag 'atsToolsUrl' found : the standard ATS tools url server will be overwritten\n- if tag 'outbound' found : if the value is false, off or 0, no request will be send to get ATS tools");
        helpMap.put("clean", "Clean all downloaded ATS components (libs + drivers) already installed on current system");
        helpMap.put("preparemaven", "Prepare 'build.properties' file that maven can use to find ATS tools for ATS tests executions");
        helpMap.put("buildenvironment", "Only try to get ATS tools path and create 'build.properties' file that can be used by Maven launch test process");
        helpMap.put("suitexmlfiles", "Comma separated names of ATS suites xml files in 'exec' folder of current project, to be launched by this script  exemple :\n      suiteXmlfiles=suite  -> will launch 'suite.xml' file in 'exec' folder of current project\n      suiteXmlfiles=suite1,suite2,suite3 -> will launch 'suite1.xml', 'suite2.xml' and 'suite3.xml' files in 'exec' folder of current project*\n");
        helpMap.put("atsreport", "Report details level\n1 - Simple execution report\n2 - Detailed execution report\n3 - Detailed execution report with screen-shot");
        helpMap.put("validationreport", "Generate proof of functional execution with screen-shot\nexemple :\nvalidationReport=true -> will generate proof of functional execution with screen-shot\nvalidationReport=false -> will not generate proof of functional execution with screen-shot (default value)");
        helpMap.put("atslistscripts", "List of ats scripts that can be launched using a temp suite execution");
        helpMap.put("tempsuitename", "If 'atsListScripts' option is defined this option override default suite name ('tempSuite')");
        helpMap.put("disablessl", "Disable trust certificat check when using ActionTestScript tools server");
        helpMap.put("atsurl", "Alternative url path to ActionTestScript server. directory schemas : example : localhost:8080/ats\n           /releases\n              -> ats-libs  : [version].zip\n              -> ats-drivers\n                  -> linux\n                      -> system : [version].tgz\n                  -> windows\n                      -> system : [version].zip\n           /tools\n              -> jasper : [version].zip\n              -> jdk\n                  -> linux : [version].tgz\n                  -> windows : [version].zip\n");
        helpMap.put("atstoolsurl", "Alternative url path to ActionTestScript tools server. directory schemas : exemple : localhost:8080/ats/tools\n              /jasper : [version].zip\n              /jdk\n                  -> linux : [version].tgz\n                  -> windows : [version].zip\n");
        helpMap.put("jenkinsurl", "Url of a Jenkins server with saved ATS tools archives, tools will be available at [Jenkins_Url_Server]/userContent/tools using 'version.csv' files with names, versions and path of ATS tools");
        helpMap.put("reportsdirectory", "(or 'output') : This is the output folder for all files generated during execution of ATS tests suites");
        helpMap.put("outbound", "By default, this script will try to contact ActionTestScript tools server.");
        helpMap.put("atstoolsfolder", "In priority, this script will try to find ATS tools on local installation using following ordered methods :\n- 'atsToolsFolder' property in command line. exemple : (linux) atsToolsFolder=/home/user/ats/tools || (windows) atsToolsFolder=C:/ats/tools\n- 'ATS_TOOLS' environment variable set on current machine : (linux) export ATS_TOOLS=/home/user/ats/tools || (windows) set ATS_TOOLS=C:/ats/tools\n- 'atsToolsFolder' property in '.atsProjectProperties' file in current project folder\n");
        helpMap.put("ats_tools", "Environment variable set on current machine : (linux) export ATS_PATH=/home/user/ats || (windows) set ATS_TOOLS=C:/ats\nthe strucutre directory d'ATS_PATH must be :\n \t/libs\n \t\t-> unzip ats-libs\n \t/drivers\n \t\t-> unzip ats-drivers (system)\n");
        helpMap.put("atsfolder", "In priority, this script will try to find ATS and ATS Tools on local installation using following ordered methods :\n- 'atsFolder' property in command line. example : (linux) atsToolsFolder=/home/user/ats || (windows) atsToolsFolder=C:/ats\natsFolder is priority on ATS_PATH and ATS_TOOLS and atsToolsFolder\nthe strucutre directory d'ATS_PATH must be :\n \t/libs\n \t\t-> unzip ats-libs\n \t/drivers\n \t\t-> unzip ats-drivers (system)\n \t/tools\n \t\t-> jasper : files jasper\n \t\t-> jdk\t: files jdk\n");
        helpMap.put("xml_atsprojectproperties", "About '.atsProjectProperties' file in current project folder in xml format :\n- if tag 'atsToolsFolder' found : the value will define the local folder path of ATS tools\n- if tag 'atsToolsUrl' found : the standard ATS tools url server will be overwritten\n- if tag 'outbound' found : if the value is false, off or 0, no request will be send to get ATS tools");
        helpMap.put("systemdriverurl", "Url or IP address of a remote system driver server with or without port example : \nsystemdriverurl=192.168.0.1:9700 \nsystemdriverurl=192.168.0.1\nsystemdriverurl=http://192.168.0.1\nsystemdriverurl=192.168.0.1:9700");
        AtsLauncher.checkHelp(args, helpMap);
        AtsLauncher.printLog("Execute AtsLauncher script version -> #ATS_LAUNCHER_VERSION#");
        System.setProperty("https.protocols", "TLSv1.2,TLSv1.1,SSLv3");
        String toolsServerUrl = "http://actiontestscript.com/tools/";
        atsToolsList.put(JASPER, JASPER);
        if (OS.contains("win")) {
            atsHomeInstall = System.getenv("APPDATA");
            toolsServerUrl = toolsServerUrl.replace(OS_TAG, WINDOWS);
            operatingSystem = WINDOWS;
            archiveExtension = ZIP;
            atsToolsList.put(JDK, "jdk/windows");
        } else {
            if (OS.contains(LINUX)) {
                toolsServerUrl = toolsServerUrl.replace(OS_TAG, LINUX);
                atsToolsList.put(JDK, "jdk/linux/");
            } else if (OS.contains("mac")) {
                operatingSystem = MACOS;
                toolsServerUrl = toolsServerUrl.replace(OS_TAG, MACOS);
                atsToolsList.put(JDK, "jdk/macos/");
            }
            posixFilePermission = new HashSet<PosixFilePermission>();
            posixFilePermission.add(PosixFilePermission.OWNER_READ);
            posixFilePermission.add(PosixFilePermission.OWNER_WRITE);
            posixFilePermission.add(PosixFilePermission.OWNER_EXECUTE);
            posixFilePermission.add(PosixFilePermission.OTHERS_READ);
            posixFilePermission.add(PosixFilePermission.OTHERS_WRITE);
            posixFilePermission.add(PosixFilePermission.OTHERS_EXECUTE);
            posixFilePermission.add(PosixFilePermission.GROUP_READ);
            posixFilePermission.add(PosixFilePermission.GROUP_WRITE);
            posixFilePermission.add(PosixFilePermission.GROUP_EXECUTE);
        }
        atsToolsInstall = atsHomeInstall + atsToolsInstall;
        atsCacheInstall = atsHomeInstall + atsCacheInstall;
        AtsLauncher.printLog("Operating system detected -> " + operatingSystem);
        Integer javaVersion = Runtime.version().version().get(0);
        if (javaVersion < 14) {
            AtsLauncher.printLog("Java version " + javaVersion + " found, minimum version 14 is needed to execute this script !");
            System.exit(0);
        }
        AtsLauncher.printLog("AtsLauncher execution using Java version -> " + javaVersion);
        File script = new File(AtsLauncher.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        projectFolderPath = Paths.get(script.getParent().replace("%20", " "), new String[0]);
        Path propFilePath = projectFolderPath.resolve(ATS_PROJECT_PROPERTIES).toAbsolutePath();
        if (!Files.exists(propFilePath, new LinkOption[0]) && !Files.exists(propFilePath = (projectFolderPath = Path.of("", new String[0]).toAbsolutePath()).resolve(ATS_PROJECT_PROPERTIES).toAbsolutePath(), new LinkOption[0])) {
            AtsLauncher.printLog("Unable to find ATS project properties file, this script will stop now");
            System.exit(0);
        }
        AtsLauncher.printLog("ATS project folder -> " + projectFolderPath.toString());
        Path targetFolderPath = projectFolderPath.resolve(TARGET);
        boolean buildEnvironment = false;
        boolean outboundTraffic = true;
        boolean disableSSLTrust = false;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try (FileInputStream is = new FileInputStream(propFilePath.toString());){
            Node root;
            Document doc = dbf.newDocumentBuilder().parse(is);
            if (doc.hasChildNodes() && (root = doc.getChildNodes().item(0)).hasChildNodes()) {
                NodeList childs = root.getChildNodes();
                for (int i2 = 0; i2 < childs.getLength(); ++i2) {
                    String nodeName = childs.item(i2).getNodeName();
                    String textContent = childs.item(i2).getTextContent().trim();
                    if (atsToolsFolderProperty.equalsIgnoreCase(nodeName)) {
                        atsToolsFolder = textContent;
                        continue;
                    }
                    if (atsToolsUrlProperty.equalsIgnoreCase(nodeName)) {
                        atsToolsUrl = textContent;
                        continue;
                    }
                    if (outboundProperty.equalsIgnoreCase(nodeName)) {
                        outboundTraffic = FALSE_LIST.indexOf(textContent.toLowerCase()) == -1;
                        continue;
                    }
                    if (!disableSSLParam.equalsIgnoreCase(nodeName)) continue;
                    disableSSLTrust = TRUE_LIST.indexOf(textContent.toLowerCase()) > -1;
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        ArrayList<CallSite> definitions = new ArrayList<CallSite>();
        boolean installOnly = false;
        block91: for (int i3 = 0; i3 < args.length; ++i3) {
            String allArgs = args[i3].trim();
            if ("-A:".equals(allArgs.substring(0, 3))) {
                definitions.add((CallSite)((Object)("-D" + allArgs.substring(3))));
                continue;
            }
            String firstArg = allArgs.toLowerCase();
            int equalPos = firstArg.indexOf("=");
            if ("clean".equals(firstArg)) {
                AtsLauncher.deleteDirectory(Paths.get(atsCacheInstall, new String[0]));
                AtsLauncher.deleteDirectory(Paths.get(atsToolsInstall, new String[0]));
            }
            if (equalPos == -1) {
                String string = firstArg = allArgs.toLowerCase().startsWith("-") ? allArgs.substring(1).toLowerCase() : allArgs.toLowerCase();
                if ("buildenvironment".equals(firstArg) || "preparemaven".equals(firstArg)) {
                    buildEnvironment = true;
                    asSuiteExecution = false;
                    continue;
                }
                if ("disablessl".equals(firstArg)) {
                    disableSSLTrust = true;
                    continue;
                }
                if (!"install".equals(firstArg) && !"installtools".equals(firstArg)) continue;
                installOnly = true;
                asSuiteExecution = false;
                continue;
            }
            String argName = firstArg.substring(0, equalPos).replaceAll("\\-", "");
            String argValue = allArgs.substring(equalPos + 1).trim();
            switch (argName) {
                case "atsagenturl": 
                case "ats.agent.url": 
                case "ats-agent-url": 
                case "systemdriverurl": 
                case "system.driver.url": 
                case "system-driver-url": {
                    if (AtsLauncher.checkSystemDriverUrl(argValue)) {
                        systemDriverUrl = AtsLauncher.addDefaultSystemeDriverPort(argValue);
                        continue block91;
                    }
                    AtsLauncher.printLog("Invalid value for systemDriverUrl -> " + argValue);
                    continue block91;
                }
                case "suite": 
                case "suites": 
                case "suitefile": 
                case "suitefiles": 
                case "suitesfiles": 
                case "suitexmlfiles": 
                case "suite-xml-files": 
                case "suite.xml.files": {
                    suiteFiles = argValue;
                    if (!suiteFiles.startsWith("=")) continue block91;
                    suiteFiles = suiteFiles.substring(1);
                    continue block91;
                }
                case "atslistscripts": {
                    atsScripts = argValue;
                    continue block91;
                }
                case "tempsuitename": {
                    if (argValue.length() <= 0) continue block91;
                    tempSuiteName = argValue;
                    continue block91;
                }
                case "preparemaven": {
                    buildEnvironment = TRUE_LIST.indexOf(argValue.toLowerCase()) != -1;
                    asSuiteExecution = false;
                    continue block91;
                }
                case "atsreport": 
                case "reportlevel": 
                case "report.level": 
                case "ats.report": 
                case "ats-report": 
                case "atsreportlevel": 
                case "ats-report-level": 
                case "ats.report.level": {
                    reportLevel = argValue.startsWith("=") ? argValue.substring(1) : argValue;
                    if (REPORT_LEVEL_LIST.contains(reportLevel)) continue block91;
                    reportLevel = "";
                    AtsLauncher.printLog("Invalid value for " + argName + " -> " + argValue + " use default value");
                    continue block91;
                }
                case "validationreport": 
                case "validation-report": 
                case "validation.report": {
                    if (AtsLauncher.isValidBooleanString(argValue)) {
                        validationReport = AtsLauncher.isFalseOrTrue(argValue) ? "1" : "0";
                        continue block91;
                    }
                    AtsLauncher.printLog("Invalid value for validationReport -> " + argValue + " use default value");
                    continue block91;
                }
                case "htmlplayer": 
                case "html-player": 
                case "html.player": {
                    if (AtsLauncher.isValidBooleanString(argValue)) {
                        htmlReportParam = AtsLauncher.isFalseOrTrue(argValue) ? "1" : "0";
                        continue block91;
                    }
                    AtsLauncher.printLog("Invalid value for htmlplayer -> " + argValue);
                    continue block91;
                }
                case "reportsdirectory": 
                case "reports-directory": 
                case "reports.directory": 
                case "reports-output": 
                case "reports.output": 
                case "output": {
                    output = argValue;
                    if (output.endsWith("/")) {
                        output = output.substring(0, output.length() - 1);
                    }
                    AtsLauncher.isValidOutputDirectory(output, argName);
                    continue block91;
                }
                case "atsurl": {
                    atsUrl = argValue;
                    if (AtsLauncher.isValidCharactersUrl(atsUrl)) continue block91;
                    AtsLauncher.printLog("Invalid characters in atsUrl -> " + atsUrl);
                    System.exit(0);
                    continue block91;
                }
                case "atstoolsurl": 
                case "ats-tools-url": 
                case "ats.tools.url": {
                    atsToolsUrl = argValue;
                    if (AtsLauncher.isValidCharactersUrl(atsToolsUrl)) continue block91;
                    AtsLauncher.printLog("Invalid characters in atsToolsUrl -> " + atsToolsUrl);
                    System.exit(0);
                    continue block91;
                }
                case "atstoolsfolder": 
                case "ats-tools-folder": 
                case "ats.tools.folder": {
                    if (argValue == null || argValue.length() <= 0) continue block91;
                    atsToolsFolder = argValue;
                    atsToolsFolderIsDefine = true;
                    continue block91;
                }
                case "atsfolder": 
                case "ats-folder": 
                case "ats.folder": {
                    if (argValue == null || argValue.length() <= 0) continue block91;
                    atsFolder = argValue;
                    continue block91;
                }
                case "outbound": {
                    outboundTraffic = FALSE_LIST.indexOf(argValue.toLowerCase()) == -1;
                    continue block91;
                }
                case "disablessl": 
                case "disable-ssl": 
                case "disable.ssl": {
                    disableSSLTrust = TRUE_LIST.indexOf(argValue.toLowerCase()) > -1;
                    continue block91;
                }
                case "enablessl": 
                case "enable-ssl": 
                case "enable.ssl": {
                    toolsServerUrl = toolsServerUrl.replace("http:", "https:");
                    atsServerReleasesUrl = atsServerReleasesUrl.replace("http:", "https:");
                    continue block91;
                }
                case "jenkinsurl": 
                case "jenkins-url": 
                case "jenkins.url": {
                    jenkinsToolsUrl = argValue;
                    if (!jenkinsToolsUrl.endsWith("/")) {
                        jenkinsToolsUrl = jenkinsToolsUrl + "/";
                    }
                    jenkinsToolsUrl = jenkinsToolsUrl + ATS_JENKINS_TOOLS;
                }
            }
        }
        String atsLibsRemoteUrl = atsServerReleasesUrl + "/ats-libs/";
        if (jenkinsToolsUrl != null && !AtsLauncher.checkIsJenkinsOk(atsLibsRemoteUrl, jenkinsToolsUrl)) {
            jenkinsToolsUrl = null;
        }
        if (atsUrl != null) {
            if (!atsUrl.startsWith("http://") && !atsUrl.startsWith("https://")) {
                atsUrl = "http://" + atsUrl;
            }
            atsServerReleasesUrl = atsUrl + ATS_RELEASES_DIRECTORY_SERVER;
            if (atsToolsUrl == null) {
                atsToolsUrl = atsUrl + ATS_TOOLS_DIRECTORY_SERVER;
            }
        }
        if (ATS_VERSION == null || ATS_VERSION.isEmpty() || ATS_VERSION.trim().isEmpty()) {
            projectAtsVersion = AtsLauncher.getAtsVersion(atsLibsRemoteUrl, dbf.newDocumentBuilder(), projectFolderPath.resolve("pom.xml").toAbsolutePath().toString());
            if (projectAtsVersion != null) {
                AtsLauncher.printLog("ATS library version -> " + projectAtsVersion);
                if (atsFolder != null) {
                    AtsLauncher.executeAtsFolder();
                } else {
                    int install = 0;
                    Path currentAtsFolder = Paths.get(atsCacheInstall, new String[0]).resolve(projectAtsVersion);
                    Path currentLibsFolder = currentAtsFolder.resolve("libs");
                    Path currentDriversFolder = currentAtsFolder.resolve("drivers");
                    if (atsEnvHome != null) {
                        currentLibsFolder = Paths.get(atsEnvHome, new String[0]).resolve("libs");
                        currentDriversFolder = Paths.get(atsEnvHome, new String[0]).resolve("drivers");
                    }
                    if (jenkinsToolsUrl != null || AtsLauncher.isDirectoryExistAndNoEmpty(currentLibsFolder)) {
                        install = 1;
                    } else {
                        AtsLauncher.printLog("ATS releases server -> " + atsServerReleasesUrl);
                        if (!Files.exists(currentLibsFolder, new LinkOption[0])) {
                            Files.createDirectories(currentLibsFolder, new FileAttribute[0]);
                        }
                        String url = atsLibsRemoteUrl + projectAtsVersion + ".zip";
                        AtsLauncher.downloadAndExtract(url, currentLibsFolder, "Ats libs", projectAtsVersion, true);
                        install = 1;
                    }
                    if (install > 0) {
                        if (jenkinsToolsUrl != null || AtsLauncher.isDirectoryExistAndNoEmpty(currentDriversFolder)) {
                            ++install;
                        } else {
                            String versionUrl;
                            if (!Files.exists(currentDriversFolder, new LinkOption[0])) {
                                Files.createDirectories(currentDriversFolder, new FileAttribute[0]);
                            }
                            if ((versionUrl = AtsLauncher.getLastVersionUrl(atsServerReleasesUrl + "/ats-drivers/" + operatingSystem + "/system")) != null) {
                                AtsLauncher.downloadAndExtract(versionUrl, currentDriversFolder, "Ats system driver", systemDriverVersion, true);
                            }
                            ++install;
                        }
                    }
                    AtsToolEnvironment atsTool = new AtsToolEnvironment(ATS);
                    if (install > 1) {
                        if (atsEnvHome != null) {
                            atsTool.update(Paths.get(atsEnvHome, new String[0]));
                        } else {
                            atsTool.update(currentAtsFolder);
                        }
                    }
                    atsToolsEnv.add(atsTool);
                    atsToolsEnv.add(new AtsToolEnvironment(JASPER));
                    atsToolsEnv.add(new AtsToolEnvironment(JDK));
                }
            } else {
                AtsLauncher.printLog("Unable to fin ATS library version defined in pom.xml !!");
            }
        } else {
            projectAtsVersion = ATS_VERSION;
            AtsLauncher.printLog("ATS library version defined by environement variable -> " + projectAtsVersion);
            AtsToolEnvironment atsTool = new AtsToolEnvironment(ATS);
            atsTool.update(Paths.get(atsCacheInstall, new String[0]).resolve(projectAtsVersion));
            atsToolsEnv.add(atsTool);
            atsToolsEnv.add(new AtsToolEnvironment(JASPER));
            atsToolsEnv.add(new AtsToolEnvironment(JDK));
        }
        if (disableSSLTrust) {
            AtsLauncher.disableSSL();
        }
        boolean isOutputBase = true;
        if (output == null) {
            output = outputBase;
            isOutputBase = false;
        }
        if (!(atsOutput = Paths.get(output, new String[0])).isAbsolute()) {
            atsOutput = projectFolderPath.resolve(output);
        } else if (!AtsLauncher.isDirectoryWritableOrCreatable(output)) {
            AtsLauncher.printLog("Output directory is not writable or creatable -> " + atsOutput.toString());
            atsOutput = projectFolderPath.resolve(Paths.get(outputBase, new String[0]));
        }
        if (isOutputBase) {
            AtsLauncher.printLog("Output directory -> " + atsOutput.toString());
        }
        AtsLauncher.deleteDirectory(targetFolderPath);
        AtsLauncher.deleteDirectory(atsOutput);
        AtsLauncher.deleteDirectory(projectFolderPath.resolve("test-output"));
        String[] suiteFilesList = new String[]{};
        if (atsScripts != null && atsScripts.trim().length() > 0) {
            Files.createDirectories(Paths.get(TARGET, new String[0]), new FileAttribute[0]);
            suiteFiles = "target/" + tempSuiteName + ".xml";
            StringBuilder builder = new StringBuilder("<!DOCTYPE suite SYSTEM \"https://testng.org/testng-1.0.dtd\">\n");
            builder.append("<suite name=\"").append(tempSuiteName).append("\" verbose=\"0\">\n<test name=\"testMain\" preserve-order=\"true\">\n<classes>\n");
            Stream<String> atsScriptsList = Arrays.stream(atsScripts.split(","));
            atsScriptsList.forEach(a -> AtsLauncher.addScriptToSuiteFile(builder, a));
            builder.append("</classes>\n</test></suite>");
            try (PrintWriter out = new PrintWriter(suiteFiles);){
                out.println(builder.toString());
                out.close();
            }
            suiteFilesList = new String[]{suiteFiles};
        } else if (suiteFiles != null && suiteFiles.trim().length() > 0) {
            String[] arr = suiteFiles.split(",");
            IntStream.range(0, arr.length).forEach(i -> {
                arr[i] = AtsLauncher.getSuitePath(arr[i]);
            });
            suiteFilesList = arr;
        } else if (asSuiteExecution) {
            List<String> defaultAtsSuite = AtsLauncher.getAtsDefaultSuite(dbf.newDocumentBuilder(), projectFolderPath.resolve("pom.xml").toAbsolutePath().toString());
            if (defaultAtsSuite != null && !defaultAtsSuite.isEmpty()) {
                suiteFilesList = defaultAtsSuite.toArray(new String[0]);
            } else {
                AtsLauncher.printLog("No suite file defined, this script will stop now");
                System.exit(0);
            }
        }
        AtsLauncher.checkSuiteFileExists(suiteFilesList);
        if (atsToolsUrl == null) {
            atsToolsUrl = toolsServerUrl;
        }
        if (atsToolsFolder == null && (atsToolsFolder = System.getenv("ATS_TOOLS")) != null) {
            atsToolsFolderIsDefine = true;
        }
        if (reportLevel.isEmpty() && (reportParam = System.getenv("ATS_REPORT")) != null && REPORT_LEVEL_LIST.contains(reportParam)) {
            reportLevel = reportParam;
            AtsLauncher.printLog("ATS_REPORT environment variable found -> " + reportParam);
        }
        if (atsToolsFolder == null) {
            atsToolsFolder = atsToolsInstall;
        }
        ArrayList envList = new ArrayList();
        boolean serverFound = false;
        Object serverNotReachable = "ATS tools server is not reachable";
        if (outboundTraffic) {
            if (jenkinsToolsUrl != null) {
                serverFound = AtsLauncher.checkAtsToolsVersions(true, jenkinsToolsUrl);
            } else {
                serverFound = false;
                if (atsFolder == null && !atsToolsFolderIsDefine.booleanValue()) {
                    serverFound = AtsLauncher.checkAtsToolsVersions(false, atsToolsUrl);
                }
            }
        } else {
            serverNotReachable = (String)serverNotReachable + " (outbound traffic has been turned off by user)";
        }
        if (!serverFound) {
            if (!outboundTraffic) {
                AtsLauncher.printLog((String)serverNotReachable);
            }
            if (atsToolsEnvLocal != null) {
                atsToolsEnv = atsToolsEnvLocal;
            }
            atsToolsEnv.stream().forEach(e -> AtsLauncher.installAtsTool(e, envList, Paths.get(atsToolsFolder, new String[0])));
            if (atsToolsFolderIsDefine.booleanValue()) {
                boolean[] errorFolderTools = new boolean[]{false};
                atsToolsEnv.stream().forEach(e -> {
                    if (e.folder == null) {
                        AtsLauncher.printLog("ATS tools " + e.name + " not found in folder -> " + atsToolsFolder);
                        errorFolderTools[0] = true;
                    } else if (e.name.equals(JDK)) {
                        String commandPath = Paths.get(e.folder.toString(), "bin", "java").toString();
                        ProcessBuilder processBuilder = new ProcessBuilder(commandPath, "--version");
                        try {
                            int majorVersion;
                            String line;
                            Process process = processBuilder.start();
                            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                            Pattern regex = Pattern.compile("\\b(\\d+)\\.?");
                            String majorVersionStr = null;
                            while ((line = reader.readLine()) != null) {
                                Matcher matcher = regex.matcher(line);
                                if (!matcher.find()) continue;
                                majorVersionStr = matcher.group(1);
                                break;
                            }
                            if (majorVersionStr != null && (majorVersion = Integer.parseInt(majorVersionStr)) < 17) {
                                AtsLauncher.printLog("ATS tools " + e.name + " version " + majorVersion + " not compatible with ATS version " + projectAtsVersion);
                                errorFolderTools[0] = true;
                            }
                        }
                        catch (IOException exc) {
                            exc.printStackTrace();
                        }
                    }
                });
                if (errorFolderTools[0]) {
                    System.exit(0);
                }
            }
            if (atsToolsEnv.size() != envList.size()) {
                AtsLauncher.printLog("ATS tools not found in folder -> " + atsToolsFolder);
                System.exit(0);
            }
        } else {
            atsToolsEnv.stream().forEach(e -> AtsLauncher.installAtsTool(e, envList));
        }
        if (installOnly) {
            System.out.println("====================================================");
            AtsLauncher.printLog("ATS tools and components installed !");
            System.out.println("====================================================");
            System.exit(0);
        }
        if (buildEnvironment) {
            Path p = projectFolderPath.resolve(BUILD_PROPERTIES);
            Files.deleteIfExists(p);
            Files.write(p, String.join((CharSequence)"\n", envList).getBytes(), StandardOpenOption.CREATE);
            AtsLauncher.printLog("Build properties file created : " + p.toFile().getAbsolutePath());
        } else {
            File projectDirectoryFile = projectFolderPath.toFile();
            Path generatedPath = targetFolderPath.resolve("generated");
            File generatedSourceDir = generatedPath.toFile();
            String generatedSourceDirPath = generatedSourceDir.getAbsolutePath();
            generatedSourceDir.mkdirs();
            AtsLauncher.printLog("Project directory -> " + projectDirectoryFile.getAbsolutePath());
            AtsLauncher.printLog("Generate java files -> " + generatedSourceDirPath);
            FullLogConsumer logConsumer = new FullLogConsumer();
            String javaRunCommand = Paths.get(jdkHomePath, new String[0]).toAbsolutePath().toString() + "/bin/java";
            String[] command = new String[]{javaRunCommand, "-cp", atsHomePath + "/libs/*", "com.ats.generator.Generator", "-prj", projectFolderPath.toString(), "-dest", targetFolderPath.toString() + "/generated", "-force"};
            AtsLauncher.execute(command, null, projectDirectoryFile, logConsumer, logConsumer);
            ArrayList<String> files = AtsLauncher.listJavaClasses(generatedSourceDirPath.length() + 1, generatedSourceDir);
            if (definitions.size() > 0) {
                List newDefinitions = definitions.stream().map(str -> str.replaceAll("^-D", "")).collect(Collectors.toList());
                AtsLauncher.printLog("Environment variables passed : " + String.join((CharSequence)" ; ", newDefinitions));
            }
            Path classFolder = targetFolderPath.resolve("classes").toAbsolutePath();
            Path classFolderAssets = classFolder.resolve("assets");
            classFolderAssets.toFile().mkdirs();
            AtsLauncher.copyFolder(projectFolderPath.resolve("src").resolve("assets"), classFolderAssets);
            AtsLauncher.printLog("Compile classes to folder -> " + classFolder.toString());
            Files.write(generatedPath.resolve("JavaClasses.list"), String.join((CharSequence)"\n", files).getBytes(), StandardOpenOption.CREATE);
            command = new String[]{javaRunCommand + "c", "-cp", "../../libs/*" + File.pathSeparator + atsHomePath + "/libs/*", "-d", classFolder.toString(), "@JavaClasses.list"};
            AtsLauncher.execute(command, null, generatedPath.toAbsolutePath().toFile(), logConsumer, logConsumer);
            AtsLauncher.printLog("Launch suite(s) execution -> " + suiteFiles);
            command = new String[]{javaRunCommand, "-Dats-report=" + reportLevel, "-Dvalidation-report=" + validationReport, "-Dhtmlplayer=" + htmlReportParam, "-Doutbound-traffic=" + outboundTraffic, "-Dats.home=" + atsHomePath, "-Dsystem-driver-url=" + systemDriverUrl};
            command = AtsLauncher.concatWithArrayCopy(command, (String[])definitions.toArray(String[]::new));
            String[] atsCommand = new String[]{"-cp", atsHomePath + "/libs/*" + File.pathSeparator + targetFolderPath.toString() + "/classes" + File.pathSeparator + "libs/*", "org.testng.TestNG", "-d", atsOutput.toString()};
            command = AtsLauncher.concatWithArrayCopy(command, atsCommand);
            command = AtsLauncher.concatWithArrayCopy(command, suiteFilesList);
            AtsLauncher.execute(command, atsExecEnv, projectDirectoryFile, logConsumer, new TestNGLogConsumer());
        }
    }

    private static String addDefaultSystemeDriverPort(String value) {
        if (!value.matches(".*:\\d+$")) {
            return value + ":9700";
        }
        return value;
    }

    private static boolean checkSystemDriverUrl(String value) {
        String regex = "^(http[s]?://)?(\\d{1,3}\\.){3}\\d{1,3}(:\\d{1,5})?(/)?$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            int lastIndex = value.lastIndexOf(":");
            if (lastIndex != -1 && value.matches(".*:\\d+$")) {
                String strPort = value.substring(lastIndex + 1);
                int port = 0;
                if (strPort.length() > 0 && strPort.length() < 6) {
                    try {
                        port = Integer.parseInt(strPort);
                        return port > 1023 && port < 65536;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isFalseOrTrue(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        return TRUE_LIST.contains(value.toLowerCase());
    }

    private static boolean isValidBooleanString(String value) {
        if (value != null && value.length() > 0) {
            return TRUE_LIST.indexOf(value.toLowerCase()) != -1 || FALSE_LIST.indexOf(value.toLowerCase()) != -1;
        }
        return false;
    }

    private static boolean isValidCharactersUrl(String url) {
        String illegalCharacters = "<>\"%{}|\\^~[]` ";
        for (char c : url.toCharArray()) {
            if (illegalCharacters.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    private static String cleanArgument(String arg) {
        String[] prefixes;
        for (String prefix : prefixes = new String[]{"--", "-", "/"}) {
            if (!arg.startsWith(prefix)) continue;
            return arg.substring(prefix.length()).toLowerCase();
        }
        return arg.toLowerCase();
    }

    private static void checkHelp(String[] args, HashMap<String, String> helpMap) {
        String currentArg = null;
        String previousArg = null;
        if (args.length < 2 && args.length > 0) {
            currentArg = AtsLauncher.cleanArgument(args[0]);
            if (currentArg.equals("help") || currentArg.equals("?")) {
                AtsLauncher.printHelp("general");
                System.exit(0);
            }
        } else if (args.length > 1 && ((currentArg = AtsLauncher.cleanArgument(args[args.length - 1])).equals("help") || currentArg.equals("?"))) {
            previousArg = AtsLauncher.cleanArgument(args[args.length - 2]);
            int indexOf = previousArg.indexOf(61);
            if (indexOf != -1) {
                previousArg = previousArg.substring(0, indexOf);
            }
            AtsLauncher.printHelp(previousArg);
            System.exit(0);
        }
    }

    private static void printHelp(String key) {
        switch (key) {
            case "general": {
                System.out.println(helpMap.get("general"));
                break;
            }
            case "clean": 
            case "preparemaven": 
            case "buildenvironment": 
            case "suitexmlfiles": 
            case "atsreport": 
            case "validationreport": 
            case "atslistscripts": 
            case "tempsuitename": 
            case "disablessl": 
            case "atsurl": 
            case "atstoolsurl": 
            case "jenkinsurl": 
            case "reportsdirectory": 
            case "outbound": 
            case "atstoolsfolder": 
            case "ats_tools": 
            case "atsfolder": 
            case "xml_atsprojectproperties": {
                System.out.println(helpMap.get(key));
                break;
            }
            default: {
                System.out.println("No help found for key : " + key);
                System.out.println(helpMap.get("general"));
            }
        }
    }

    private static void executeAtsFolder() {
        Path atsPath = Paths.get(atsFolder, new String[0]);
        Path driversPath = atsPath.resolve("drivers");
        Path libsPath = atsPath.resolve("libs");
        Path toolsPath = atsToolsFolder == null ? atsPath.resolve("tools") : Paths.get(atsToolsFolder, new String[0]);
        Path jdkPath = toolsPath.resolve(JDK);
        Path jasperPath = toolsPath.resolve(JASPER);
        if (Files.exists(driversPath, new LinkOption[0]) && Files.exists(libsPath, new LinkOption[0]) && Files.exists(jdkPath, new LinkOption[0]) && Files.exists(jasperPath, new LinkOption[0])) {
            atsToolsEnvLocal = new ArrayList<AtsToolEnvironment>(Arrays.asList(new AtsToolEnvironment(ATS, atsPath), new AtsToolEnvironment(JDK, jdkPath), new AtsToolEnvironment(JASPER, jasperPath)));
        } else {
            AtsLauncher.printLog("ATS folder is not valid structure");
            AtsLauncher.printHelp("atsfolder");
            System.exit(0);
        }
    }

    private static <T> String[] concatWithArrayCopy(String[] array1, String[] array2) {
        String[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return (String[])Arrays.stream(result).filter(x -> !AtsLauncher.isStringBlank(x)).toArray(String[]::new);
    }

    private static boolean isStringBlank(String value) {
        return value == null || "".equals(value);
    }

    private static String getSuitePath(String name) {
        if (!((String)(name = ((String)name).replaceAll("\"", ""))).startsWith(SRC_EXEC) && !((String)name).endsWith("ats__temp__suite__.xml")) {
            name = "src/exec/" + (String)name;
        }
        if (!((String)name).endsWith(".xml")) {
            name = (String)name + ".xml";
        }
        return name;
    }

    private static String getLastVersionUrl(String folderUrl) throws MalformedURLException, IOException, URISyntaxException {
        HttpURLConnection con = AtsLauncher.createHttpConnection(folderUrl, true);
        if (con != null && con.getResponseCode() == 200) {
            ModuleDescriptor.Version version;
            InputStream inputStream = con.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
            }
            inputStream.close();
            ArrayList<String> versions = new ArrayList<String>();
            Matcher matcher = SYS_VERSION_PATTERN.matcher(builder.toString());
            int index = 0;
            while (matcher.find(index)) {
                versions.add(matcher.group(1));
                index = matcher.end();
            }
            if (versions.size() > 0 && (version = versions.stream().map(ModuleDescriptor.Version::parse).sorted(Collections.reverseOrder()).findFirst().get()) != null) {
                systemDriverVersion = version.toString();
                return folderUrl + "/" + systemDriverVersion;
            }
        }
        return null;
    }

    private static void addScriptToSuiteFile(StringBuilder builder, String scriptName) {
        if ((scriptName = scriptName.replaceAll("\\/", ".")).endsWith(".ats")) {
            scriptName = scriptName.substring(0, scriptName.length() - 4);
        }
        if (scriptName.startsWith(".")) {
            scriptName = scriptName.substring(1);
        }
        builder.append("<class name=\"").append(scriptName).append("\"/>\n");
    }

    private static Map<String, String[]> getServerToolsVersion(String serverUrl) {
        HashMap<String, String[]> versions = new HashMap<String, String[]>();
        try {
            String inputLine;
            URL url = new URI(serverUrl).toURL();
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection yc = (HttpURLConnection)url.openConnection();
            yc.setRequestMethod("GET");
            yc.setRequestProperty("Connection", "Keep-Alive");
            yc.setRequestProperty("Cache-Control", "no-cache");
            yc.setRequestProperty("User-Agent", "AtsLauncher-" + operatingSystem);
            yc.setUseCaches(false);
            yc.setDoOutput(true);
            BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                String[] lineData = inputLine.split(",");
                versions.put(lineData[0], lineData);
            }
            in.close();
        }
        catch (IOException | URISyntaxException e) {
            AtsLauncher.printLog("AtsLauncher error -> " + e.getMessage());
        }
        return versions;
    }

    private static String removeExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int lastIndex = filename.lastIndexOf(46);
        if (lastIndex > 0) {
            return filename.substring(0, lastIndex);
        }
        return filename;
    }

    private static String getFilename(String urlFileName) {
        if (urlFileName == null) {
            return null;
        }
        int lastIndex = urlFileName.lastIndexOf(47);
        if (lastIndex > 0) {
            return urlFileName.substring(lastIndex + 1);
        }
        return urlFileName;
    }

    private static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int lastIndex = filename.lastIndexOf(46);
        if (lastIndex > 0) {
            return filename.substring(lastIndex + 1);
        }
        return filename;
    }

    private static Boolean checkAtsToolsVersions(boolean localServer, String server) {
        Map<Object, Object> versions = new HashMap();
        if (!AtsLauncher.getFilename((String)server).equals("versions.csv")) {
            Object url = "";
            for (Map.Entry<String, String> atsTool : atsToolsList.entrySet()) {
                server = ((String)server).endsWith("/") ? server : (String)server + "/";
                server = ((String)server).startsWith("http") ? server : "http://" + (String)server;
                url = (String)server + atsTool.getValue();
                try {
                    String fileLastVersion = AtsLauncher.getFilename(AtsLauncher.getLastVersionUrl((String)url));
                    if (fileLastVersion == null) {
                        AtsLauncher.printLog("Unable to get last version of " + atsTool.getKey() + " on this server -> " + (String)url);
                        System.exit(0);
                    }
                    String lastVersion = AtsLauncher.removeExtension(fileLastVersion);
                    String folderLastVersion = atsTool.getKey() + "-" + lastVersion;
                    String urlLastVersion = (String)url + "/" + fileLastVersion;
                    versions.put(atsTool.getKey(), new String[]{atsTool.getKey(), lastVersion, folderLastVersion, urlLastVersion});
                }
                catch (IOException | URISyntaxException fileLastVersion) {}
            }
            if (versions.size() < atsToolsEnv.size() && localServer) {
                AtsLauncher.printLog("Unable to get all ATS tools on this server -> " + (String)server);
                versions.putAll(AtsLauncher.getServerToolsVersion(atsToolsUrl));
                if (versions.size() < atsToolsEnv.size()) {
                    return false;
                }
            }
        } else {
            versions = AtsLauncher.getServerToolsVersion((String)server);
            atsToolsEnv.forEach(t -> {
                if (ATS.equals(t.name)) {
                    t.check = true;
                }
            });
        }
        for (AtsToolEnvironment t2 : atsToolsEnv) {
            File toolFolder;
            String folderName;
            String[] toolData;
            if (!t2.check || (toolData = (String[])versions.get(t2.name)) == null) continue;
            t2.folderName = folderName = toolData[2];
            File file = toolFolder = t2.name.equals(ATS) ? Paths.get(atsCacheInstall, new String[0]).resolve(folderName).toFile() : Paths.get(atsToolsFolder, new String[0]).resolve(folderName).toFile();
            if (toolFolder.exists()) {
                t2.folder = toolFolder.getAbsolutePath();
                continue;
            }
            t2.url = toolData[3];
        }
        return true;
    }

    private static void toolInstalled(AtsToolEnvironment tool, List<String> envList) {
        if (ATS.equals(tool.name)) {
            Path atsPath;
            if (atsFolder == null && atsEnvHome != null && Files.exists(atsPath = Paths.get(atsEnvHome, new String[0]), new LinkOption[0]) && Files.exists(atsPath.resolve("drivers"), new LinkOption[0]) && Files.exists(atsPath.resolve("libs"), new LinkOption[0])) {
                tool.update(atsPath);
            }
            atsHomePath = tool.folder;
        } else if (JDK.equals(tool.name)) {
            jdkHomePath = tool.folder;
        }
        envList.add(tool.envName + "=" + tool.folder);
        AtsLauncher.printLog("Set environment variable [" + tool.envName + "] -> " + tool.folder);
        atsExecEnv.put(tool.envName, tool.folder);
    }

    private static void installAtsTool(AtsToolEnvironment tool, List<String> envList, Path toolsPath) {
        if (!tool.check) {
            AtsLauncher.toolInstalled(tool, envList);
        } else {
            try (Stream<Path> stream = Files.walk(toolsPath, 1, new FileVisitOption[0]);){
                List folders = stream.filter(file -> file != toolsPath && Files.isDirectory(file, new LinkOption[0]) && file.getFileName().toString().startsWith(tool.name)).map(Path::getFileName).map(Path::toString).collect(Collectors.toList());
                if (folders.size() > 0) {
                    folders.sort(Collections.reverseOrder());
                    tool.folder = toolsPath.resolve((String)folders.get(0)).toAbsolutePath().toString();
                    AtsLauncher.toolInstalled(tool, envList);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void installAtsTool(AtsToolEnvironment tool, List<String> envList) {
        if (!tool.check) {
            AtsLauncher.toolInstalled(tool, envList);
        } else {
            File[] files;
            boolean downloadAts = false;
            if (tool.name.equals(ATS) && jenkinsToolsUrl != null) {
                files = Paths.get(atsCacheInstall, new String[0]).toFile().listFiles();
                File[] ats_version = tool.folderName.replaceFirst("^ats-", "");
                if (files != null) {
                    Arrays.sort(files, Comparator.comparingLong(File::lastModified));
                    File[] fileArray = files;
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File f = fileArray[i];
                        if (!f.getName().startsWith((String)ats_version)) continue;
                        tool.folderName = f.getName();
                        tool.folder = f.getAbsolutePath();
                        downloadAts = true;
                        break;
                    }
                }
            }
            if (tool.folderName == null && !tool.name.equals(ATS)) {
                files = Paths.get(atsToolsFolder, new String[0]).toFile().listFiles();
                if (files != null) {
                    Arrays.sort(files, Comparator.comparingLong(File::lastModified));
                    for (File f : files) {
                        if (!f.getName().startsWith(tool.name)) continue;
                        tool.folderName = f.getName();
                        tool.folder = f.getAbsolutePath();
                        break;
                    }
                }
            } else if (tool.url != null && !downloadAts) {
                AtsLauncher.printLog("Download ATS tool -> " + tool.url);
                String urlArchiveExtension = AtsLauncher.getExtension(AtsLauncher.getFilename(tool.url));
                HttpURLConnection connection = AtsLauncher.createHttpConnection(tool.url, true);
                if (connection != null) {
                    try {
                        File tmpZipFile = AtsLauncher.download(connection, tool.name);
                        if (urlArchiveExtension.equals(TGZ) && LINUX.equals(operatingSystem)) {
                            Path path = Paths.get(atsToolsFolder, new String[0]);
                            Files.createDirectories(path, new FileAttribute[0]);
                            try {
                                AtsLauncher.execute(new String[]{"tar", "-xzf", tmpZipFile.getAbsolutePath(), "-C", path.toFile().getAbsolutePath()});
                            }
                            catch (Exception f) {}
                        } else if (tool.name.equals(ATS)) {
                            AtsLauncher.unzipArchive(tmpZipFile, Paths.get(atsCacheInstall, new String[0]));
                            File oldFolderName = Paths.get(atsCacheInstall, new String[0]).resolve(tool.folderName).toFile();
                            tool.folderName = tool.folderName.replaceFirst("^ats-", "");
                            File newFolderName = Paths.get(atsCacheInstall, new String[0]).resolve(tool.folderName).toFile();
                            oldFolderName.renameTo(newFolderName);
                        } else {
                            AtsLauncher.unzipArchive(tmpZipFile, Paths.get(atsToolsFolder, new String[0]));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                tool.folder = tool.name.equals(ATS) ? Paths.get(atsCacheInstall, new String[0]).resolve(tool.folderName).toFile().getAbsolutePath() : Paths.get(atsToolsFolder, new String[0]).resolve(tool.folderName).toFile().getAbsolutePath();
            }
            if (tool.folder == null) {
                AtsLauncher.printLog("ATS tool is not installed on this system -> " + tool.name);
                System.exit(1);
            } else {
                AtsLauncher.toolInstalled(tool, envList);
            }
        }
    }

    private static String getAtsVersion(String atsLibsUrl, DocumentBuilder db, String pomFilePath) {
        String version = AtsLauncher.getAtsPomVersion(db, pomFilePath);
        if (version != null && version.length() > 0) {
            if ("LATEST".equals(version)) {
                version = AtsLauncher.getAtsLastVersion(atsLibsUrl);
                if (version != null) {
                    return version;
                }
            } else {
                return version;
            }
        }
        return DEFAULT_ATS_VERSION;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String getAtsPomVersion(DocumentBuilder db, String pomFilePath) {
        try (FileInputStream is = new FileInputStream(pomFilePath);){
            Document doc = db.parse(is);
            NodeList project = doc.getElementsByTagName("project");
            if (project.getLength() > 0) {
                int j;
                int i;
                NodeList projectItems = project.item(0).getChildNodes();
                for (i = 0; i < projectItems.getLength(); ++i) {
                    if (!"dependencies".equals(projectItems.item(i).getNodeName())) continue;
                    NodeList dependencies = projectItems.item(i).getChildNodes();
                    for (j = 0; j < dependencies.getLength(); ++j) {
                        String artifactId = null;
                        String groupId = null;
                        String version = null;
                        NodeList dependency = dependencies.item(j).getChildNodes();
                        for (int k = 0; k < dependency.getLength(); ++k) {
                            if ("artifactId".equals(dependency.item(k).getNodeName())) {
                                artifactId = dependency.item(k).getTextContent();
                                continue;
                            }
                            if ("groupId".equals(dependency.item(k).getNodeName())) {
                                groupId = dependency.item(k).getTextContent();
                                continue;
                            }
                            if (!"version".equals(dependency.item(k).getNodeName())) continue;
                            version = dependency.item(k).getTextContent();
                        }
                        if (!"com.actiontestscript".equals(groupId) || !"ats-automated-testing".equals(artifactId) || "${ats.lib.version}".equals(version)) continue;
                        String string = version;
                        return string;
                    }
                }
                for (i = 0; i < projectItems.getLength(); ++i) {
                    if (!"properties".equals(projectItems.item(i).getNodeName())) continue;
                    NodeList properties = projectItems.item(i).getChildNodes();
                    for (j = 0; j < properties.getLength(); ++j) {
                        Node property = properties.item(j);
                        if (!"ats.lib.version".equals(property.getNodeName())) continue;
                        String string = property.getTextContent();
                        return string;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void checkSuiteFileExists(String[] suites) {
        for (String suite : suites) {
            if (Files.exists(Paths.get(suite, new String[0]), new LinkOption[0])) continue;
            AtsLauncher.printLog("Suite file not found -> " + suite);
            System.exit(0);
        }
    }

    private static List<String> getAtsDefaultSuite(DocumentBuilder db, String pomFilePath) {
        List<String> list;
        FileInputStream is = new FileInputStream(pomFilePath);
        try {
            Document doc = db.parse(is);
            list = AtsLauncher.findSuiteXmlFiles(doc);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new ArrayList<String>();
            }
        }
        ((InputStream)is).close();
        return list;
    }

    private static List<String> findSuiteXmlFiles(Node node) {
        ArrayList<String> suiteFiles = new ArrayList<String>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("suiteXmlFile".equals(child.getNodeName())) {
                suiteFiles.add(child.getTextContent());
            }
            suiteFiles.addAll(AtsLauncher.findSuiteXmlFiles(child));
        }
        return suiteFiles;
    }

    private static File download(HttpURLConnection connection, String logString) throws Exception {
        double fileLength = connection.getContentLength();
        connection.disconnect();
        Progess display = fileLength == -1.0 ? new SizeProgress(logString, "Mo") : new PercentProgress(logString, "%");
        File tmpFile = Files.createTempFile("ats-download-", ".tmp", new FileAttribute[0]).toFile();
        int maxTry = 10;
        while (maxTry > 0 && !AtsLauncher.tryDownload(display, fileLength, connection.getURL(), tmpFile)) {
            AtsLauncher.printLog("Error downloading archive -> " + --maxTry + " tries left ...");
        }
        if (maxTry > 0) {
            return tmpFile;
        }
        throw new Exception("Unable to download archive -> " + connection.getURL().getFile());
    }

    private static boolean tryDownload(Progess display, double fileLength, URL url, File tmpFile) {
        try {
            FileOutputStream fos = new FileOutputStream(tmpFile);
            BufferedInputStream ins = new BufferedInputStream(url.openStream());
            byte[] dataBuffer = new byte[1024];
            int bytesRead = 0;
            double bytesLoaded = 0.0;
            while ((bytesRead = ins.read(dataBuffer, 0, 1024)) != -1) {
                fos.write(dataBuffer, 0, bytesRead);
                display.print(bytesLoaded += (double)bytesRead, fileLength);
            }
            fos.close();
            ins.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void printLog(String data) {
        System.out.println("[ATS-LAUNCHER] " + data);
    }

    private static void execute(String[] commands, Map<String, String> execEnv, File currentDir, Consumer<String> outputConsumer, Consumer<String> errorConsumer) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(commands).directory(currentDir);
        if (execEnv == null) {
            execEnv = System.getenv();
        } else {
            execEnv.putAll(System.getenv());
        }
        pb.inheritIO();
        pb.environment().putAll(execEnv);
        pb.environment().put("java.net.useSystemProxies", "true");
        Process p = pb.start();
        new StreamGobbler(p.getErrorStream(), errorConsumer).start();
        new StreamGobbler(p.getInputStream(), outputConsumer).start();
        p.waitFor();
    }

    private static void execute(String[] commands) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(commands);
        Process p = pb.start();
        p.waitFor();
    }

    private static void unzipArchive(File archive, Path destination) {
        try {
            AtsLauncher.unzipFolder(archive.toPath(), destination);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        archive.delete();
    }

    private static void unzipFolder(Path source, Path target) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(source.toFile()));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                boolean isDirectory = false;
                if (zipEntry.getName().endsWith(File.separator) || zipEntry.isDirectory()) {
                    isDirectory = true;
                }
                Path newPath = AtsLauncher.zipSlipProtect(zipEntry, target);
                if (isDirectory) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                } else {
                    if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    private static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    private static void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> AtsLauncher.copy(source, dest.resolve(src.relativize((Path)source))));
        }
    }

    private static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static ArrayList<String> listJavaClasses(int subLen, File directory) {
        ArrayList<String> list = new ArrayList<String>();
        File[] fList = directory.listFiles();
        if (fList == null) {
            throw new RuntimeException("Directory list files return null value ! (" + directory.getAbsolutePath() + ")");
        }
        for (File file : fList) {
            if (file.isFile()) {
                if (!file.getName().endsWith(".java")) continue;
                list.add(file.getAbsolutePath().substring(subLen).replaceAll("\\\\", "/"));
                continue;
            }
            if (!file.isDirectory()) continue;
            list.addAll(AtsLauncher.listJavaClasses(subLen, file));
        }
        return list;
    }

    private static void deleteDirectory(Path directory) throws IOException {
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path directory, IOException ioException) throws IOException {
                    Files.delete(directory);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void isValidOutputDirectory(String strPathDirectory, String argName) {
        String[] strError = new String[1];
        String strDirectory = strPathDirectory;
        boolean isValid = true;
        isValid = AtsLauncher.isValidDirectoryName(strDirectory, strError, false);
        if (strPathDirectory.contains("/")) {
            strDirectory = strDirectory.substring(strDirectory.indexOf("/") + 1);
        } else if (strPathDirectory.contains("\\")) {
            strDirectory = strDirectory.substring(strDirectory.indexOf("\\") + 1);
        }
        if (isValid) {
            if (Paths.get(strPathDirectory, new String[0]).isAbsolute()) {
                strDirectory = Paths.get(strPathDirectory, new String[0]).getFileName().toString();
            }
            isValid = AtsLauncher.isValidDirectoryName(strDirectory, strError, true);
        }
        if (!isValid) {
            AtsLauncher.printLog("Invalid input in " + argName + " -> " + strError[0] + "  path  : " + strPathDirectory);
            System.exit(0);
        }
    }

    private static boolean isDirectoryWritableOrCreatable(String path) {
        boolean canCreateDirectory = true;
        for (Path directoryPath = Paths.get(path, new String[0]); directoryPath != null; directoryPath = directoryPath.getParent()) {
            if (!Files.exists(directoryPath, new LinkOption[0])) continue;
            if (Files.isWritable(directoryPath)) break;
            canCreateDirectory = false;
            break;
        }
        return canCreateDirectory;
    }

    private static boolean isValidDirectoryName(String name, String[] strError, boolean fullChars) {
        strError[0] = null;
        if (name == null || name.trim().isEmpty()) {
            strError[0] = "Directory name is empty or content only spaces";
            return false;
        }
        String forbiddenChars = "";
        forbiddenChars = fullChars ? "\\/:*?\"<>|" : "*?\"<>|";
        for (char c : forbiddenChars.toCharArray()) {
            if (name.indexOf(c) == -1) continue;
            strError[0] = "Directory name contains forbidden character '" + c + "'";
            return false;
        }
        if (operatingSystem.equals(WINDOWS)) {
            String[] reservedNames;
            for (String reservedName : reservedNames = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"}) {
                if (!name.equalsIgnoreCase(reservedName)) continue;
                strError[0] = "Directory name is reserved by Windows";
                return false;
            }
        }
        return true;
    }

    private static String getAtsLastVersion(String url) {
        HttpURLConnection connection = AtsLauncher.createHttpConnection(url, true);
        if (connection != null) {
            try {
                String inputLine;
                Pattern pattern = Pattern.compile("<a href=[\"'](.*)\\.zip[\"']>.*\\.zip</a>", 2);
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String lastVersion = "0";
                while ((inputLine = in.readLine()) != null) {
                    String remoteVersion;
                    Matcher matcher = pattern.matcher(inputLine);
                    if (!matcher.find() || String.CASE_INSENSITIVE_ORDER.compare(lastVersion, remoteVersion = matcher.group(1)) >= 0) continue;
                    lastVersion = remoteVersion;
                }
                in.close();
                return lastVersion;
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isDirectoryExistAndNoEmpty(Path folderPath) {
        if (Files.exists(folderPath, new LinkOption[0])) {
            try {
                File currentFolderFile = new File(folderPath.toAbsolutePath().toString());
                return currentFolderFile.isDirectory() && currentFolderFile.list().length > 0;
            }
            catch (Exception exception) {}
        } else {
            return false;
        }
        return false;
    }

    private static boolean checkIsJenkinsOk(String atsLibsRemoteUrl, String jenkinsToolsUrl) {
        Map<String, String[]> versions = AtsLauncher.getServerToolsVersion(jenkinsToolsUrl);
        String[] atsVersions = versions.get(ATS);
        if (atsVersions != null && atsVersions.length > 1) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                String pomAtsVersion = AtsLauncher.getAtsVersion(atsLibsRemoteUrl, dbf.newDocumentBuilder(), projectFolderPath.resolve("pom.xml").toAbsolutePath().toString());
                String versionElement = atsVersions[1];
                if (versionElement != null && versionElement.equals(pomAtsVersion)) {
                    return true;
                }
                AtsLauncher.printLog("AtsLauncher error -> The version of ATS used in the project is not the same as the one used in Jenkins");
                AtsLauncher.printLog("AtsLauncher error -> Please update the version of ATS in the project or in Jenkins");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AtsLauncher.printLog("AtsLauncher error -> Jenkins Url is not available, try to connect to ActionTestScript server ...");
        return false;
    }

    public static void disableSSL() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    private static HttpURLConnection createHttpConnection(String url, boolean followRedirects) {
        try {
            HttpURLConnection.setFollowRedirects(followRedirects);
            HttpURLConnection connection = (HttpURLConnection)new URI(url).toURL().openConnection();
            connection.setUseCaches(false);
            if (connection.getResponseCode() == 200) {
                return connection;
            }
            AtsLauncher.printLog("Server response error -> " + connection.getResponseCode());
            return null;
        }
        catch (IOException | URISyntaxException e) {
            AtsLauncher.printLog("Unable to connect to server -> " + url);
            return null;
        }
    }

    private static void downloadAndExtract(String url, Path destFolder, String downloadText, String filenameVersion, boolean followRedirects) {
        HttpURLConnection connection = AtsLauncher.createHttpConnection(url, followRedirects);
        String archiveExtension = AtsLauncher.getExtension(AtsLauncher.getFilename(url));
        if (connection != null) {
            AtsLauncher.printLog("Download [" + downloadText + " (" + filenameVersion + ")] -> " + url);
            try {
                File downloaded = AtsLauncher.download(connection, downloadText);
                if (WINDOWS.equals(operatingSystem)) {
                    AtsLauncher.unzipArchive(downloaded, destFolder);
                } else if (LINUX.equals(operatingSystem)) {
                    if (archiveExtension.equals(TGZ)) {
                        AtsLauncher.execute(new String[]{"tar", "-xzf", downloaded.getAbsolutePath(), "-C", destFolder.toFile().getAbsolutePath()});
                        if (posixFilePermission != null) {
                            Path driverPath = destFolder.resolve(LINUX_DRIVER_NAME);
                            Files.setPosixFilePermissions(driverPath, posixFilePermission);
                        }
                        downloaded.delete();
                    } else if (archiveExtension.equals(ZIP)) {
                        AtsLauncher.unzipArchive(downloaded, destFolder);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class AtsToolEnvironment {
        public String name;
        public String envName;
        public String folder;
        public String folderName;
        public boolean check = true;
        public String url;

        public AtsToolEnvironment(String name) {
            this.name = name;
            this.envName = name.toUpperCase() + "_HOME";
        }

        public AtsToolEnvironment(String name, Path path) {
            this.name = name;
            this.envName = name.toUpperCase() + "_HOME";
            this.update(path);
        }

        public void update(Path folder) {
            this.folder = folder.toAbsolutePath().toString();
            this.folderName = folder.getFileName().toString();
            this.check = false;
        }
    }

    private static class FullLogConsumer
    implements Consumer<String> {
        private FullLogConsumer() {
        }

        @Override
        public void accept(String s) {
            System.out.println(s);
        }
    }

    private static class TestNGLogConsumer
    implements Consumer<String> {
        private TestNGLogConsumer() {
        }

        @Override
        public void accept(String s) {
            System.out.println(s.replace("[TestNG]", "").replace("[main] INFO org.testng.internal.Utils -", "[TestNG]").replace("Warning: [org.testng.ITest]", "[TestNG] Warning :").replace("[main] INFO org.testng.TestClass", "[TestNG]"));
        }
    }

    public static class SizeProgress
    extends Progess {
        public SizeProgress(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        protected int calculate(double i1, double i2) {
            return (int)Math.round(i1 / 1000000.0);
        }
    }

    public static class PercentProgress
    extends Progess {
        public PercentProgress(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        protected int calculate(double i1, double i2) {
            return (int)Math.round(i1 / i2 * 100.0);
        }
    }

    private static class Progess {
        private int current = 0;
        private String logPrefix;
        private String logSufix;

        public Progess(String prefix, String suffix) {
            this.logPrefix = "Download [" + prefix + "] -> ";
            this.logSufix = " " + suffix;
        }

        public void print(double v1, double v2) {
            int value = this.calculate(v1, v2);
            if (value % 5 == 0 && this.current != value) {
                System.out.println(this.logPrefix + value + this.logSufix);
                this.current = value;
            }
        }

        protected int calculate(double i1, double i2) {
            return 0;
        }
    }

    private static class StreamGobbler
    extends Thread {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

