/*
 * Decompiled with CFR 0.152.
 */
package com.ats;

import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsManager;
import com.ats.driver.AtsProxy;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.ChannelManager;
import com.ats.executor.drivers.DriverInfo;
import com.ats.executor.drivers.DriverInfoLocal;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.generator.variables.Variable;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.neoload.ActionNeoload;
import com.ats.tools.wait.IWaitGuiReady;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsSingleton {
    private static AtsSingleton instance;
    private IDriverInfo systemDriver;
    private ChannelManager channelManager = new ChannelManager();
    private List<ActionTestScript> scriptCallTree = new ArrayList<ActionTestScript>();
    private String jsonSuitesFile;
    private String atsOutputFolder;
    private String logLevel = "silent";
    private AtsManager ats = new AtsManager();
    private boolean init = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AtsSingleton getInstance() {
        if (instance != null) return instance;
        Class<AtsSingleton> clazz = AtsSingleton.class;
        synchronized (AtsSingleton.class) {
            if (instance != null) return instance;
            instance = new AtsSingleton();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private AtsSingleton() {
    }

    public void setJsonSuitesFilePath(String value) {
        this.jsonSuitesFile = value;
    }

    public File getJsonSuitesFile() {
        if (this.jsonSuitesFile != null && !this.jsonSuitesFile.isBlank()) {
            return Paths.get(this.jsonSuitesFile, new String[0]).toFile();
        }
        return null;
    }

    public void setAtsOutputFolder(String value) {
        this.atsOutputFolder = value;
    }

    public String getAtsOutputFolder() {
        return this.atsOutputFolder;
    }

    public void setLoglevel(String value) {
        this.logLevel = value;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getAtsKey() {
        return this.ats.getAtsKey();
    }

    public String getAtsError() {
        return this.ats.getError();
    }

    public IWaitGuiReady getWaitGuiReady() {
        return this.ats.getWaitGuiReady();
    }

    public int getMaxTrySearch() {
        return this.ats.getMaxTrySearch();
    }

    public int getMaxTryScrollSearch() {
        return this.ats.getMaxTryScrollSearch();
    }

    public ApplicationProperties getApplicationProperties(String appName) {
        return this.ats.getApplicationProperties(appName);
    }

    public int getMaxTryInteractable() {
        return this.ats.getMaxTryInteractable();
    }

    public void setSystemDriver(IDriverInfo sysDriver) {
        if (sysDriver == null && this.systemDriver != null) {
            this.systemDriver.close();
        }
        this.systemDriver = sysDriver;
    }

    public IDriverInfo getSystemDriver(ActionStatus status, ActionTestScript script) {
        if (this.systemDriver == null || !this.systemDriver.isAlive()) {
            DriverInfo driver = null;
            status.setError(0, "no remote agent defined");
            for (URI sysUri : this.ats.getSystemDriverUris()) {
                script.getLogger().sendInfo("try to connect to ats-agent : ", sysUri.toString());
                driver = new DriverInfo(status, "desktop", sysUri, script);
                if (!status.isPassed()) continue;
                break;
            }
            if (status.isPassed()) {
                this.systemDriver = driver;
            } else {
                driver = new DriverInfoLocal(status, this.ats.getDriverPath(), this.getLogLevel(), script);
                if (status.isPassed()) {
                    this.systemDriver = driver;
                } else {
                    return this.systemDriver;
                }
            }
        }
        if (!this.init) {
            this.init = true;
        }
        return this.systemDriver;
    }

    public IDriverInfo relaunchSystemDriver(ActionStatus status, ActionTestScript script) {
        if (this.systemDriver != null) {
            this.systemDriver.close();
            this.systemDriver = null;
        }
        return this.getSystemDriver(status, script);
    }

    public String getSystemValue(String name) {
        Channel cnl = this.channelManager.getCurrentChannel();
        if (cnl != null) {
            return cnl.getSystemValue(name);
        }
        return Channel.systemValueObj(name);
    }

    public void closeChannels(ActionStatus status, List<String> channels) {
        while (channels.size() > 0) {
            this.closeChannel(status, channels.remove(0));
        }
        this.channelManager.switchToLastChannel(status);
    }

    public boolean closeChannel(ActionStatus status, String name) {
        return this.channelManager.closeChannel(status, name);
    }

    public void channelClosed(ActionStatus status, Channel channel) {
        this.channelManager.channelClosed(status, channel);
    }

    public void tearDown() {
        this.channelManager.closeMobileDriver();
    }

    public boolean isDesktopChannel() {
        return this.channelManager.getCurrentChannel().isDesktop();
    }

    public boolean switchChannel(ActionStatus status, String name) {
        return this.channelManager.switchChannel(status, name);
    }

    public Channel getChannel(String name) {
        return this.channelManager.getChannel(name);
    }

    public Channel getCurrentChannel() {
        return this.channelManager.getCurrentChannel();
    }

    public Channel getCurrentChannel(ActionTestScript script) {
        this.channelManager.setMainScript(script);
        return this.channelManager.getCurrentChannel();
    }

    public void startChannel(ActionChannelStart actionChannelStart, ActionTestScript ts, String testName, int testLine) {
        this.channelManager.setMainScript(ts);
        this.channelManager.startChannel(actionChannelStart, testName, testLine);
    }

    public int getMaxTry() {
        return this.channelManager.getMaxTry();
    }

    public int getMaxTryScroll() {
        return this.channelManager.getMaxTryScroll();
    }

    public void sleep(int delay) {
        this.channelManager.getCurrentChannel().sleep(delay);
    }

    public void neoloadAction(ActionNeoload actionNeoload, String testName, int testLine) {
        this.channelManager.getCurrentChannel().neoloadAction(actionNeoload, testName, testLine);
    }

    public void addCalledScript(ActionTestScript sc, String name) {
        Optional<ActionTestScript> opScript = this.scriptCallTree.stream().filter(a -> a.getCanonicalName().equals(name)).findFirst();
        if (opScript.isPresent()) {
            this.scriptCallTree.remove(opScript.get());
        }
        this.scriptCallTree.add(sc);
    }

    public String getGlobalVariableValue(String varPath) {
        int lastDot = varPath.lastIndexOf(".");
        if (lastDot > -1) {
            Variable scVar;
            String scriptPath = varPath.substring(0, lastDot);
            Optional<ActionTestScript> sc = this.scriptCallTree.stream().filter(a -> a.getCanonicalName().equals(scriptPath)).findFirst();
            if (sc.isPresent() && (scVar = sc.get().getVariable(varPath.substring(lastDot + 1))) != null) {
                return scVar.getCalculatedValue();
            }
        }
        return null;
    }

    public Map<String, String> getGlobalVariables() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.scriptCallTree.stream().forEach(s -> AtsSingleton.addGlobalVar(result, s));
        return result;
    }

    private static void addGlobalVar(HashMap<String, String> map, ActionTestScript ts) {
        String scriptName = ts.getTestName();
        ts.getVariables().forEach(v -> map.put(scriptName + "." + v.getName(), v.getCalculatedValue()));
    }

    public TestBound getApplicationBound() {
        return this.ats.getApplicationBound();
    }

    public int getMaxTryProperty() {
        return this.ats.getMaxTryProperty();
    }

    public int getMaxTryWebservice() {
        return this.ats.getMaxTryWebservice();
    }

    public int getWebServiceTimeOut() {
        return this.ats.getWebServiceTimeOut();
    }

    public String getNeoloadDesignApi() {
        return this.ats.getNeoloadDesignApi();
    }

    public AtsProxy getNeoloadProxy() {
        return this.ats.getNeoloadProxy();
    }

    public AtsProxy getProxy() {
        return this.ats.getProxy();
    }

    public AtsManager getAts() {
        return this.ats;
    }

    public int getMaxTryImageRecognition() {
        return this.ats.getMaxTryImageRecognition();
    }

    public Class<ActionTestScript> loadTestScriptClass(String scriptName) {
        return this.ats.loadTestScriptClass(scriptName);
    }

    public int getRegexTimeOut() {
        return this.ats.getRegexTimeOut();
    }
}

