/*
 * Decompiled with CFR 0.152.
 */
package com.ats.driver;

import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsProxy;
import com.ats.executor.ActionTestScript;
import com.ats.executor.TestBound;
import com.ats.tools.AtsClassLoader;
import com.ats.tools.Utils;
import com.ats.tools.performance.external.OctoperfApi;
import com.ats.tools.wait.IWaitGuiReady;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AtsManager {
    public static final String ATS_FOLDER_SIMPLE = "ats";
    public static final String ATS_FOLDER = ".actiontestscript";
    private static final String DRIVERS_FOLDER = "drivers";
    private static final String ATS_PROPERTIES_FILE = ".atsProperties";
    private static final int SYSTEM_DRIVER_PORT = 9700;
    private static final Double APPLICATION_WIDTH = 1280.0;
    private static final Double APPLICATION_HEIGHT = 960.0;
    private static final Double APPLICATION_X = 10.0;
    private static final Double APPLICATION_Y = 10.0;
    private static final int SCRIPT_TIMEOUT = 60;
    private static final int PAGELOAD_TIMEOUT = 120;
    private static final int WATCHDOG_TIMEOUT = 200;
    private static final int WEBSERVICE_TIMEOUT = 30;
    private static final int REGEX_TIMEOUT = 5;
    private static final int MAX_TRY_SEARCH = 15;
    private static final int MAX_TRY_INTERACTABLE = 20;
    private static final int MAX_TRY_PROPERTY = 10;
    private static final int MAX_TRY_WEBSERVICE = 1;
    private static final int MAX_TRY_IMAGE_RECOGNITION = 20;
    private static final int MAX_TRY_SCROLL_SEARCH = 15;
    private static final int SAP_START_TIMEOUT = 180;
    private static final int MAX_TRY_MOBILE = 5;
    private static final int SCROLL_UNIT = 120;
    private static final int MAX_STALE_OR_JAVASCRIPT_ERROR = 10;
    private static final int CAPTURE_PROXY_TRAFFIC_IDLE = 3;
    private static final String ATS_KEY_NAME = "ATS_KEY";
    private double applicationWidth = APPLICATION_WIDTH;
    private double applicationHeight = APPLICATION_HEIGHT;
    private double applicationX = APPLICATION_X;
    private double applicationY = APPLICATION_Y;
    private int scriptTimeOut = 60;
    private int pageloadTimeOut = 120;
    private int watchDogTimeOut = 200;
    private int regexTimeOut = 5;
    private int sapStartTimeOut = 180;
    private int webServiceTimeOut = 30;
    private int maxTrySearch = 15;
    private int maxTryInteractable = 20;
    private int maxTryProperty = 10;
    private int maxTryWebservice = 1;
    private int maxTryMobile = 5;
    private int maxTryImageRecognition = 20;
    private int maxTryScrollSearch = 15;
    private int waitEnterText = 0;
    private int waitSearch = 0;
    private int waitMouseMove = 0;
    private int waitSwitchWindow = 0;
    private int waitGotoUrl = 0;
    private AtsProxy proxy;
    private AtsProxy neoloadProxy;
    private String neoloadDesignApi;
    private OctoperfApi octoperf;
    private ArrayList<String> blackListServers;
    private int trafficIdle = 3;
    private List<ApplicationProperties> applicationsList = new ArrayList<ApplicationProperties>();
    private String error;
    private String atsKey;
    private AtsClassLoader atsClassLoader;
    private Path driverPath;
    private List<URI> systemDriverUris = new ArrayList<URI>();

    public static int getScrollUnit() {
        return 120;
    }

    public static int getMaxStaleOrJavaScriptError() {
        return 10;
    }

    private static String getElementText(Node node) {
        return AtsManager.getElementText((Element)node);
    }

    private static String getElementText(Element elem) {
        String textContent;
        if (elem != null && (textContent = elem.getTextContent()) != null && textContent.length() > 0) {
            return textContent.replaceAll("\n", "").replaceAll("\r", "").trim();
        }
        return null;
    }

    private static double getElementDouble(Element elem) {
        String value = elem.getTextContent().replaceAll("\n", "").replaceAll("\r", "").trim();
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    private static int getElementInt(Element elem) {
        String value = elem.getTextContent().replaceAll("\n", "").replaceAll("\r", "").trim();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public AtsManager() {
        this.init();
    }

    public static String getAtsHomeFolder() {
        Object atsHome = System.getProperty("ats.home");
        if (!(atsHome != null && ((String)atsHome).length() != 0 || (atsHome = System.getenv("ATS_HOME")) != null && ((String)atsHome).length() != 0 || (atsHome = System.getProperty("user.home") + File.separator + ATS_FOLDER) != null && ((String)atsHome).length() != 0)) {
            atsHome = System.getProperty("user.home") + File.separator + ATS_FOLDER_SIMPLE;
        }
        return atsHome;
    }

    public void init() {
        String atsHome = AtsManager.getAtsHomeFolder();
        Path atsFolderPath = null;
        try {
            atsFolderPath = Paths.get(atsHome, new String[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (atsFolderPath != null && atsFolderPath.toFile().exists()) {
            Path userHomePath = Paths.get(System.getProperty("user.home"), new String[0]);
            Path atsPropertiesFilePath = userHomePath.resolve(ATS_PROPERTIES_FILE);
            if (!Files.exists(atsPropertiesFilePath, new LinkOption[0]) && !Files.exists(atsPropertiesFilePath = userHomePath.resolve(ATS_FOLDER).resolve(ATS_PROPERTIES_FILE), new LinkOption[0])) {
                atsPropertiesFilePath = atsFolderPath.resolve(ATS_PROPERTIES_FILE);
            }
            this.loadProperties(atsPropertiesFilePath);
            this.addSystemDriver(System.getProperty("system-driver-url"));
            this.driverPath = atsFolderPath.resolve(DRIVERS_FOLDER);
        } else {
            this.driverPath = Paths.get("", new String[0]);
        }
        if (this.proxy == null) {
            this.proxy = new AtsProxy("system");
        }
        this.atsClassLoader = new AtsClassLoader(this);
    }

    public IWaitGuiReady getWaitGuiReady() {
        return this.atsClassLoader.getWaitGuiReady();
    }

    public Class<ActionTestScript> loadTestScriptClass(String name) {
        return this.atsClassLoader.loadTestScriptClass(name);
    }

    public Path getDriverPath() {
        return this.driverPath;
    }

    public List<URI> getSystemDriverUris() {
        return this.systemDriverUris;
    }

    private void addSystemDriver(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            if (!((String)value).startsWith("http")) {
                value = "http://" + (String)value;
            }
            if (((String)value).split(":").length != 3) {
                value = (String)value + ":9700";
            }
            try {
                URI newUri = new URI((String)value);
                if (!this.uriExists(newUri)) {
                    this.systemDriverUris.add(newUri);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean uriExists(URI u) {
        for (URI uri : this.systemDriverUris) {
            if (!uri.toString().equals(u.toString())) continue;
            return true;
        }
        return false;
    }

    private void loadProperties(Path propertiesPath) {
        File xmlFile = propertiesPath.toFile();
        if (xmlFile.exists()) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                    Document doc = dBuilder.parse(xmlFile);
                    doc.getDocumentElement().normalize();
                    NodeList executeChildren = ((Element)doc.getChildNodes().item(0)).getChildNodes();
                    block198: for (int i = 0; i < executeChildren.getLength(); ++i) {
                        if (!(executeChildren.item(i) instanceof Element)) continue;
                        Element type = (Element)executeChildren.item(i);
                        String url = null;
                        switch (type.getNodeName().toLowerCase()) {
                            case "atskey": {
                                this.atsKey = type.getChildNodes().item(0).getNodeValue();
                                continue block198;
                            }
                            case "systemdriver": {
                                NodeList dl = type.getChildNodes();
                                if (dl == null) continue block198;
                                for (int k = 0; k < dl.getLength(); ++k) {
                                    if (!"driver".equals(dl.item(k).getNodeName())) continue;
                                    this.addSystemDriver(AtsManager.getElementText(dl.item(k)));
                                }
                                continue block198;
                            }
                            case "atsremoteagents": {
                                NodeList urls = type.getElementsByTagName("url");
                                for (int j = 0; j < urls.getLength(); ++j) {
                                    this.addSystemDriver(AtsManager.getElementText(urls.item(j)));
                                }
                                continue block198;
                            }
                            case "performance": {
                                NodeList perfChildren = type.getChildNodes();
                                block201: for (int j = 0; j < perfChildren.getLength(); ++j) {
                                    if (!(perfChildren.item(j) instanceof Element)) continue;
                                    Element perfElement = (Element)perfChildren.item(j);
                                    switch (perfElement.getNodeName().toLowerCase()) {
                                        case "idle": {
                                            this.trafficIdle = AtsManager.getElementInt(perfElement);
                                            continue block201;
                                        }
                                        case "octoperf": {
                                            String host = null;
                                            String apiKey = null;
                                            String workspaceName = null;
                                            String projectName = null;
                                            NodeList nl = perfElement.getElementsByTagName("host");
                                            if (nl != null) {
                                                host = AtsManager.getElementText(nl.item(0));
                                            }
                                            if ((nl = perfElement.getElementsByTagName("apiKey")) != null) {
                                                apiKey = AtsManager.getElementText(nl.item(0));
                                            }
                                            if ((nl = perfElement.getElementsByTagName("workspaceName")) != null) {
                                                workspaceName = AtsManager.getElementText(nl.item(0));
                                            }
                                            if ((nl = perfElement.getElementsByTagName("projectName")) != null) {
                                                projectName = AtsManager.getElementText(nl.item(0));
                                            }
                                            if (host == null || apiKey == null) continue block201;
                                            this.octoperf = new OctoperfApi(host, apiKey, workspaceName, projectName);
                                            continue block201;
                                        }
                                        case "blacklist": {
                                            this.blackListServers = new ArrayList();
                                            NodeList blackList = perfElement.getElementsByTagName("url");
                                            for (int k = 0; k < blackList.getLength(); ++k) {
                                                if (!(blackList.item(k) instanceof Element)) continue;
                                                this.blackListServers.add(AtsManager.getElementText(blackList.item(k)));
                                            }
                                            continue block201;
                                        }
                                    }
                                }
                                continue block198;
                            }
                            case "neoload": {
                                NodeList neoloadChildren = type.getChildNodes();
                                for (int j = 0; j < neoloadChildren.getLength(); ++j) {
                                    if (!(neoloadChildren.item(j) instanceof Element)) continue;
                                    Element neoloadElement = (Element)neoloadChildren.item(j);
                                    String host = null;
                                    String port = null;
                                    Object api = null;
                                    String apiPort = null;
                                    if (neoloadElement.getTagName().equals("recorder")) {
                                        NodeList recorderChildren = neoloadElement.getChildNodes();
                                        for (k = 0; k < recorderChildren.getLength(); ++k) {
                                            if (!(recorderChildren.item(k) instanceof Element)) continue;
                                            Element recorderElement = (Element)recorderChildren.item(k);
                                            if (recorderElement.getNodeName().equals("host")) {
                                                host = AtsManager.getElementText(recorderElement);
                                                continue;
                                            }
                                            if (!recorderElement.getNodeName().equals("port")) continue;
                                            port = AtsManager.getElementText(recorderElement);
                                        }
                                    } else if (neoloadElement.getTagName().equals("design")) {
                                        NodeList designChildren = neoloadElement.getChildNodes();
                                        for (k = 0; k < designChildren.getLength(); ++k) {
                                            if (!(designChildren.item(k) instanceof Element)) continue;
                                            Element designElement = (Element)designChildren.item(k);
                                            if (designElement.getNodeName().equals("api")) {
                                                api = AtsManager.getElementText(designElement);
                                                continue;
                                            }
                                            if (!designElement.getNodeName().equals("port")) continue;
                                            apiPort = AtsManager.getElementText(designElement);
                                        }
                                    }
                                    if (host == null || port == null) continue;
                                    this.neoloadProxy = new AtsProxy(host, Utils.string2Int(port, 8080));
                                    if (api == null || apiPort == null) continue;
                                    if (!((String)api).startsWith("/")) {
                                        api = "/" + (String)api;
                                    }
                                    if (!((String)api).endsWith("/")) {
                                        api = (String)api + "/";
                                    }
                                    this.neoloadDesignApi = "http://" + this.neoloadProxy.getHost() + ":" + apiPort + (String)api;
                                }
                                continue block198;
                            }
                            case "proxy": {
                                NodeList proxyChildren = type.getChildNodes();
                                String proxyType = null;
                                String host = null;
                                int port = 0;
                                block206: for (int j = 0; j < proxyChildren.getLength(); ++j) {
                                    if (!(proxyChildren.item(j) instanceof Element)) continue;
                                    Element proxyElement = (Element)proxyChildren.item(j);
                                    switch (proxyElement.getNodeName().toLowerCase()) {
                                        case "type": {
                                            proxyType = AtsManager.getElementText(proxyElement);
                                            continue block206;
                                        }
                                        case "host": {
                                            host = AtsManager.getElementText(proxyElement);
                                            continue block206;
                                        }
                                        case "url": {
                                            url = AtsManager.getElementText(proxyElement);
                                            continue block206;
                                        }
                                        case "port": {
                                            port = AtsManager.getElementInt(proxyElement);
                                        }
                                    }
                                }
                                if ("auto".equals(proxyType)) {
                                    this.proxy = new AtsProxy("auto");
                                    continue block198;
                                }
                                if ("direct".equals(proxyType)) {
                                    this.proxy = new AtsProxy("direct");
                                    continue block198;
                                }
                                if ("pac".equals(proxyType)) {
                                    this.proxy = new AtsProxy("pac", url);
                                    continue block198;
                                }
                                if ("manual".equals(proxyType) && host != null && port > 0) {
                                    this.proxy = new AtsProxy("manual", host, port);
                                    continue block198;
                                }
                                this.proxy = new AtsProxy("system");
                                continue block198;
                            }
                            case "appbounding": {
                                NodeList boundingChildren = type.getChildNodes();
                                for (int j = 0; j < boundingChildren.getLength(); ++j) {
                                    if (boundingChildren.item(j) instanceof Element) {
                                        Element boundingElement = (Element)boundingChildren.item(j);
                                        switch (boundingElement.getTagName()) {
                                            case "x": {
                                                this.applicationX = AtsManager.getElementDouble(boundingElement);
                                                break;
                                            }
                                            case "y": {
                                                this.applicationY = AtsManager.getElementDouble(boundingElement);
                                                break;
                                            }
                                            case "width": {
                                                this.applicationWidth = AtsManager.getElementDouble(boundingElement);
                                                break;
                                            }
                                            case "height": {
                                                this.applicationHeight = AtsManager.getElementDouble(boundingElement);
                                            }
                                        }
                                        continue;
                                    }
                                    String content = boundingChildren.item(j).getTextContent();
                                    if (!"fullscreen".equalsIgnoreCase(content) && !"max".equalsIgnoreCase(content) && !"maxscreen".equalsIgnoreCase(content) && !"maxsize".equalsIgnoreCase(content)) continue;
                                    this.applicationX = 0.0;
                                    this.applicationY = 0.0;
                                    this.applicationWidth = -1.0;
                                    this.applicationHeight = -1.0;
                                }
                                continue block198;
                            }
                            case "wait": {
                                NodeList waitChildren = type.getChildNodes();
                                block208: for (int j = 0; j < waitChildren.getLength(); ++j) {
                                    if (!(waitChildren.item(j) instanceof Element)) continue;
                                    Element waitElement = (Element)waitChildren.item(j);
                                    switch (waitElement.getTagName().toLowerCase()) {
                                        case "entertext": {
                                            this.waitEnterText = AtsManager.getElementInt(waitElement);
                                            continue block208;
                                        }
                                        case "search": {
                                            this.waitSearch = AtsManager.getElementInt(waitElement);
                                            continue block208;
                                        }
                                        case "mousemove": {
                                            this.waitMouseMove = AtsManager.getElementInt(waitElement);
                                            continue block208;
                                        }
                                        case "switchwindow": {
                                            this.waitSwitchWindow = AtsManager.getElementInt(waitElement);
                                            continue block208;
                                        }
                                        case "gotourl": {
                                            this.waitGotoUrl = AtsManager.getElementInt(waitElement);
                                        }
                                    }
                                }
                                continue block198;
                            }
                            case "maxtry": {
                                NodeList maxtryChildren = type.getChildNodes();
                                block209: for (int j = 0; j < maxtryChildren.getLength(); ++j) {
                                    if (!(maxtryChildren.item(j) instanceof Element)) continue;
                                    Element maxtryElement = (Element)maxtryChildren.item(j);
                                    switch (maxtryElement.getTagName().toLowerCase()) {
                                        case "searchelement": 
                                        case "elementsearch": {
                                            this.maxTrySearch = AtsManager.getElementInt(maxtryElement);
                                            continue block209;
                                        }
                                        case "interactable": {
                                            this.maxTryInteractable = AtsManager.getElementInt(maxtryElement);
                                            continue block209;
                                        }
                                        case "getproperty": {
                                            this.maxTryProperty = AtsManager.getElementInt(maxtryElement);
                                            continue block209;
                                        }
                                        case "webservice": {
                                            this.maxTryWebservice = AtsManager.getElementInt(maxtryElement);
                                            continue block209;
                                        }
                                        case "searchimage": 
                                        case "imagesearch": {
                                            this.maxTryImageRecognition = AtsManager.getElementInt(maxtryElement);
                                            continue block209;
                                        }
                                        case "searchscroll": 
                                        case "scrollsearch": {
                                            this.maxTryScrollSearch = AtsManager.getElementInt(maxtryElement);
                                        }
                                    }
                                }
                                continue block198;
                            }
                            case "timeout": {
                                NodeList timeoutChildren = type.getChildNodes();
                                block210: for (int j = 0; j < timeoutChildren.getLength(); ++j) {
                                    if (!(timeoutChildren.item(j) instanceof Element)) continue;
                                    Element timeoutElement = (Element)timeoutChildren.item(j);
                                    switch (timeoutElement.getTagName().toLowerCase()) {
                                        case "script": {
                                            this.scriptTimeOut = AtsManager.getElementInt(timeoutElement);
                                            continue block210;
                                        }
                                        case "pageload": {
                                            this.pageloadTimeOut = AtsManager.getElementInt(timeoutElement);
                                            continue block210;
                                        }
                                        case "watchdog": {
                                            this.watchDogTimeOut = AtsManager.getElementInt(timeoutElement);
                                            continue block210;
                                        }
                                        case "regexp": 
                                        case "regex": {
                                            this.regexTimeOut = AtsManager.getElementInt(timeoutElement);
                                            if (this.regexTimeOut <= 5) continue block210;
                                            this.regexTimeOut = 5;
                                            continue block210;
                                        }
                                        case "webservice": {
                                            this.webServiceTimeOut = AtsManager.getElementInt(timeoutElement);
                                        }
                                    }
                                }
                                continue block198;
                            }
                            case "browsers": {
                                NodeList browsers = type.getElementsByTagName("browser");
                                for (int j = 0; j < browsers.getLength(); ++j) {
                                    String name = null;
                                    String waitAction = null;
                                    String path = null;
                                    String driver = null;
                                    String dataDir = null;
                                    String check = null;
                                    String lang = null;
                                    String debugPort = null;
                                    String[] options = null;
                                    String[] excludedOptions = null;
                                    String title = "";
                                    if (!(browsers.item(j) instanceof Element)) continue;
                                    Element browser = (Element)browsers.item(j);
                                    String elementName = browser.getAttribute("name");
                                    if (Utils.isNotEmpty(elementName)) {
                                        name = elementName;
                                    }
                                    NodeList browserAttributes = browser.getChildNodes();
                                    block212: for (int k = 0; k < browserAttributes.getLength(); ++k) {
                                        String nodeName;
                                        if (!(browserAttributes.item(k) instanceof Element)) continue;
                                        Element browserElement = (Element)browserAttributes.item(k);
                                        switch (nodeName = browserElement.getNodeName().toLowerCase()) {
                                            case "name": {
                                                name = AtsManager.getElementText(browserElement);
                                                continue block212;
                                            }
                                            case "waitaction": {
                                                waitAction = AtsManager.getElementText(browserElement);
                                                continue block212;
                                            }
                                            case "title": {
                                                title = AtsManager.getElementText(browserElement);
                                                continue block212;
                                            }
                                            case "driver": {
                                                driver = AtsManager.getElementText(browserElement);
                                                continue block212;
                                            }
                                            case "path": {
                                                path = AtsManager.getElementText(browserElement);
                                                continue block212;
                                            }
                                            case "userdatadir": 
                                            case "userdata": 
                                            case "profile": 
                                            case "profiledir": {
                                                dataDir = AtsManager.getElementText(browserElement);
                                                continue block212;
                                            }
                                            case "waitproperty": {
                                                check = AtsManager.getElementText(browserElement);
                                                continue block212;
                                            }
                                            case "lang": {
                                                lang = AtsManager.getElementText(browserElement);
                                                continue block212;
                                            }
                                            case "debugport": {
                                                debugPort = AtsManager.getElementText(browserElement);
                                                continue block212;
                                            }
                                            case "excludedoptions": {
                                                NodeList excludedOptionsList = browserElement.getElementsByTagName("option");
                                                int excludedOptionsLen = excludedOptionsList.getLength();
                                                if (excludedOptionsLen <= 0) continue block212;
                                                excludedOptions = new String[excludedOptionsLen];
                                                for (int l = 0; l < excludedOptionsLen; ++l) {
                                                    excludedOptions[l] = excludedOptionsList.item(l).getTextContent().replaceFirst("^--", "");
                                                }
                                                continue block212;
                                            }
                                            case "options": {
                                                NodeList optionsList = browserElement.getElementsByTagName("option");
                                                int optionsLen = optionsList.getLength();
                                                if (optionsLen <= 0) continue block212;
                                                options = new String[optionsLen];
                                                for (int l = 0; l < optionsLen; ++l) {
                                                    options[l] = optionsList.item(l).getTextContent();
                                                }
                                                continue block212;
                                            }
                                        }
                                    }
                                    if (name == null) continue;
                                    this.addApplicationProperties(0, name, driver, path, waitAction, check, lang, dataDir, title, options, excludedOptions, debugPort);
                                }
                                continue block198;
                            }
                            case "applications": {
                                NodeList applications = type.getElementsByTagName("application");
                                for (int j = 0; j < applications.getLength(); ++j) {
                                    String name = null;
                                    String waitAction = null;
                                    Object path = null;
                                    String[] options = null;
                                    if (!(applications.item(j) instanceof Element)) continue;
                                    Element application = (Element)applications.item(j);
                                    NodeList applicationAttributes = application.getChildNodes();
                                    block216: for (int k = 0; k < applicationAttributes.getLength(); ++k) {
                                        if (!(applicationAttributes.item(k) instanceof Element)) continue;
                                        Element applicationElement = (Element)applicationAttributes.item(k);
                                        switch (applicationElement.getNodeName().toLowerCase()) {
                                            case "name": {
                                                name = AtsManager.getElementText(applicationElement);
                                                continue block216;
                                            }
                                            case "waitaction": {
                                                waitAction = AtsManager.getElementText(applicationElement);
                                                continue block216;
                                            }
                                            case "path": {
                                                path = AtsManager.getElementText(applicationElement);
                                                if (((String)path).startsWith("file:///")) continue block216;
                                                path = "file:///" + (String)path;
                                                continue block216;
                                            }
                                            case "options": {
                                                NodeList optionsList = application.getElementsByTagName("option");
                                                int optionsLen = optionsList.getLength();
                                                if (optionsLen <= 0) continue block216;
                                                options = new String[optionsLen];
                                                for (int l = 0; l < optionsLen; ++l) {
                                                    options[l] = optionsList.item(l).getTextContent();
                                                }
                                                continue block216;
                                            }
                                        }
                                    }
                                    if (name == null || path == null) continue;
                                    this.addApplicationProperties(1, name, (String)path, waitAction, "", null, null, null, options, null);
                                }
                                continue block198;
                            }
                            case "mobiles": {
                                NodeList mobiles = type.getElementsByTagName("mobile");
                                for (int j = 0; j < mobiles.getLength(); ++j) {
                                    String name = null;
                                    String waitAction = null;
                                    String endpoint = null;
                                    String packageName = null;
                                    if (!(mobiles.item(j) instanceof Element)) continue;
                                    Element mobile = (Element)mobiles.item(j);
                                    NodeList mobileAttributes = mobile.getChildNodes();
                                    block219: for (int k = 0; k < mobileAttributes.getLength(); ++k) {
                                        if (!(mobileAttributes.item(k) instanceof Element)) continue;
                                        Object mobileElement = (Element)mobileAttributes.item(k);
                                        switch (mobileElement.getNodeName().toLowerCase()) {
                                            case "name": {
                                                name = AtsManager.getElementText((Element)mobileElement);
                                                continue block219;
                                            }
                                            case "waitaction": {
                                                waitAction = AtsManager.getElementText((Element)mobileElement);
                                                continue block219;
                                            }
                                            case "endpoint": {
                                                endpoint = AtsManager.getElementText((Element)mobileElement);
                                                continue block219;
                                            }
                                            case "package": {
                                                packageName = AtsManager.getElementText((Element)mobileElement);
                                            }
                                        }
                                    }
                                    if (name == null || endpoint == null || packageName == null) continue;
                                    this.addApplicationProperties(2, name, endpoint + "/" + packageName, waitAction, "", null, null, null, null, null);
                                }
                                continue block198;
                            }
                            case "apis": {
                                NodeList apis = type.getElementsByTagName("api");
                                for (int j = 0; j < apis.getLength(); ++j) {
                                    String name = null;
                                    String waitAction = null;
                                    if (!(apis.item(j) instanceof Element)) continue;
                                    Element api = (Element)apis.item(j);
                                    NodeList apiAttributes = api.getChildNodes();
                                    block221: for (int k = 0; k < apiAttributes.getLength(); ++k) {
                                        if (!(apiAttributes.item(k) instanceof Element)) continue;
                                        Element apiElement = (Element)apiAttributes.item(k);
                                        switch (apiElement.getNodeName().toLowerCase()) {
                                            case "name": {
                                                name = AtsManager.getElementText(apiElement);
                                                continue block221;
                                            }
                                            case "waitaction": {
                                                waitAction = AtsManager.getElementText(apiElement);
                                                continue block221;
                                            }
                                            case "url": {
                                                url = AtsManager.getElementText(apiElement);
                                            }
                                        }
                                    }
                                    if (name == null || url == null) continue;
                                    this.addApplicationProperties(3, name, url, waitAction, "", null, null, null, null, null);
                                }
                                continue block198;
                            }
                            case "sap": {
                                NodeList sapChilds = type.getChildNodes();
                                for (int j = 0; j < sapChilds.getLength(); ++j) {
                                    int k;
                                    Node sapElement = sapChilds.item(j);
                                    String sapElementName = sapElement.getNodeName().toLowerCase();
                                    if ("timeout".equals(sapElementName)) {
                                        NodeList toList = sapElement.getChildNodes();
                                        for (k = 0; k < toList.getLength(); ++k) {
                                            Node toElement = toList.item(k);
                                            String toElementName = toElement.getNodeName().toLowerCase();
                                            if (!"startdriver".equals(toElementName)) continue;
                                            this.sapStartTimeOut = AtsManager.getElementInt((Element)toElement);
                                        }
                                        continue;
                                    }
                                    if (!"sessions".equals(sapElementName)) continue;
                                    NodeList sessionsList = sapElement.getChildNodes();
                                    for (k = 0; k < sessionsList.getLength(); ++k) {
                                        String name = null;
                                        String client = null;
                                        String connection = null;
                                        String authentication = null;
                                        String lang = null;
                                        Node sessionElement = sessionsList.item(k);
                                        NodeList sessionProps = sessionElement.getChildNodes();
                                        block225: for (int l = 0; l < sessionProps.getLength(); ++l) {
                                            Node sessionProp = sessionProps.item(l);
                                            switch (sessionProp.getNodeName().toLowerCase()) {
                                                case "name": {
                                                    name = AtsManager.getElementText(sessionProp);
                                                    continue block225;
                                                }
                                                case "client": {
                                                    client = AtsManager.getElementText(sessionProp);
                                                    continue block225;
                                                }
                                                case "connection": {
                                                    connection = AtsManager.getElementText(sessionProp);
                                                    continue block225;
                                                }
                                                case "authentication": {
                                                    authentication = AtsManager.getElementText(sessionProp);
                                                    continue block225;
                                                }
                                                case "lang": {
                                                    lang = AtsManager.getElementText(sessionProp);
                                                }
                                            }
                                        }
                                        if (name == null || client == null || connection == null) continue;
                                        this.applicationsList.add(new ApplicationProperties(name, connection, client, authentication, lang));
                                    }
                                }
                                continue block198;
                            }
                        }
                    }
                }
                catch (ParserConfigurationException e) {
                    this.error = e.getMessage();
                }
                catch (SAXException e) {
                    this.error = e.getMessage();
                }
            }
            catch (IOException e) {
                this.error = e.getMessage();
            }
        }
    }

    private void addApplicationProperties(int type, String name, String path, String wait, String check, String lang, String userDataDir, String title, String[] options, String[] excludedOptions) {
        this.addApplicationProperties(type, name, null, path, wait, check, lang, userDataDir, title, options, excludedOptions, null);
    }

    private void addApplicationProperties(int type, String name, String driver, String path, String wait, String check, String lang, String userDataDir, String title, String[] options, String[] excludedOptions, String debugPort) {
        this.applicationsList.add(new ApplicationProperties(type, name, driver, path, Utils.string2Int(wait, -1), Utils.string2Int(check, -1), lang, userDataDir, title, options, excludedOptions, Utils.string2Int(debugPort, -1)));
    }

    public String getError() {
        return this.error;
    }

    public ApplicationProperties getApplicationProperties(String name) {
        for (int i = 0; i < this.applicationsList.size(); ++i) {
            ApplicationProperties properties = this.applicationsList.get(i);
            if (!name.equals(properties.getName())) continue;
            return properties;
        }
        return new ApplicationProperties(name);
    }

    public int getScriptTimeOut() {
        return this.scriptTimeOut;
    }

    public int getSapStartTimeout() {
        return this.sapStartTimeOut;
    }

    public int getPageloadTimeOut() {
        return this.pageloadTimeOut;
    }

    public int getRegexTimeOut() {
        return this.regexTimeOut;
    }

    public int getWatchDogTimeOut() {
        return this.watchDogTimeOut;
    }

    public int getWebServiceTimeOut() {
        return this.webServiceTimeOut;
    }

    public TestBound getApplicationBound() {
        return new TestBound(this.applicationX, this.applicationY, this.applicationWidth, this.applicationHeight);
    }

    public int getMaxTrySearch() {
        return this.maxTrySearch;
    }

    public int getMaxTryInteractable() {
        return this.maxTryInteractable;
    }

    public int getMaxTryImageRecognition() {
        return this.maxTryImageRecognition;
    }

    public int getMaxTryScrollSearch() {
        return this.maxTryScrollSearch;
    }

    public int getMaxTryProperty() {
        return this.maxTryProperty;
    }

    public int getMaxTryMobile() {
        return this.maxTryMobile;
    }

    public int getMaxTryWebservice() {
        return this.maxTryWebservice;
    }

    public int getWaitEnterText() {
        return this.waitEnterText;
    }

    public int getWaitSearch() {
        return this.waitSearch;
    }

    public int getWaitMouseMove() {
        return this.waitMouseMove;
    }

    public int getWaitSwitchWindow() {
        return this.waitSwitchWindow;
    }

    public int getWaitGotoUrl() {
        return this.waitGotoUrl;
    }

    public String getNeoloadDesignApi() {
        return this.neoloadDesignApi;
    }

    public AtsProxy getNeoloadProxy() {
        if (this.neoloadProxy != null) {
            return this.neoloadProxy;
        }
        return this.getProxy();
    }

    public AtsProxy getProxy() {
        return this.proxy;
    }

    public ArrayList<String> getBlackListServers() {
        return this.blackListServers;
    }

    public OctoperfApi getOctoperf() {
        return this.octoperf;
    }

    public int getTrafficIdle() {
        return this.trafficIdle;
    }

    public String getAtsKey() {
        String key = System.getenv(ATS_KEY_NAME);
        if (key != null && key.length() == 16) {
            return key;
        }
        if (this.atsKey != null && this.atsKey.length() == 16) {
            return this.atsKey;
        }
        return null;
    }

    public String getApplicationsList() {
        ObjectWriter ow = new ObjectMapper().writer();
        try {
            return ow.writeValueAsString(this.applicationsList);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "";
        }
    }
}

