/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.channels;

import com.ats.AtsSingleton;
import com.ats.driver.ApplicationProperties;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.EmptyChannel;
import com.ats.executor.channels.MobileChannel;
import com.ats.executor.channels.MobileChromeChannel;
import com.ats.executor.drivers.DriverManager;
import com.ats.script.actions.ActionChannelStart;
import com.ats.tools.Utils;
import com.ats.tools.wait.IWaitGuiReady;
import com.ats.tools.wait.WaitGuiReady;
import java.util.ArrayList;
import java.util.Optional;

public class ChannelManager {
    private Channel currentChannel;
    private ActionTestScript mainScript;
    private ArrayList<Channel> channelsList = new ArrayList();
    private DriverManager driverManager = new DriverManager();

    public void setMainScript(ActionTestScript script) {
        this.mainScript = script;
        IWaitGuiReady guiReady = AtsSingleton.getInstance().getWaitGuiReady();
        if (guiReady != null && !(guiReady instanceof WaitGuiReady)) {
            script.getLogger().sendInfo("Custom WaitGuiReady class found ", guiReady.toString());
        }
    }

    public int getMaxTry() {
        return AtsSingleton.getInstance().getMaxTrySearch();
    }

    public int getMaxTryScroll() {
        return AtsSingleton.getInstance().getMaxTryScrollSearch();
    }

    public Channel getCurrentChannel() {
        if (this.currentChannel == null) {
            this.currentChannel = new EmptyChannel();
        }
        return this.currentChannel;
    }

    public Channel[] getChannelsList() {
        if (this.channelsList.size() > 0) {
            return this.channelsList.toArray(new Channel[this.channelsList.size()]);
        }
        return new Channel[0];
    }

    private void setCurrentChannel(Channel channel) {
        for (Channel cnl : this.channelsList) {
            cnl.setCurrent(cnl == channel);
        }
        channel.setCurrent(true);
        this.currentChannel = channel;
    }

    public void closeAllChannels() {
        while (this.channelsList.size() > 0) {
            this.channelsList.remove(0).close();
        }
    }

    public Channel getChannel(String name) {
        for (Channel cnl : this.channelsList) {
            if (!cnl.isSameName(name)) continue;
            this.currentChannel = cnl;
            return cnl;
        }
        return new EmptyChannel();
    }

    public void startChannel(ActionChannelStart action, String testName, int testLine) {
        Object name = action.getName();
        if (name == null || ((String)name).isBlank()) {
            name = "[CNL-" + Utils.getShortUid() + "]";
            action.setName((String)name);
        }
        String appName = action.getApplication().getCalculated();
        ApplicationProperties props = AtsSingleton.getInstance().getApplicationProperties(appName);
        action.setStatus(new ActionStatus(testName, testLine));
        Channel channel = this.getChannel((String)name);
        if (channel instanceof EmptyChannel) {
            channel = props.isMobile() || appName.startsWith("mobile://") ? new MobileChannel(action, this.mainScript, this.driverManager, testName, testLine) : (appName.startsWith("mobile-chrome://") ? new MobileChromeChannel(action, this.mainScript, this.driverManager, testName, testLine) : new Channel(action, this.mainScript, this.driverManager, testName, testLine));
            action.getStatus().setChannel(channel);
            if (action.getStatus().isPassed()) {
                for (Channel cn : this.channelsList) {
                    cn.clearData();
                }
                this.addChannel(channel);
                this.mainScript.getRecorder().createVisualStartChannelAction(action, action.getStatus().getDuration(), testName, testLine);
            }
            action.getStatus().setData(this.getChannelsList());
        } else {
            action.getStatus().setChannel(channel);
        }
    }

    private void addChannel(Channel cnl) {
        this.channelsList.add(cnl);
        this.setCurrentChannel(cnl);
    }

    public void switchToLastChannel(ActionStatus status) {
        if (this.channelsList != null && this.channelsList.size() > 0) {
            this.switchChannel(status, this.channelsList.get(this.channelsList.size() - 1).getName());
        } else {
            this.currentChannel = new EmptyChannel();
        }
    }

    public boolean switchChannel(ActionStatus status, String name) {
        status.startDuration();
        if (this.channelsList != null) {
            for (Channel cnl : this.channelsList) {
                if (!cnl.isSameName(name)) continue;
                if (!cnl.isCurrent()) {
                    this.setCurrentChannel(cnl);
                    status.setData(this.getChannelsList());
                    status.setChannel(cnl);
                }
                status.setPassed(true);
                status.endDuration();
                return true;
            }
        }
        return false;
    }

    public boolean closeChannel(ActionStatus status, String channelName) {
        Optional<Channel> cn = this.channelsList.stream().filter(c -> c.isSameName(channelName)).findFirst();
        if (cn.isPresent()) {
            cn.get().close(status);
            return true;
        }
        return false;
    }

    public void channelClosed(ActionStatus status, Channel channel) {
        status.startDuration();
        if (this.channelsList.remove(channel)) {
            if (this.channelsList.size() > 0) {
                if (channel.isCurrent()) {
                    Channel current = this.channelsList.get(0);
                    this.setCurrentChannel(current);
                    status.setChannel(current);
                }
            } else {
                this.currentChannel = new EmptyChannel();
            }
            status.setNoError();
            status.setData(this.getChannelsList());
            status.setValue(channel.getApplication());
        } else {
            status.setError(-19, "channel '" + channel.getName() + "' not found");
        }
        status.endDuration();
    }

    public void tearDown() {
        this.closeAllChannels();
        this.closeMobileDriver();
    }

    public void closeMobileDriver() {
        this.driverManager.tearDown();
    }
}

