/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines;

import com.ats.data.Dimension;
import com.ats.data.Point;
import com.ats.data.Rectangle;
import com.ats.driver.ApplicationProperties;
import com.ats.driver.AtsRemoteWebDriver;
import com.ats.element.FoundElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.TestBound;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.generator.objects.BoundData;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.MouseDirection;
import com.ats.generator.objects.MouseDirectionData;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.graphic.ImageTemplateMatchingSimple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class DriverEngine {
    protected Channel channel;
    protected AtsRemoteWebDriver driver;
    private SystemDriver systemDriver;
    private IDriverInfo driverInfo;
    protected String applicationPath;
    protected int currentWindow = 0;
    protected String mainWindowHandle = null;
    protected Set<String> windowHandles = null;
    protected Set<String> blackListWindowHandles = null;
    private int actionWait = -1;
    private int propertyWait = -1;

    public DriverEngine(Channel channel) {
        this.channel = channel;
    }

    public DriverEngine(Channel channel, IDriverInfo driverInfo, SystemDriver systemDriver) {
        this(channel);
        this.setDriverInfo(driverInfo);
        this.setSystemEngine(systemDriver);
        channel.setDriverUrl(driverInfo.getDriverHostAndPort().toString());
    }

    public DriverEngine(Channel channel, SystemDriver systemDriver, IDriverInfo driverInfo, ApplicationProperties props) {
        this(channel, driverInfo, systemDriver);
    }

    public DriverEngine(Channel channel, IDriverInfo driverInfo, SystemDriver systemDriver, ApplicationProperties props, int defaultWait, int defaultCheck) {
        this(channel, driverInfo, systemDriver);
        this.actionWait = props.getWait();
        this.propertyWait = props.getCheck();
        this.applicationPath = props.getUri();
        if (this.actionWait == -1) {
            this.actionWait = defaultWait;
        }
        if (this.propertyWait == -1) {
            this.propertyWait = defaultCheck;
        }
    }

    public void started(ActionStatus status) {
    }

    public void updateScreenshot(TestBound dimension, boolean isRef) {
        this.getSystemDriver().updateVisualImage(dimension, isRef);
    }

    public void createVisualAction(Channel channel, boolean stop, String actionType, int scriptLine, String scriptName, long timeline, boolean sync) {
        this.getSystemDriver().createVisualAction(channel, stop, actionType, scriptLine, scriptName, timeline, sync);
    }

    public TestElement getTestElementRoot() {
        return new TestElement(this.channel);
    }

    private void setDriverInfo(IDriverInfo value) {
        this.driverInfo = value;
    }

    public IDriverInfo getDriverInfo() {
        return this.driverInfo;
    }

    private void setSystemEngine(SystemDriver value) {
        this.systemDriver = value;
    }

    public SystemDriver getSystemDriver() {
        return this.systemDriver;
    }

    public int getCurrentWindow() {
        return this.currentWindow;
    }

    public void setDriver(AtsRemoteWebDriver driver) {
        this.driver = driver;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void actionWait() {
        this.channel.sleep(this.actionWait);
    }

    public int getActionWait() {
        return this.actionWait;
    }

    public int getPropertyWait() {
        return this.propertyWait;
    }

    protected double getCartesianOffset(double value, MouseDirectionData direction, Cartesian cart1, Cartesian cart2, Cartesian cart3) {
        if (direction != null) {
            if (cart1.equals(direction.getName())) {
                return direction.getIntValue() + 1;
            }
            if (cart3.equals(direction.getName())) {
                return value - direction.getDoubleValue() - 2.0;
            }
            return direction.getDoubleValue() + value / 2.0;
        }
        return value / 2.0;
    }

    public double getOffsetX(Rectangle rect, MouseDirection position) {
        return this.getCartesianOffset(rect.getWidth(), position.getHorizontalPos(), Cartesian.LEFT, Cartesian.CENTER, Cartesian.RIGHT);
    }

    public double getOffsetY(Rectangle rect, MouseDirection position) {
        return this.getCartesianOffset(rect.getHeight(), position.getVerticalPos(), Cartesian.TOP, Cartesian.MIDDLE, Cartesian.BOTTOM);
    }

    public String setWindowBound(BoundData x, BoundData y, BoundData w, BoundData h) {
        int newX = 0;
        int newY = 0;
        int newWidth = 0;
        int newHeight = 0;
        if (w != null || h != null) {
            newWidth = w != null ? w.getValue() : this.channel.getDimension().getWidth().intValue();
            newHeight = h != null ? h.getValue() : this.channel.getDimension().getHeight().intValue();
            this.setSize(new Dimension(newWidth, newHeight));
        }
        if (x != null || y != null) {
            newX = x != null ? x.getValue() : this.channel.getDimension().getX().intValue();
            newY = y != null ? y.getValue() : this.channel.getDimension().getY().intValue();
            this.setPosition(new Point(newX, newY));
        }
        return newX + "," + newY + "," + newWidth + "," + newHeight;
    }

    protected boolean desktopMoveToElement(FoundElement foundElement, MouseDirection position, int offsetX, int offsetY) {
        Rectangle rect = foundElement.getRectangle();
        this.getSystemDriver().mouseMove(this.getOffsetX(rect, position) + (double)foundElement.getScreenX().intValue() + (double)offsetX, this.getOffsetY(rect, position) + (double)foundElement.getScreenY().intValue() + (double)offsetY);
        return true;
    }

    protected abstract void setPosition(Point var1);

    protected abstract void setSize(Dimension var1);

    public List<FoundElement> findElements(TestElement parent, ImageTemplateMatchingSimple template) {
        this.channel.setWindowToFront();
        this.channel.refreshLocation();
        TestBound outterBound = null;
        outterBound = parent != null ? parent.getFoundElement().getTestScreenBound() : this.channel.getDimension();
        return template.findOccurrences(this.getSystemDriver().getScreenshotByte(outterBound.getX(), outterBound.getY(), outterBound.getWidth(), outterBound.getHeight())).parallelStream().map(r -> new FoundElement(this.channel, parent, (Rectangle)r)).collect(Collectors.toCollection(ArrayList::new));
    }

    public byte[] getScreenshot(Double x, Double y, Double width, Double height) {
        return this.getSystemDriver().getScreenshotByte(x, y, width, height);
    }

    public CalculatedProperty[] getCssAttributes(FoundElement element) {
        return new CalculatedProperty[0];
    }

    public String getCurrentHandle() {
        return String.valueOf(this.channel.getHandle());
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setMainWindowHandle(String mainWindowHandle) {
        this.mainWindowHandle = mainWindowHandle;
    }

    public String getMainWindowHandle() {
        return this.mainWindowHandle;
    }

    public void setWindowHandles(Set<String> windowHandles) {
        this.windowHandles = windowHandles;
    }

    public Set<String> getWindowHandles() {
        return this.windowHandles;
    }

    public void setBlackListWindowHandles() {
        this.blackListWindowHandles = new HashSet<String>(this.windowHandles);
        this.blackListWindowHandles.remove(this.mainWindowHandle);
    }

    public Set<String> getBlackListWindowHandles() {
        return this.blackListWindowHandles;
    }
}

