/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.browsers.capabilities;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.browsers.BrowserArgumentsParser;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class FirefoxOptions
extends org.openqa.selenium.firefox.FirefoxOptions {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> options = new HashMap<String, Object>();

    public FirefoxOptions(BrowserArgumentsParser browserArguments, ApplicationProperties props, SystemDriver systemDriver) {
        if (browserArguments.getBinaryPath() != null) {
            this.setBinary(browserArguments.getBinaryPath());
        }
        if (browserArguments.isHeadless() || !systemDriver.isInteractive()) {
            this.addArguments(new String[]{"-headless"});
        }
        if (browserArguments.isIncognito()) {
            this.addArguments(new String[]{"-private"});
        }
        if (browserArguments.getUserDataPath() != null) {
            File dir = new File(browserArguments.getUserDataPath());
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.addArguments(new String[]{"-profile", browserArguments.getUserDataPath()});
        }
        for (String opt : browserArguments.getMoreOptions()) {
            this.addArguments(new String[]{opt});
        }
        if (browserArguments.getLang() != null) {
            this.addPreference("intl.locale.requested", browserArguments.getLang());
        }
        HashSet<String> excludedOptions = new HashSet<String>(Arrays.asList(props.getExcludedOptions()));
        super.asMap().forEach((k, v) -> {
            if (!excludedOptions.contains(k)) {
                this.options.put((String)k, v);
            }
        });
    }

    public Map<String, Object> asMap() {
        return this.options;
    }
}

