/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers.engines.desktop;

import com.ats.driver.ApplicationProperties;
import com.ats.executor.ActionStatus;
import com.ats.executor.channels.Channel;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.executor.drivers.desktop.SystemDriver;
import com.ats.executor.drivers.engines.SystemDriverEngine;

public class ExplorerDriverEngine
extends SystemDriverEngine {
    private static final int DEFAULT_WAIT = 100;

    public ExplorerDriverEngine(Channel channel, ActionStatus status, IDriverInfo driverInfo, SystemDriver desktopDriver, ApplicationProperties props) {
        super(channel, driverInfo, desktopDriver, props, 100);
        int maxTry = 10;
        while (maxTry > 0) {
            this.window = desktopDriver.openExplorerWindow();
            if (this.window != null) {
                channel.setApplicationData("explorer", desktopDriver.getOsFullName(), this.window.getHandle(), this.window.getAppIcon());
                desktopDriver.moveWindow(channel, channel.getDimension().getPoint());
                desktopDriver.resizeWindow(channel, channel.getDimension().getSize());
                maxTry = 0;
                continue;
            }
            channel.sleep(300);
            --maxTry;
        }
    }

    @Override
    public void close() {
        this.getSystemDriver().closeExplorerWindow(this.window.getHandle());
    }

    @Override
    public void closeWindow(ActionStatus status) {
        super.closeWindow(status);
    }
}

