/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.parameter;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.parameter.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.openqa.selenium.WebElement;

public class ParameterList {
    private int iteration = 1;
    private WebElement webElement;
    private ArrayList<Parameter> list;

    public ParameterList() {
        this(0);
    }

    public ParameterList(int iteration) {
        this.list = new ArrayList();
        this.iteration = iteration;
    }

    public ParameterList(int iteration, List<Parameter> list) {
        this.list = new ArrayList<Parameter>(list);
        this.iteration = iteration;
    }

    public ParameterList(List<Parameter> list) {
        this.list = new ArrayList<Parameter>(list);
        this.iteration = list.size() + 1;
    }

    public ParameterList(String[] array) {
        ArrayList<Parameter> list = new ArrayList<Parameter>(array.length);
        int loop = 0;
        for (String s : array) {
            list.add(new Parameter(loop, s));
            ++loop;
        }
        this.setList(list);
    }

    public ParameterList(String[] cols, List<Parameter> parameterList) {
        this(cols);
        for (Parameter param : parameterList) {
            this.list.add(param);
        }
        this.iteration = this.list.size() + 1;
    }

    public void addParameter(Parameter param) {
        this.list.add(param);
        this.iteration = this.list.size() + 1;
    }

    public void updateCalculated(ActionTestScript ts) {
        this.list.forEach(p -> p.updateCalculated(ts));
    }

    public void getJavaCode(StringBuilder codeBuilder) {
        StringJoiner joiner = new StringJoiner(", ");
        for (Parameter param : this.list) {
            joiner.add(param.getJavaCode());
        }
        codeBuilder.append(", ").append("prm").append("(").append(joiner.toString()).append(")");
    }

    public String getParameterValue(String name, String defaultValue) {
        for (Parameter item : this.list) {
            if (!name.equals(item.getName())) continue;
            return item.getCalculated();
        }
        if (this.webElement != null) {
            String attribute = null;
            attribute = this.webElement.getAttribute(name);
            if (attribute != null) {
                return attribute;
            }
        }
        return defaultValue;
    }

    public String getParameterValue(int index, String defaultValue) {
        if (this.list.size() > index) {
            return this.list.get(index).getCalculated();
        }
        return defaultValue;
    }

    public String[] getParameters() {
        String[] result = new String[this.list.size()];
        int loop = 0;
        for (Parameter item : this.list) {
            result[loop] = item.getValue().getCalculated();
            ++loop;
        }
        return result;
    }

    public int getParametersSize() {
        if (this.list != null) {
            return this.list.size();
        }
        return 0;
    }

    public Map<String, String> getMap() {
        return this.list.stream().collect(Collectors.toMap(e -> e.getName(), e -> e.getCalculated()));
    }

    public int getIteration() {
        return this.iteration;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public List<Parameter> getList() {
        return this.list;
    }

    public void setList(ArrayList<Parameter> list) {
        this.list = list;
        this.iteration = list.size() + 1;
    }
}

