/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.transform;

import com.ats.generator.variables.transform.DateTransformer;
import com.ats.generator.variables.transform.NumericTransformer;
import com.ats.generator.variables.transform.RegexpTransformer;
import com.ats.generator.variables.transform.TableTransformer;
import com.ats.generator.variables.transform.TimeTransformer;
import com.ats.tools.Utils;
import java.util.regex.Pattern;

public class Transformer {
    public static final String REGEXP = "regexp";
    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String NUMERIC = "numeric";
    public static final String TABLE = "table";
    public static final Pattern TRANSFORM_PATTERN = Pattern.compile("(regexp|date|time|numeric|table) ?\\[(.*)\\]");

    protected int getInt(String value) {
        return Utils.string2Int(value);
    }

    public static Transformer createTransformer(String type, String data) {
        switch (type) {
            case "regexp": {
                return new RegexpTransformer(data);
            }
            case "date": {
                return new DateTransformer(data.split(","));
            }
            case "time": {
                return new TimeTransformer(data.split(","));
            }
            case "numeric": {
                return new NumericTransformer(data);
            }
            case "table": {
                return new TableTransformer(data.split(","));
            }
        }
        return null;
    }

    public String getJavaCode() {
        return "";
    }

    public String format(String data) {
        return "";
    }
}

