/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ShadowScript {
    private ScriptHeader header;
    private String suiteName;
    private List<Action> actions;
    private String errorText;
    private int errorLine = 0;

    public ShadowScript() {
        this.actions = new ArrayList<Action>();
    }

    public ShadowScript(ScriptHeader header, String suiteName) {
        this.header = header;
        this.suiteName = suiteName;
        this.actions = new ArrayList<Action>();
    }

    public void addAction(Action action, long timeLine) {
        if (this.actions.indexOf(action) == -1) {
            action.setTimeline(timeLine);
            this.actions.add(action);
        }
    }

    public void setError(Action action, long timeLine, int line, String errorText) {
        this.errorText = errorText;
        this.errorLine = line;
        this.addAction(action, timeLine);
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public Element getScriptXmlResult(String summaryText) {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        Element atsRoot = null;
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            atsRoot = document.createElement("ats");
            document.appendChild(atsRoot);
            Element scriptElem = document.createElement("script");
            atsRoot.appendChild(scriptElem);
            scriptElem.setAttribute("testId", this.header.getId());
            scriptElem.setAttribute("testName", this.header.getQualifiedName());
            scriptElem.setAttribute("externalId", this.header.getExternalId());
            scriptElem.setAttribute("cpuSpeed", "");
            scriptElem.setAttribute("cpuCount", "");
            scriptElem.setAttribute("totalMemory", "");
            scriptElem.setAttribute("osInfo", "");
            Element description = document.createElement("description");
            description.setTextContent(this.header.getDescription());
            scriptElem.appendChild(description);
            Element author = document.createElement("author");
            author.setTextContent(this.header.getAuthor());
            scriptElem.appendChild(author);
            Element prerequisite = document.createElement("prerequisite");
            prerequisite.setTextContent(this.header.getPrerequisite());
            scriptElem.appendChild(prerequisite);
            long t = System.currentTimeMillis();
            Element started = document.createElement("started");
            started.setTextContent(String.valueOf(t));
            scriptElem.appendChild(started);
            Element startedFormated = document.createElement("startedFormated");
            startedFormated.setTextContent(OffsetDateTime.ofInstant(Instant.ofEpochMilli(t), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd 'at' HH:mm:ss")));
            scriptElem.appendChild(startedFormated);
            Element quality = document.createElement("quality");
            quality.setTextContent("");
            scriptElem.appendChild(quality);
            Element groups = document.createElement("groups");
            for (String gr : this.header.getGroups()) {
                Element group = document.createElement("group");
                group.setTextContent(gr);
                groups.appendChild(group);
            }
            scriptElem.appendChild(groups);
            Element project = document.createElement("project");
            Element projectId = document.createElement("id");
            projectId.setTextContent(this.header.getProjectUuid());
            project.appendChild(projectId);
            Element projectName = document.createElement("name");
            projectName.setTextContent(this.header.getProjectId());
            project.appendChild(projectName);
            scriptElem.appendChild(project);
            Element actionsList = document.createElement("actions");
            atsRoot.appendChild(actionsList);
            int index = 0;
            for (Action action : this.actions) {
                actionsList.appendChild(action.getXmlElement(document, this.header, index, this.errorText));
                if (!action.isPassed()) {
                    this.errorText = action.getStatus().getFailMessage();
                    this.errorLine = action.getLine();
                }
                ++index;
            }
            Element summaryElement = document.createElement("summary");
            summaryElement.setAttribute("actions", String.valueOf(this.actions.size()));
            summaryElement.setAttribute("suiteName", this.suiteName);
            summaryElement.setAttribute("testName", this.header.getQualifiedName());
            if (summaryText.length() > 0) {
                Element data = document.createElement("data");
                data.setTextContent(summaryText);
                summaryElement.appendChild(data);
            }
            if (this.errorText == null) {
                summaryElement.setAttribute("status", "1");
            } else {
                summaryElement.setAttribute("status", "0");
                Element error = document.createElement("error");
                error.setAttribute("line", String.valueOf(this.errorLine));
                error.setAttribute("script", this.header.getQualifiedName());
                error.setTextContent(this.errorText);
                summaryElement.appendChild(error);
            }
            scriptElem.appendChild(summaryElement);
        }
        catch (ParserConfigurationException e) {
            return ShadowScript.getEmptyResultXml(this.header.getQualifiedName());
        }
        return atsRoot;
    }

    private static Element getEmptyResultXml(String scriptName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Element atsRoot = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            atsRoot = document.createElement("ats");
            document.appendChild(atsRoot);
            Element script = document.createElement("script");
            atsRoot.appendChild(script);
            script.setAttribute("testId", "");
            script.setAttribute("testName", scriptName);
            script.setAttribute("cpuSpeed", "");
            script.setAttribute("cpuCount", "");
            script.setAttribute("totalMemory", "");
            script.setAttribute("osInfo", "");
            Element description = document.createElement("description");
            description.setTextContent("This script is empty");
            script.appendChild(description);
            Element author = document.createElement("author");
            author.setTextContent("");
            script.appendChild(author);
            Element prerequisite = document.createElement("prerequisite");
            prerequisite.setTextContent("");
            script.appendChild(prerequisite);
            long start = System.currentTimeMillis();
            Element started = document.createElement("started");
            started.setTextContent(String.valueOf(start));
            script.appendChild(started);
            Element startedFormated = document.createElement("startedFormated");
            startedFormated.setTextContent(OffsetDateTime.ofInstant(Instant.ofEpochMilli(start), ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd 'at' HH:mm:ss")));
            script.appendChild(startedFormated);
            Element groups = document.createElement("groups");
            groups.setTextContent("");
            script.appendChild(groups);
            Element quality = document.createElement("quality");
            quality.setTextContent("");
            script.appendChild(quality);
            Element summary = document.createElement("summary");
            summary.setAttribute("actions", "0");
            summary.setAttribute("status", "0");
            summary.setAttribute("suiteName", "N/A");
            summary.setAttribute("testName", scriptName);
            Element error = document.createElement("error");
            error.setAttribute("line", "0");
            error.setAttribute("script", scriptName);
            error.setTextContent("Unknown error");
            summary.appendChild(error);
            script.appendChild(summary);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return atsRoot;
    }
}

