/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.ats.executor.ScriptStatus;
import com.ats.executor.drivers.IDriverInfo;
import com.ats.recorder.IVisualData;
import com.ats.recorder.RecorderSummaryData;
import com.ats.recorder.TestError;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.report.analytics.ActionsDuration;
import com.ats.tools.report.analytics.ActionsType;
import java.nio.file.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TestSummary
implements IVisualData {
    public static final String EMPTY_VALUE = "[empty]";
    private int status = 1;
    private String summary = "";
    private String suiteName = "";
    private String testName = "";
    private int actions = 0;
    private TestError error;

    public void appendData(String value) {
        this.summary = this.summary + value + "<br>";
    }

    public void setFailData(String script, int line, String message) {
        this.status = 0;
        if (this.error == null) {
            this.error = new TestError(script, line, message);
        }
    }

    @Override
    public Element getAction(ExecutionLogger logger, Element script, String summary, Document document, Path xmlFolderPath, ActionsDuration durationChart, ActionsType typeChart, boolean savePic, boolean addCharts) {
        this.summary = this.summary + summary;
        Element summaryElement = document.createElement("summary");
        summaryElement.setAttribute("actions", String.valueOf(this.getActions()));
        summaryElement.setAttribute("suiteName", this.getSuiteName());
        summaryElement.setAttribute("testName", this.getTestName());
        summaryElement.setAttribute("duration", String.valueOf(durationChart.getTotal()));
        summaryElement.setAttribute("status", String.valueOf(this.getStatus()));
        Element data = document.createElement("data");
        if (!EMPTY_VALUE.equals(this.getSummary())) {
            data.setTextContent(this.getSummary());
        }
        summaryElement.appendChild(data);
        if (this.getStatus() == 0 && this.getError() != null) {
            Element error = document.createElement("error");
            TestError scriptError = this.getError();
            error.setAttribute("script", scriptError.getScript());
            error.setAttribute("line", String.valueOf(scriptError.getLine()));
            error.setTextContent(scriptError.getMessage());
            summaryElement.appendChild(error);
        }
        script.appendChild(summaryElement);
        if (addCharts) {
            Element duration = document.createElement("duration");
            duration.setTextContent(durationChart.getBase64Chart());
            Element actionsType = document.createElement("actionsType");
            actionsType.setTextContent(typeChart.getBase64Chart());
            Element charts = document.createElement("charts");
            charts.appendChild(duration);
            charts.appendChild(actionsType);
            Element analytics = document.createElement("analytics");
            analytics.appendChild(charts);
            script.appendChild(analytics);
        }
        return null;
    }

    public RecorderSummaryData getRecordSummary(ScriptStatus st, IDriverInfo iDriverInfo) {
        RecorderSummaryData recordSummary = new RecorderSummaryData(st);
        if (this.summary == null || this.summary.isEmpty()) {
            this.summary = "";
        }
        recordSummary.setData(this.summary);
        recordSummary.setStatus(this.status);
        recordSummary.setError(this.error);
        recordSummary.setDriverInfo(iDriverInfo);
        return recordSummary;
    }

    @Override
    public Long getTimeLine() {
        return Long.MAX_VALUE;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = value;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String value) {
        if (value == null) {
            value = "";
        }
        this.summary = value;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName.replaceFirst("suite::", "");
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName.replaceFirst("script::", "");
    }

    public int getActions() {
        return this.actions;
    }

    public void setActions(int actions) {
        this.actions = actions;
    }

    public TestError getError() {
        return this.error;
    }

    public void setError(TestError error) {
        this.error = error;
    }
}

