/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script;

import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.SystemValues;
import com.ats.generator.ATS;
import com.ats.generator.objects.Cartesian;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.generator.variables.ConditionalValue;
import com.ats.script.Project;
import com.ats.script.actions.Action;
import com.ats.script.actions.neoload.ActionNeoload;
import com.ats.script.actions.performance.ActionPerformance;
import com.ats.script.actions.performance.octoperf.ActionOctoperfVirtualUser;
import com.ats.tools.Operators;
import com.ats.tools.Utils;
import java.io.File;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.openqa.selenium.Keys;
import org.testng.annotations.Test;

public class ScriptHeader {
    private static final String NAME = "name";
    private static final String PROJECT_ID = "project-id";
    public static final String ID = "id";
    public static final String UUID = "uuid";
    public static final String EXTERNAL_ID = "external";
    public static final String GROUPS = "groups";
    public static final String DESCRIPTION = "description";
    public static final String DATE_CREATED = "created";
    public static final String RETURN = "return";
    public static final String AUTHOR = "author";
    public static final String PREREQUISITE = "prerequisite";
    public static final int ID_LENGTH = "id".length();
    public static final int UUID_LENGTH = "uuid".length();
    public static final int GROUPS_LENGTH = "groups".length();
    public static final int DESCRIPTION_LENGTH = "description".length();
    public static final int DATE_CREATED_LENGTH = "created".length();
    public static final int RETURN_LENGTH = "return".length();
    public static final int EXTERNAL_ID_LENGTH = "external".length();
    public static final int AUTHOR_LENGTH = "author".length();
    public static final int PREREQUISITE_LENGTH = "prerequisite".length();
    private File testReportFolder;
    private File javaDestinationFolder;
    private File javaFile;
    private String path = "";
    private String projectPath = "";
    private String packageName = "";
    private String name = "";
    private String id = "";
    private String uuid = "";
    private String externalId = "";
    private List<String> groups = List.of();
    private String description = "";
    private String author = "";
    private String prerequisite = "";
    private Date createdAt = new Date();
    private String projectId = "";
    private String projectUuid = "";
    private String logsType = "";
    private String error = null;
    private static final String javaCode = String.join((CharSequence)System.getProperty("line.separator"), "", "//---------------------------------------------------------------------------------------", "//\t    _  _____ ____     ____                           _             ", "//\t   / \\|_   _/ ___|   / ___| ___ _ __   ___ _ __ __ _| |_ ___  _ __ ", "//\t  / _ \\ | | \\___ \\  | |  _ / _ \\ '_ \\ / _ \\ '__/ _` | __/ _ \\| '__|", "//\t / ___ \\| |  ___) | | |_| |  __/ | | |  __/ | | (_| | || (_) | |   ", "//\t/_/   \\_\\_| |____/   \\____|\\___|_| |_|\\___|_|  \\__,_|\\__\\___/|_|   ", "//", "//---------------------------------------------------------------------------------------", "//\t/!\\ Warning /!\\", "//\tThis class was automatically generated by ATS Script Generator (ver. #ATS_VERSION#)", "//\tYou may lose modifications if you edit this file manually !", "//---------------------------------------------------------------------------------------", "", "import " + ScriptHeader.class.getPackageName() + ".*;", "import " + Action.class.getPackageName() + ".*;", "import " + ActionNeoload.class.getPackageName() + ".*;", "import " + ActionPerformance.class.getPackageName() + ".*;", "import " + ActionOctoperfVirtualUser.class.getPackageName() + ".*;", "import " + ActionTestScript.class.getName() + ";", "import " + Cartesian.class.getName() + ";", "import " + Mouse.class.getName() + ";", "import " + ConditionalValue.class.getName() + ";", "import " + Operators.class.getName() + ";", "import " + Keys.class.getName() + ";", "", "public class #CLASS_NAME# extends " + ActionTestScript.class.getSimpleName() + "{", "", "\t/**", "\t* Test Name : <b>#TEST_NAME#</b>", "\t* Generated at : <b>" + DateFormat.getDateTimeInstance().format(new Date()) + "</b>", "\t* Script created at : #CREATED_AT#", "\t* #DESCRIPTION#", "\t* @author\t#AUTHOR_NAME#", "\t*/", "", "\t// -----------------[ ATS script info ]----------------- //", "", "\tpublic static final java.lang.String ATS_TEST_ID = \"#TEST_ID#\";", "\tpublic static final java.lang.String ATS_TEST_NAME = \"#TEST_NAME#\";", "\tpublic static final java.lang.String ATS_AUTHOR_NAME = \"#AUTHOR_NAME#\";", "\tpublic static final java.lang.String ATS_DESCRIPTION = \"#DESCRIPTION#\";", "\tpublic static final java.lang.String ATS_PREREQUISITES = \"#PREREQUISITES#\";", "\tpublic static final java.lang.String ATS_EXTERNAL_ID = \"#EXTERNAL_ID#\";", "\tpublic static final java.lang.String ATS_GROUPS = \"#GROUP_DESCRIPTION#\";", "\tpublic static final java.lang.String ATS_PROJECT_ID = \"#PROJECT_ID#\";", "\tpublic static final java.lang.String ATS_PROJECT_UUID = \"#PROJECT_UUID#\";", "\tpublic static final java.lang.String ATS_LOGS_TYPE = \"#PROJECT_LOGS_TYPE#\";", "", "\t// -----------------[ Constructors ]----------------- //", "", "\tpublic #CLASS_NAME#(){super();}", "\tpublic #CLASS_NAME#(" + ActionTestScript.class.getName() + " sc){super(sc);}", "", "\t// -----------------[ Overrides ]----------------- //", "", "\t@java.lang.Override", "\tprotected " + ScriptHeader.class.getSimpleName() + " getScriptHeader(){return new ScriptHeader(ATS_PROJECT_UUID, ATS_PROJECT_ID, ATS_TEST_NAME, ATS_TEST_ID, ATS_AUTHOR_NAME, ATS_DESCRIPTION, ATS_PREREQUISITES, ATS_EXTERNAL_ID, ATS_GROUPS, ATS_LOGS_TYPE);}", "", "\t// -----------------[ Test ]----------------- //", "", "\tpublic void testMain(){", "\t\tTc#CLASS_NAME#();", "\t}", "", "\t@" + Test.class.getName() + "#TEST_ANNOTATION#", "\tpublic void Tc#CLASS_NAME#(){");

    public ScriptHeader() {
    }

    public ScriptHeader(String projectUuid, String projectId, String testName, String id, String author, String description, String prerequisites, String externalId, String groups, String logsType) {
        this.projectUuid = projectUuid;
        this.projectId = projectId;
        this.name = testName;
        this.id = id;
        this.author = author;
        this.description = description;
        this.prerequisite = prerequisites;
        this.externalId = externalId;
        this.groups = Arrays.asList(groups.split(","));
        this.logsType = logsType;
    }

    public ScriptHeader(Project prj, File file) {
        this.setProjectPath(prj.getFolderPath());
        this.setPath(file.getAbsolutePath());
        this.setName(Utils.removeExtension(file.getName()));
        try {
            Path relative = prj.getAtsSourceFolder().relativize(file.getParentFile().toPath());
            this.setPackageName(relative.toString().replace(File.separator, "."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.testReportFolder = prj.getReportFolder().toFile();
        this.javaFile = prj.getJavaFile(this.getPackagePath() + this.name + ".java");
        this.javaDestinationFolder = prj.getJavaDestinationFolder().toFile();
    }

    public ScriptHeader(Project prj) {
        this.projectPath = prj.getFolderPath();
        this.path = this.projectPath + "/AtsTemp-";
        this.name = "AtsTemp-";
        this.packageName = "";
    }

    public ScriptHeader(String name) {
        this.name = name;
        this.packageName = "";
    }

    public File getTestReportFolder(Path path) {
        return this.testReportFolder;
    }

    public File getReportFolder() {
        return this.testReportFolder;
    }

    public File getJavaDestinationFolder() {
        return this.javaDestinationFolder;
    }

    public File getJavaFile() {
        return this.javaFile;
    }

    public String getPackagePath() {
        Object path = this.packageName.replace(".", File.separator);
        if (((String)path).length() > 0) {
            path = (String)path + File.separator;
        }
        return path;
    }

    public void parseGroups(String data) {
        this.groups = Arrays.stream(data.split(",")).map(String::trim).filter(s -> s.length() > 0).collect(Collectors.toList());
    }

    public String getDataGroups() {
        if (this.groups != null) {
            return String.join((CharSequence)",", this.groups);
        }
        return "";
    }

    public String getGroupsList() {
        if (this.groups != null) {
            StringJoiner joiner = new StringJoiner(",");
            for (int i = 0; i < this.groups.size(); ++i) {
                if (this.groups.get(i).length() <= 0) continue;
                joiner.add(this.groups.get(i));
            }
            return joiner.toString();
        }
        return "";
    }

    public String getJoinedGroups() {
        if (this.groups != null) {
            StringJoiner joiner = new StringJoiner(", ");
            for (int i = 0; i < this.groups.size(); ++i) {
                if (this.groups.get(i).length() <= 0) continue;
                joiner.add("\"" + this.groups.get(i) + "\"");
            }
            return joiner.toString();
        }
        return "";
    }

    private String getTestAnnotation() {
        StringBuilder annotation = new StringBuilder();
        String groups = this.getJoinedGroups();
        if (groups.length() > 0) {
            annotation.append("groups={").append(groups).append("}");
        }
        if (this.description != null && this.description.length() > 0) {
            if (annotation.length() > 0) {
                annotation.append(",");
            }
            annotation.append("description=\"");
            annotation.append(StringEscapeUtils.escapeJava((String)Utils.leftString(this.description, 20)));
            annotation.append("\"");
        }
        if (annotation.length() > 0) {
            annotation.insert(0, "(").append(")");
            return annotation.toString();
        }
        return "";
    }

    public String getQualifiedName() {
        if (this.packageName.length() > 0) {
            return this.packageName + "." + this.name;
        }
        return this.name;
    }

    public String getJavaCode(Project project) {
        String code = javaCode.replace("#CLASS_NAME#", this.name).replace("#TEST_NAME#", this.getQualifiedName()).replace("#TEST_ID#", StringEscapeUtils.escapeJava((String)this.id)).replace("#DESCRIPTION#", StringEscapeUtils.escapeJava((String)this.description)).replace("#PREREQUISITES#", StringEscapeUtils.escapeJava((String)this.prerequisite)).replace("#AUTHOR_NAME#", StringEscapeUtils.escapeJava((String)this.author)).replace("#EXTERNAL_ID#", StringEscapeUtils.escapeJava((String)this.externalId)).replace("#TEST_ANNOTATION#", this.getTestAnnotation()).replace("#GROUP_DESCRIPTION#", this.getDataGroups()).replace("#ATS_VERSION#", ATS.getAtsVersion()).replace("#CREATED_AT#", DateFormat.getDateTimeInstance().format(this.createdAt)).replace("#PROJECT_UUID#", StringEscapeUtils.escapeJava((String)project.getUuid())).replace("#PROJECT_LOGS_TYPE#", StringEscapeUtils.escapeJava((String)project.getLogsType())).replace("#PROJECT_ID#", StringEscapeUtils.escapeJava((String)project.getGav()));
        if (this.packageName.length() > 0) {
            return "package " + this.packageName + ";\r\n" + code;
        }
        return code;
    }

    public Object[] getData(int quality, long started) {
        Object[] result = new Object[]{this.getId(), this.getQualifiedName(), this.getDescription(), this.getAuthor(), this.getGroupsList(), this.getPrerequisite(), this.getExternalId(), quality, started};
        return result;
    }

    public Map<String, Object> getJsonData(int quality, long started) {
        HashMap<String, Object> valueNode = new HashMap<String, Object>();
        valueNode.put(ID, this.getId());
        valueNode.put("fullName", this.getQualifiedName());
        valueNode.put(DESCRIPTION, this.getDescription());
        valueNode.put(AUTHOR, this.getAuthor());
        valueNode.put(GROUPS, this.getGroupsList());
        valueNode.put("preRequisites", this.getPrerequisite());
        valueNode.put("externalId", this.getExternalId());
        valueNode.put("videoQuality", quality);
        valueNode.put("started", Long.toString(started));
        return valueNode;
    }

    public void setSystemProperties(String value) {
    }

    public String getSystemProperties() {
        return String.join((CharSequence)",", SystemValues.VALUES_NAME);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public String getData(String key) {
        switch (key) {
            case "description": {
                return this.getDescription();
            }
            case "name": {
                return this.getName();
            }
            case "external": {
                return this.getExternalId();
            }
            case "prerequisite": {
                return this.getPrerequisite();
            }
            case "id": {
                return this.getId();
            }
            case "groups": {
                return this.getGroupsList();
            }
            case "author": {
                return this.getAuthor();
            }
            case "project-id": {
                return this.getProjectId();
            }
        }
        return "";
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> value) {
        this.groups = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String value) {
        this.author = value;
    }

    public String getPrerequisite() {
        return this.prerequisite;
    }

    public void setPrerequisite(String value) {
        this.prerequisite = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String value) {
        this.externalId = value;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String value) {
        this.packageName = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getProjectPath() {
        return this.projectPath;
    }

    public void setProjectPath(String value) {
        this.projectPath = value;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String value) {
        this.uuid = value;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getLogsType() {
        return this.logsType;
    }

    public void setLogsType(String logsType) {
        this.logsType = logsType;
    }
}

