/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionExecuteElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;

public class ActionAssertProperty
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "check-property";
    private CalculatedProperty value;
    private String attributeValue;

    public ActionAssertProperty() {
    }

    public ActionAssertProperty(ScriptLoader script, int stopPolicy, ArrayList<String> options, String data, ArrayList<String> objectArray) {
        super((Script)script, stopPolicy, options, objectArray);
        this.setValue(new CalculatedProperty(script, data));
    }

    public ActionAssertProperty(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedProperty property) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setValue(property);
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append(", ").append(this.value.getJavaCode()).append(")");
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.addAll(this.value.getKeywords());
        if (this.attributeValue != null) {
            keywords.add(this.attributeValue);
        }
        return keywords;
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            this.getTestElement().updateScreen();
            int checkValue = this.checkProperty(this.value.getName());
            for (int maxCheckTry = this.getActionMaxTry(); checkValue < 0 && maxCheckTry > 0; --maxCheckTry) {
                this.getCurrentChannel().sendWarningLog("Assert property", maxCheckTry + " try");
                this.getCurrentChannel().progressiveWait(this.getActionMaxTry() - maxCheckTry);
                checkValue = this.checkProperty(this.value.getName());
            }
            this.status.endDuration();
            if (checkValue == -5) {
                ts.getRecorder().update(-5, this.status.getDuration(), this.value.getName());
            } else {
                this.status.setCode(checkValue);
                ts.getRecorder().update(this.status.getCode(), this.status.getDuration(), this.value.getExpectedResult(), this.attributeValue);
            }
        }
    }

    private int checkProperty(String name) {
        this.attributeValue = this.getTestElement().getAttribute(this.status, name);
        if (this.attributeValue == null) {
            this.status.setError(-5, "attribute '" + name + "' not found", this.value.getName());
            return -5;
        }
        return this.value.checkProperty(this.status, this.attributeValue);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("property", this.value.getName());
        data.addProperty("value", this.attributeValue);
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedProperty getValue() {
        return this.value;
    }

    public void setValue(CalculatedProperty value) {
        this.value = value;
    }
}

