/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.AtsSingleton;
import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.Action;
import com.ats.script.actions.IActionStoppable;
import java.util.ArrayList;

public class ActionButton
extends Action
implements IActionStoppable {
    public static final String SCRIPT_LABEL = "button";
    private String buttonType = "home";

    public ActionButton() {
    }

    public ActionButton(Script script, String buttonType) {
        super(script);
        this.setButtonType(buttonType);
    }

    public ActionButton(ScriptLoader script, ArrayList<String> dataArray) {
        String[] data = dataArray.get(0).split("=");
        if (data.length == 2) {
            this.setButtonType(data[1].replace("]", "").trim());
        }
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        if (AtsSingleton.getInstance().getCurrentChannel() != null) {
            AtsSingleton.getInstance().getCurrentChannel().buttonClick(this.status, this.getButtonType());
        }
        this.status.endAction();
        ts.getRecorder().update(this.status.getCode(), this.status.getDuration(), this.getButtonType());
    }

    @Override
    public StringBuilder getJavaCode() {
        return super.getJavaCode().append("\"").append(this.buttonType).append("\")");
    }

    @Override
    public boolean isStop() {
        return true;
    }

    public String getButtonType() {
        return this.buttonType;
    }

    public void setButtonType(String value) {
        this.buttonType = value;
    }
}

