/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.AtsSingleton;
import com.ats.data.Rectangle;
import com.ats.driver.AtsManager;
import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.element.test.TestElementDialog;
import com.ats.element.test.TestElementImage;
import com.ats.element.test.TestElementRecord;
import com.ats.element.test.TestElementRoot;
import com.ats.element.test.TestElementSap;
import com.ats.element.test.TestElementSystem;
import com.ats.executor.ActionTestScript;
import com.ats.script.Script;
import com.ats.script.actions.ActionExecuteElementAbstract;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriverException;

public class ActionExecuteElement
extends ActionExecuteElementAbstract {
    private static final String ELEMENT_NOT_FOUND_MESSAGE = "Element not found, wait and try again";
    private SearchedElement searchElement;
    protected TestElement testElement;
    private boolean async;
    private int actionMaxTry;

    public ActionExecuteElement() {
    }

    public ActionExecuteElement(Script script, int stopPolicy, ArrayList<String> options, ArrayList<String> element) {
        super(script, stopPolicy, options);
        if (element != null && element.size() > 0) {
            this.setSearchElement(new SearchedElement(script, element));
        }
    }

    public ActionExecuteElement(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element) {
        super(script, stopPolicy, maxTry, delay);
        this.setSearchElement(element);
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        if (this.searchElement == null) {
            codeBuilder.append("null");
        } else {
            codeBuilder.append(this.searchElement.getJavaCode());
        }
        return codeBuilder;
    }

    public void execute(ActionTestScript ts, String testName, int testLine) {
        this.execute(ts, testName, testLine, 0);
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        for (int maxTry = 0; maxTry < AtsManager.getMaxStaleOrJavaScriptError(); ++maxTry) {
            try {
                this.execute(ts, testName, testLine, ">", 0, maxTry + tryNum);
                return;
            }
            catch (JavascriptException e) {
                ts.getTopScript().getLogger().sendWarning("Javascript error", "try again : " + maxTry);
                this.status.setException(-13, (Exception)((Object)e));
            }
            catch (StaleElementReferenceException e) {
                ts.getTopScript().getLogger().sendWarning("StaleReference error", "try again : " + maxTry);
                this.status.setException(-16, (Exception)((Object)e));
            }
            AtsSingleton.getInstance().getCurrentChannel().sleep(500);
            this.setTestElement(null);
        }
        throw new WebDriverException("execute element error : " + this.status.getFailMessage());
    }

    public void execute(ActionTestScript ts, String testName, int testLine, String operator, int value, int tryNum) {
        super.execute(ts, testName, testLine, tryNum);
        if (this.status.isPassed()) {
            int delay = this.getDelay();
            if (delay > 0) {
                ts.getTopScript().getLogger().sendInfo("Delay before action", delay + "s");
                this.getCurrentChannel().sleep(delay * 1000);
            }
            this.actionMaxTry = AtsSingleton.getInstance().getMaxTry() + this.getMaxTry();
            if (this.actionMaxTry < 1) {
                this.actionMaxTry = 1;
            }
            if (this.testElement == null) {
                Predicate<Integer> predicate = this.getPredicate(operator, value);
                if (this.searchElement == null) {
                    this.setTestElement(new TestElementRoot(this.getCurrentChannel(), predicate));
                } else {
                    int trySearch = 0;
                    if (this.searchElement.isDialog()) {
                        while (trySearch < this.actionMaxTry) {
                            this.setTestElement(new TestElementDialog(this.getCurrentChannel(), this.actionMaxTry, this.searchElement, predicate));
                            if (this.testElement.isValidated()) {
                                trySearch = this.actionMaxTry;
                                continue;
                            }
                            this.getCurrentChannel().sendLog(50, ELEMENT_NOT_FOUND_MESSAGE, this.actionMaxTry - ++trySearch);
                            this.getCurrentChannel().progressiveWait(trySearch);
                        }
                    } else if (this.searchElement.isSysComp()) {
                        while (trySearch < this.actionMaxTry) {
                            this.setTestElement(new TestElementSystem(this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                            if (this.testElement.isValidated()) {
                                trySearch = this.actionMaxTry;
                                continue;
                            }
                            this.getCurrentChannel().sendLog(50, ELEMENT_NOT_FOUND_MESSAGE, this.actionMaxTry - ++trySearch);
                            this.getCurrentChannel().progressiveWait(trySearch);
                        }
                    } else {
                        SearchedElement parent = this.searchElement.getParent();
                        if (parent != null && parent.isScrollable()) {
                            TestElement parentElement = new TestElement(this.getCurrentChannel(), this.actionMaxTry, predicate, parent);
                            Rectangle parentRect = parentElement.getFoundElement().getRectangle();
                            int tryScrollSearch = 0;
                            int tryScrollSearchMax = AtsSingleton.getInstance().getMaxTryScroll();
                            while (tryScrollSearch < tryScrollSearchMax) {
                                if (tryScrollSearch > 0) {
                                    parentElement.swipe(-200);
                                    this.getCurrentChannel().sleep(2000);
                                }
                                if (this.searchElement.isImageSearch()) {
                                    this.setTestElement(new TestElementImage(this.getCurrentChannel(), 1, predicate, this.searchElement));
                                } else if (this.searchElement.isRecordSearch()) {
                                    this.setTestElement(new TestElementRecord(this.getCurrentChannel(), 1, predicate, this.searchElement));
                                } else if (this.getCurrentChannel().isSap()) {
                                    this.setTestElement(new TestElementSap(this.getCurrentChannel(), 1, predicate, this.searchElement));
                                } else {
                                    this.setTestElement(new TestElement(this.getCurrentChannel(), 1, predicate, this.searchElement));
                                }
                                if (this.testElement.isValidated() && parentRect.contains(this.testElement.getFoundElement().getRectangle())) {
                                    tryScrollSearch = tryScrollSearchMax;
                                    continue;
                                }
                                parentElement = new TestElement(this.getCurrentChannel(), this.actionMaxTry, predicate, parent);
                                ++tryScrollSearch;
                            }
                        } else {
                            while (trySearch < this.actionMaxTry) {
                                if (this.searchElement.isImageSearch()) {
                                    this.setTestElement(new TestElementImage(this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                                } else if (this.searchElement.isRecordSearch()) {
                                    this.setTestElement(new TestElementRecord(this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                                } else if (this.getCurrentChannel().isSap()) {
                                    this.setTestElement(new TestElementSap(this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                                } else {
                                    this.setTestElement(new TestElement(this.getCurrentChannel(), this.actionMaxTry, predicate, this.searchElement));
                                }
                                if (this.testElement.isValidated()) {
                                    trySearch = this.actionMaxTry;
                                    continue;
                                }
                                this.getCurrentChannel().sendLog(50, ELEMENT_NOT_FOUND_MESSAGE, this.actionMaxTry - ++trySearch);
                                this.getCurrentChannel().progressiveWait(trySearch);
                            }
                        }
                    }
                }
                this.status.setElement(this.testElement);
                this.status.setSearchDuration(this.testElement.getTotalSearchDuration());
                this.status.setData(this.testElement.getCount());
                AtsSingleton.getInstance().sleep(this.getDelay());
                this.asyncExec(ts);
            } else {
                this.terminateExecution(ts);
            }
        }
    }

    protected boolean getLoadAttributes() {
        if (this.searchElement != null) {
            return this.searchElement.getLoadAttributes();
        }
        return false;
    }

    private Predicate<Integer> getPredicate(String operator, int value) {
        switch (operator) {
            case "<>": {
                return p -> p != value;
            }
            case ">": {
                return p -> p > value;
            }
            case ">=": {
                return p -> p >= value;
            }
            case "<": {
                return p -> p < value;
            }
            case "<=": {
                return p -> p <= value;
            }
        }
        return p -> p == value;
    }

    private void asyncExec(ActionTestScript ts) {
        if (!this.async) {
            this.terminateExecution(ts);
        }
    }

    public void terminateExecution(ActionTestScript ts) {
        int error = 0;
        if (this.testElement.isValidated()) {
            this.status.setPassed(true);
        } else {
            this.status.setError(-1, this.testElement.getNotFoundDescription());
            error = -1;
        }
        this.terminateExecution(ts, error);
    }

    protected void terminateExecution(ActionTestScript ts, int error) {
        this.status.endDuration();
        this.testElement.terminateExecution(this.status, ts, error, this.status.getDuration());
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("searchDuration", (Number)this.status.getSearchDuration());
        data.addProperty("delay", (Number)this.getDelay());
        data.addProperty("occurrences", (Number)this.status.getElement().getCount());
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        if (this.searchElement != null) {
            keywords.addAll(this.searchElement.getKeywords());
        }
        return keywords;
    }

    public SearchedElement getSearchElement() {
        return this.searchElement;
    }

    public void setSearchElement(SearchedElement value) {
        this.searchElement = value;
    }

    public TestElement getTestElement() {
        return this.testElement;
    }

    private void setTestElement(TestElement element) {
        if (this.testElement != null) {
            this.testElement.dispose();
        }
        this.testElement = element;
    }

    public int getActionMaxTry() {
        return this.actionMaxTry;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean value) {
        this.async = value;
    }
}

