/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.generator.objects.mouse.Mouse;
import com.ats.generator.objects.mouse.MouseKey;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionMouse;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import org.openqa.selenium.Keys;

public class ActionMouseKey
extends ActionMouse {
    public static final String CTRL_KEY = "ctrl";
    public static final String SHIFT_KEY = "shift";
    public static final String ALT_KEY = "alt";
    private Keys key = null;

    public ActionMouseKey() {
    }

    public ActionMouseKey(ScriptLoader script, String type, int stopPolicy, ArrayList<String> options, ArrayList<String> objectArray) {
        super(script, type, stopPolicy, options, objectArray);
        Iterator<String> itr = options.iterator();
        while (itr.hasNext()) {
            this.setKey(itr.next().trim().toLowerCase());
        }
    }

    public ActionMouseKey(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, MouseKey mouse) {
        super(script, stopPolicy, maxTry, delay, element, mouse);
        this.key = mouse.getKey();
    }

    public ActionMouseKey(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, Mouse mouse) {
        super(script, stopPolicy, maxTry, delay, element, mouse);
    }

    @Override
    public StringBuilder getJavaCode() {
        if (Keys.CONTROL.equals((Object)this.key)) {
            this.setSpareCode(", Keys.CONTROL");
        } else if (Keys.SHIFT.equals((Object)this.key)) {
            this.setSpareCode(", Keys.SHIFT");
        } else if (Keys.ALT.equals((Object)this.key)) {
            this.setSpareCode(", Keys.ALT");
        } else {
            this.setSpareCode("");
        }
        return super.getJavaCode();
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            if ("click-wheel".equals(this.getType())) {
                this.getTestElement().wheelClick(this.status, this.getPosition());
            } else if ("click-right".equals(this.getType())) {
                this.getTestElement().rightClick();
            } else if ("click-double".equals(this.getType())) {
                this.getTestElement().doubleClick();
            } else if (this.key != null) {
                this.getTestElement().click(this.status, this.getPosition(), this.key);
            } else {
                this.getTestElement().click(this.status, this.getPosition());
            }
            this.status.endAction(ts.getRecorder());
        }
        this.getCurrentChannel().sleep(50);
        ts.getRecorder().updateScreen(false);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        if (this.key != null) {
            data.addProperty("key", this.key.toString());
        }
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public String getKey() {
        if (Keys.CONTROL.equals((Object)this.key)) {
            return CTRL_KEY;
        }
        if (Keys.SHIFT.equals((Object)this.key)) {
            return SHIFT_KEY;
        }
        if (Keys.ALT.equals((Object)this.key)) {
            return ALT_KEY;
        }
        return "";
    }

    public void setKey(String value) {
        this.key = CTRL_KEY.equals(value) ? Keys.CONTROL : (SHIFT_KEY.equals(value) ? Keys.SHIFT : (ALT_KEY.equals(value) ? Keys.ALT : null));
    }
}

