/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.actions.Action;
import java.util.ArrayList;

public class ActionPropertySet
extends Action {
    public static final String SCRIPT_LABEL = "property-set";
    private String name;
    private CalculatedValue value;

    public ActionPropertySet() {
    }

    public ActionPropertySet(Script script, String name, String value) {
        super(script);
        this.setName(name);
        this.setValue(new CalculatedValue(script, value));
    }

    public ActionPropertySet(Script script, String name, CalculatedValue value) {
        super(script);
        this.setName(name);
        this.setValue(value);
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int line, int tryNum) {
        super.execute(ts, testName, line, tryNum);
        if (this.isPassed()) {
            this.getCurrentChannel().setSysProperty(this.getName(), this.getValue().getCalculated());
            this.status.endAction();
            this.getCurrentChannel().sleep(50);
            ts.getRecorder().updateScreen(false);
            ts.getRecorder().update(this.status.getCode(), this.status.getDuration(), this.getName(), this.getValue().getCalculated());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CalculatedValue getValue() {
        return this.value;
    }

    public void setValue(CalculatedValue value) {
        this.value = value;
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder builder = super.getJavaCode();
        builder.append("\"").append(this.name).append("\"").append(", ").append(this.value.getJavaCode()).append(")");
        return builder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.name);
        keywords.add(this.value.getKeywords());
        return keywords;
    }
}

