/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.element.SearchedElement;
import com.ats.executor.ActionTestScript;
import com.ats.executor.SendTextException;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.ats.script.ScriptLoader;
import com.ats.script.actions.ActionExecuteElement;
import com.ats.tools.Utils;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;

public class ActionText
extends ActionExecuteElement {
    public static final String SCRIPT_LABEL = "keyboard";
    public static final String WAIT_CHAR = "waitchar";
    private CalculatedValue text;
    private int waitChar = 0;

    public ActionText() {
    }

    public ActionText(ScriptLoader script, int stopPolicy, ArrayList<String> options, String text, ArrayList<String> objectArray) {
        super((Script)script, stopPolicy, options, objectArray);
        this.setText(new CalculatedValue(script, text));
        Iterator<String> itr = options.iterator();
        while (itr.hasNext()) {
            String data = itr.next().toLowerCase();
            if (!data.contains(WAIT_CHAR)) continue;
            this.setWaitChar(Utils.string2Int(data.replace(WAIT_CHAR, "").replace("=", "")));
            break;
        }
    }

    public ActionText(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedValue text) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setText(text);
    }

    public ActionText(Script script, int stopPolicy, int maxTry, int delay, SearchedElement element, CalculatedValue text, int wait) {
        super(script, stopPolicy, maxTry, delay, element);
        this.setText(text);
        this.setWaitChar(wait);
    }

    @Override
    public StringBuilder getJavaCode() {
        if (this.waitChar > 0) {
            return super.getJavaCode().append(", ").append(this.text.getJavaCode()).append(", ").append(this.waitChar).append(")");
        }
        return super.getJavaCode().append(", ").append(this.text.getJavaCode()).append(")");
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.text.getKeywords());
        return keywords;
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int testLine, int tryNum) {
        for (int maxTry = 0; maxTry < 3; ++maxTry) {
            try {
                super.execute(ts, testName, testLine, tryNum + maxTry);
                return;
            }
            catch (SendTextException sendTextException) {
                continue;
            }
        }
        this.status.setError(-4, "send keys action fail on the element");
        this.terminateExecution(ts, -4);
    }

    @Override
    public void terminateExecution(ActionTestScript ts) {
        super.terminateExecution(ts);
        if (this.status.isPassed()) {
            String enteredText = this.getTestElement().enterText(this.status, this.text, ts, this.waitChar);
            this.status.endAction();
            ts.getRecorder().updateTextScreen(this.status, enteredText);
        }
        ts.getRecorder().updateScreen(false);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("text", this.text.getCalculated().replaceAll("\"", "\\\""));
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public CalculatedValue getText() {
        return this.text;
    }

    public void setText(CalculatedValue text) {
        this.text = text;
    }

    public int getWaitChar() {
        return this.waitChar;
    }

    public void setWaitChar(int value) {
        if (value > 5000) {
            value = 5000;
        }
        this.waitChar = value;
    }
}

