/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.logger.levels;

import com.ats.script.actions.Action;
import com.ats.tools.logger.NullPrintStream;
import com.ats.tools.logger.prefix.AzureDevOps;
import com.ats.tools.logger.prefix.ILogType;
import com.ats.tools.logger.prefix.Terminal;
import com.ats.tools.logger.prefix.TerminalColor;
import java.io.PrintStream;

public class AtsLogger {
    public static final String TYPE_TERM = "term";
    public static final String TYPE_AZD = "azd";
    protected ILogType logType = new TerminalColor();
    protected PrintStream out;

    public AtsLogger() {
        this.out = new NullPrintStream();
    }

    public AtsLogger(PrintStream out, String type, String level) {
        this.out = out;
        String logsTypeName = "";
        if (TYPE_TERM.equals(type)) {
            this.logType = new TerminalColor();
            logsTypeName = "[Terminal Color] ";
        } else if (TYPE_AZD.equals(type)) {
            this.logType = new AzureDevOps();
            logsTypeName = "[Azure DevOps] ";
        } else {
            this.logType = new Terminal();
        }
        out.println(this.logType.getLoggerData() + logsTypeName + "Logger level -> " + level);
    }

    public void suiteOutput(String value) {
        this.out.println(this.logType.getSuiteData() + value);
    }

    public static void printLog(String value) {
        System.out.println(value);
    }

    public void printFail(String actionName, String testName, int line, String info, String details) {
        this.out.println(this.logType.getFailData(actionName, testName, line, info, details));
    }

    public void printError(String info, String value) {
        this.out.println(this.logType.getErrorData() + info + " -> " + value);
    }

    public void printInfo(String value) {
        this.out.println(this.logType.getInfoData() + value);
    }

    public void printWarning(String value) {
        this.out.println(this.logType.getWarningData() + value);
    }

    public void printScript(String value) {
        this.out.println(this.logType.getScriptData(value) + value);
    }

    public void printAction(String value) {
        this.out.println(this.logType.getActionData() + value);
    }

    public void comment(String message) {
        this.out.println(this.logType.getCommentData(message));
    }

    public void driverLog(String value) {
        this.out.println(this.logType.getDriverLog() + value);
    }

    public void driverWarning(String value) {
        this.out.println(this.logType.getDriverWarning() + value);
    }

    public void driverError(String value) {
        this.out.println(this.logType.getDriverError() + value);
    }

    public void driverOutput(String value) {
    }

    public void warning(String message) {
    }

    public void info(String message) {
    }

    public void error(String info, String value) {
    }

    public void action(Action action, String testName, int line) {
    }
}

