/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.generator.ATS;
import com.ats.tools.ResourceContent;
import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.CampaignReportGenerator;
import com.ats.tools.report.MinifyWriter;
import com.ats.tools.report.SuitesReport;
import com.ats.tools.report.SuitesReportItem;
import com.ats.tools.report.XmlReport;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CampaignReportConcatenatorGenerator {
    public static String ATS_JSON_SUITES = "ats-suites.json";
    public static final String ATS_REPORT = "ats-report";
    public static final String MGT_REPORT = "mgt-report";
    public static final String VALID_REPORT = "validation-report";
    public static final String TEMPLATE_EXTENSION = "_html.xml";
    private static final String REPORT_FOLDER = "reports";
    private static final String TEMPLATE_FOLDER = "templates";
    private static final String IMAGE_FOLDER = "images";
    private static final String CUSTOM_TEMPLATES_FOLDER = "/reports/templates/";
    private static final String CUSTOM_IMAGES_FOLDER = "/reports/images/";
    private static final String XML_SOURCE_NAME = "ats-report.xml";
    private static final String XML_SOURCE_ROOT = "ats-report";
    private static String outputFolder = null;
    private static int atsReportLvl = 0;
    private static int managementReport = 0;
    private static int validationReport = 0;
    private static LinkedList<Path> inputFolders = null;
    private static DocumentBuilder builderTest;
    private static Document outputXmlDocument;
    private static Element concatRacineElement;
    private static final List<String> trueList;

    public static void main(String[] args) throws ParserConfigurationException, IOException, TransformerException, SAXException {
        String[] SInputFolders = null;
        block17: for (int i = 0; i < args.length; ++i) {
            String string = args[i];
            if (!string.startsWith("--") || i + 1 >= args.length) continue;
            switch (string.substring(2).toLowerCase()) {
                case "outputfolder": 
                case "output": 
                case "reportfolder": {
                    outputFolder = args[i + 1].replaceAll("\"", "");
                    continue block17;
                }
                case "details": 
                case "ats-report": {
                    atsReportLvl = Utils.string2Int(args[i + 1], 0);
                    continue block17;
                }
                case "validation-report": {
                    validationReport = trueList.indexOf(args[i + 1]) > -1 ? 1 : 0;
                    continue block17;
                }
                case "concat-report-folders": {
                    SInputFolders = args[i + 1].split(";");
                    continue block17;
                }
                default: {
                    System.out.println("unavailable parameter : " + string.substring(2).toLowerCase());
                }
            }
        }
        if (outputFolder == null) {
            System.out.println("Error, output folder not defined !");
            return;
        }
        Path outputFolderPath = Paths.get(outputFolder, new String[0]).toAbsolutePath();
        if (!outputFolderPath.toFile().exists()) {
            System.out.println("Error, output folder path not found : " + outputFolder);
            return;
        }
        if (SInputFolders != null) {
            CampaignReportConcatenatorGenerator.reportConcatenation(SInputFolders);
        } else {
            File jsonSuiteFilesFile = outputFolderPath.resolve(ATS_JSON_SUITES).toFile();
            if (jsonSuiteFilesFile.exists()) {
                try {
                    new CampaignReportGenerator(outputFolderPath, jsonSuiteFilesFile, atsReportLvl);
                }
                catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("Suites file not found  (" + ATS_JSON_SUITES + ") at : " + String.valueOf(outputFolderPath));
            }
        }
    }

    public static void initFolders(Path projectPath) {
        try {
            projectPath.resolve(REPORT_FOLDER).toFile().mkdirs();
            projectPath.resolve(REPORT_FOLDER).resolve(CUSTOM_TEMPLATES_FOLDER).toFile().mkdirs();
            projectPath.resolve(REPORT_FOLDER).resolve(CUSTOM_IMAGES_FOLDER).toFile().mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void copyReportsTemplate(Path fromPath, Path toPath) {
        if (Files.exists(fromPath, new LinkOption[0])) {
            for (File f : fromPath.toFile().listFiles()) {
                if (!f.isFile()) continue;
                try {
                    Files.copy(f.toPath(), toPath.resolve(f.getName()), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static void reportConcatenation(String[] SInputFolders) throws TransformerException, IOException, SAXException {
        if (SInputFolders.length > 0) {
            File f = null;
            inputFolders = new LinkedList();
            for (String sPath : SInputFolders) {
                f = new File(sPath);
                if (f.exists()) {
                    if (f.isDirectory()) {
                        inputFolders.add(Path.of(sPath, new String[0]));
                        continue;
                    }
                    System.out.println("Warning, inputFolder (" + sPath + ") is not a Folder, it will not used");
                    continue;
                }
                System.out.println("Warning, inputFolder (" + sPath + ") doesn't exist");
            }
            Path[] aInputFolders = inputFolders.toArray(new Path[inputFolders.size()]);
            if (aInputFolders.length > 0) {
                outputXmlDocument = builderTest.newDocument();
                concatRacineElement = outputXmlDocument.createElement("ats-report-concatenation");
                for (Path inputFolder : inputFolders) {
                    if (!inputFolder.toFile().exists()) continue;
                    File jsonSuiteFilesFile = inputFolder.resolve(ATS_JSON_SUITES).toFile();
                    if (jsonSuiteFilesFile.exists()) {
                        try {
                            concatRacineElement.appendChild(CampaignReportConcatenatorGenerator.ReportDataRecover(inputFolder, jsonSuiteFilesFile));
                        }
                        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    System.out.println("Suites file not found (" + ATS_JSON_SUITES + ") at : " + String.valueOf(inputFolder));
                }
                if (concatRacineElement != null) {
                    outputXmlDocument.appendChild(concatRacineElement);
                }
                Path outputFolderPath = Path.of(outputFolder, new String[0]);
                Path atsXmlDataPath = outputFolderPath.resolve(XML_SOURCE_NAME);
                CampaignReportConcatenatorGenerator.writeXMLDatafile(atsXmlDataPath, null);
                LinkedList<String> reports = CampaignReportConcatenatorGenerator.reportParametersSelection(Integer.toString(atsReportLvl), null, Integer.toString(validationReport), null);
                CampaignReportConcatenatorGenerator.htmlGeneration(outputFolderPath, atsXmlDataPath, reports);
            } else {
                System.out.println("No available folder found");
            }
        }
    }

    private static void htmlGeneration(Path outputFolderPath, Path atsXmlDataPath, LinkedList<String> reports) throws IOException, TransformerException, SAXException {
        if (outputFolderPath.toFile().isDirectory()) {
            if (atsXmlDataPath.toFile().exists()) {
                for (String reportFile : reports) {
                    File htmlTemplateFile = CampaignReportConcatenatorGenerator.copyResource(reportFile, outputFolderPath);
                    MinifyWriter filteredWriter = null;
                    Transformer htmlTransformer = null;
                    Path inputTemplate = null;
                    inputTemplate = "suites_html.xml".equals(reportFile) ? outputFolderPath.resolve("ats-report.html") : outputFolderPath.resolve(reportFile.substring(0, reportFile.indexOf("_")) + ".html");
                    filteredWriter = new MinifyWriter(Files.newBufferedWriter(inputTemplate, StandardCharsets.UTF_8, new OpenOption[0]));
                    htmlTransformer = TransformerFactory.newInstance().newTransformer(new StreamSource(htmlTemplateFile));
                    htmlTransformer.setOutputProperty("encoding", "UTF-8");
                    htmlTransformer.transform(new DOMSource(builderTest.parse(new InputSource(new InputStreamReader(Files.newInputStream(atsXmlDataPath, new OpenOption[0]), StandardCharsets.UTF_8)))), new StreamResult(filteredWriter));
                    filteredWriter.close();
                }
            } else {
                System.out.println("[ERROR] generation aborted : inputXmlDocument not defined!");
            }
        } else if (outputFolderPath.toFile().exists()) {
            System.out.println("[ERROR] generation aborted : inputXmlDocument not defined!");
        }
    }

    private static void writeXMLDatafile(Path XmlDataPath, Document DocumentToWrite) throws TransformerException, FileNotFoundException {
        Document DOMDocument;
        Document document = DOMDocument = DocumentToWrite != null ? DocumentToWrite : outputXmlDocument;
        if (DOMDocument != null) {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(DOMDocument), new StreamResult(new OutputStreamWriter((OutputStream)new FileOutputStream(XmlDataPath.toFile()), StandardCharsets.UTF_8)));
        } else {
            System.out.println("[ERROR] generation aborted : OutputDOMxmlDocument not defined!");
        }
    }

    private static Node ReportDataRecover(Path outputFolderPath, File jsonSuiteFilesFile) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        if (outputFolderPath.resolve(XML_SOURCE_NAME).toFile().exists()) {
            File XMLReportData = outputFolderPath.resolve(XML_SOURCE_NAME).toFile();
            Element reportData = builderTest.parse(XMLReportData).getDocumentElement();
            reportData.setAttribute("path", outputFolderPath.toString());
            reportData.setAttribute("devReportLevel", Integer.toString(atsReportLvl));
            reportData.setAttribute("mgtReportLevel", Integer.toString(managementReport));
            reportData.setAttribute("validReportLevel", Integer.toString(validationReport));
            return outputXmlDocument.importNode(reportData, true);
        }
        return CampaignReportConcatenatorGenerator.reportGenerator(outputFolderPath, jsonSuiteFilesFile);
    }

    public static Node reportGenerator(Path outputFolderPath, File jsonSuiteFilesFile) throws IOException, TransformerException, ParserConfigurationException, SAXException, DOMException {
        LinkedList<String> reports = new LinkedList<String>();
        Path reportPath = Paths.get("src", "assets", "resources", REPORT_FOLDER);
        if (Files.exists(reportPath, new LinkOption[0])) {
            CampaignReportConcatenatorGenerator.copyReportsTemplate(reportPath.resolve(TEMPLATE_FOLDER), outputFolderPath);
            CampaignReportConcatenatorGenerator.copyReportsTemplate(reportPath.resolve(IMAGE_FOLDER), outputFolderPath);
        }
        SuitesReport suiteReport = null;
        try {
            JsonReader reader = new JsonReader((Reader)new FileReader(jsonSuiteFilesFile));
            suiteReport = (SuitesReport)new Gson().fromJson(reader, SuitesReport.class);
            reader.close();
        }
        catch (IOException reader) {
            // empty catch block
        }
        if (suiteReport == null) {
            System.out.println("No suites found, nothing to do !");
            return null;
        }
        Document writeSuiteXMLElement = builderTest.newDocument();
        Element report = writeSuiteXMLElement.createElement("ats-report");
        report.setAttribute("atsVersion", ATS.getAtsVersion());
        report.setAttribute("projectId", suiteReport.projectId);
        report.setAttribute("projectUuid", suiteReport.projectUuid);
        report.setAttribute("projectDescription", suiteReport.projectDescription);
        report.setAttribute("path", outputFolderPath.toString());
        writeSuiteXMLElement.appendChild(report);
        CampaignReportConcatenatorGenerator.insertBasicPicture(outputFolderPath, writeSuiteXMLElement);
        report.appendChild(CampaignReportConcatenatorGenerator.insertBasicPicture(outputFolderPath, writeSuiteXMLElement));
        report.setAttribute("suitesCount", String.valueOf(suiteReport.suites.length));
        int totalTests = 0;
        int totalTestsPassed = 0;
        int totalSuitesPassed = 0;
        int totalActions = 0;
        int totalDuration = 0;
        for (SuitesReportItem info : suiteReport.suites) {
            Path suitePath = outputFolderPath.resolve(info.getName());
            boolean suitePassed = true;
            Element suite = writeSuiteXMLElement.createElement("suite");
            suite.setAttribute("name", info.getName());
            suite.setAttribute("description", info.getDescription());
            suite.setAttribute("dateOrder", info.getDateOrder());
            Element parameters = writeSuiteXMLElement.createElement("parameters");
            suite.appendChild(parameters);
            Properties properties = new Properties();
            Path suiteParamPath = suitePath.resolve("parameters.txt");
            reports = CampaignReportConcatenatorGenerator.reportParametersSelection(info.devReportLvl, info.mgtReportLvl, info.validReportLvl, report);
            if (Files.exists(suiteParamPath, new LinkOption[0])) {
                properties.load(Files.newBufferedReader(suiteParamPath));
            }
            for (Map.Entry<String, String> entry : info.getParametersEntries()) {
                Element parameter = writeSuiteXMLElement.createElement("parameter");
                parameter.setAttribute("name", entry.getKey());
                parameter.setAttribute("value", properties.getProperty(entry.getKey(), entry.getValue()));
                parameter.setAttribute("defaultValue", entry.getValue());
                parameters.appendChild(parameter);
            }
            Element tests = writeSuiteXMLElement.createElement("tests");
            suite.appendChild(tests);
            int testsPassed = 0;
            int testsFailed = 0;
            int actionsExecuted = 0;
            int suiteDuration = 0;
            suite.setAttribute("testsCount", String.valueOf(info.getTestsCount()));
            for (String scriptName : info.tests) {
                File xmlDataFile = suitePath.resolve(scriptName + "_xml").resolve(XmlReport.REPORT_FILE).toFile();
                if (!xmlDataFile.exists()) continue;
                ++totalTests;
                int testDuration = 0;
                Element atsTest = builderTest.parse(xmlDataFile).getDocumentElement();
                NodeList actionsList = atsTest.getElementsByTagName("action");
                NodeList summary = atsTest.getElementsByTagName("summary");
                if (summary.getLength() > 0) {
                    if ("1".equals(summary.item(0).getAttributes().getNamedItem("status").getNodeValue())) {
                        ++testsPassed;
                        ++totalTestsPassed;
                    } else {
                        ++testsFailed;
                        suitePassed = false;
                    }
                    actionsExecuted += Utils.string2Int(summary.item(0).getAttributes().getNamedItem("actions").getNodeValue(), actionsList.getLength());
                } else {
                    actionsExecuted += actionsList.getLength();
                }
                LinkedList<String> actionImagesList = new LinkedList<String>();
                for (int i = 0; i < actionsList.getLength(); ++i) {
                    Node action = actionsList.item(i);
                    Element eElement = (Element)action;
                    Node element = null;
                    element = eElement.getElementsByTagName("duration").item(0);
                    if (element != null) {
                        testDuration += Utils.string2Int(element.getTextContent());
                    }
                    element = null;
                    element = eElement.getElementsByTagName("img").item(0);
                    if (element == null) continue;
                    actionImagesList.add(element.getAttributes().getNamedItem("src").getNodeValue());
                }
                CampaignReportConcatenatorGenerator.extractReportPicture(actionImagesList, suitePath, scriptName);
                atsTest.setAttribute("duration", String.valueOf(testDuration));
                suiteDuration += testDuration;
                tests.appendChild(writeSuiteXMLElement.importNode(atsTest, true));
            }
            totalActions += actionsExecuted;
            totalDuration += suiteDuration;
            if (suitePassed) {
                ++totalSuitesPassed;
            }
            suite.setAttribute("passed", String.valueOf(suitePassed));
            suite.setAttribute("duration", String.valueOf(suiteDuration));
            suite.setAttribute("actions", String.valueOf(actionsExecuted));
            suite.setAttribute("testsPassed", String.valueOf(testsPassed));
            suite.setAttribute("testsFailed", String.valueOf(testsFailed));
            report.appendChild(suite);
        }
        report.setAttribute("duration", String.valueOf(totalDuration));
        report.setAttribute("tests", String.valueOf(totalTests));
        report.setAttribute("testsPassed", String.valueOf(totalTestsPassed));
        report.setAttribute("suitesPassed", String.valueOf(totalSuitesPassed));
        report.setAttribute("actions", String.valueOf(totalActions));
        Path atsXmlDataPath = outputFolderPath.resolve(XML_SOURCE_NAME);
        CampaignReportConcatenatorGenerator.writeXMLDatafile(atsXmlDataPath, writeSuiteXMLElement);
        CampaignReportConcatenatorGenerator.htmlGeneration(outputFolderPath, atsXmlDataPath, reports);
        CampaignReportConcatenatorGenerator.jasperGeneration(outputFolderPath);
        return outputXmlDocument.importNode(report, true);
    }

    private static Node insertBasicPicture(Path outputFolderPath, Document writeSuiteXMLElement) throws IOException {
        String[] defaultImages;
        Element picsList = writeSuiteXMLElement.createElement("pics");
        for (String img : defaultImages = new String[]{"logo.png", "true.png", "false.png", "warning.png", "noStop.png", "api.png", "pdf.png", "external_link_10_white", "external_link_12_blue", "external_link_12_blue_visited", "external_link_12_grey", "external_link_16_grey", "external_link_16_white", "run_16"}) {
            Element pic = writeSuiteXMLElement.createElement("pic");
            pic.setAttribute("name", img.replace(".png", ""));
            byte[] imgBytes = null;
            imgBytes = Files.exists(outputFolderPath.resolve(img), new LinkOption[0]) ? Files.readAllBytes(outputFolderPath.resolve(img)) : ResourceContent.class.getResourceAsStream(CUSTOM_IMAGES_FOLDER + img).readAllBytes();
            pic.setTextContent("data:image/png;base64," + CampaignReportConcatenatorGenerator.getBase64DefaultImages(imgBytes));
            picsList.appendChild(pic);
        }
        return picsList;
    }

    private static void extractReportPicture(LinkedList<String> actionImagesList, Path suitePath, String scriptName) throws ParserConfigurationException, TransformerException, IOException {
    }

    private static LinkedList<String> reportParametersSelection(String ATSReportFileSuite, String MGTReportFileSuite, String ValidReportFileSuite, Element report) {
        String SATSReport = System.getProperty("ats-report");
        String SMGTReport = System.getProperty(MGT_REPORT);
        String SVALIDReport = System.getProperty(VALID_REPORT);
        LinkedList<String> reports = new LinkedList<String>();
        int devReport = 0;
        int mgtReport = 0;
        int validReport = 0;
        devReport = atsReportLvl == 0 ? Utils.string2Int(SATSReport, Utils.string2Int(ATSReportFileSuite, atsReportLvl)) : atsReportLvl;
        mgtReport = SMGTReport != null && trueList.contains(SMGTReport.toLowerCase()) ? 1 : Utils.string2Int(MGTReportFileSuite, managementReport);
        validReport = SVALIDReport != null && trueList.contains(SVALIDReport.toLowerCase()) ? 1 : Utils.string2Int(ValidReportFileSuite, validationReport);
        String reportName = "suites_html.xml";
        if (devReport != 0 && !reports.contains(reportName)) {
            reports.add(reportName);
        }
        reportName = "mgt-report_html.xml";
        if (mgtReport != 0 && !reports.contains(reportName)) {
            reports.add(reportName);
        }
        reportName = "validation-report_html.xml";
        if (validReport != 0 && !reports.contains(reportName)) {
            reports.add(reportName);
        }
        if (report != null) {
            report.setAttribute("devReportLevel", Integer.toString(devReport));
            report.setAttribute("mgtReportLevel", Integer.toString(mgtReport));
            report.setAttribute("validReportLevel", Integer.toString(validReport));
        }
        return reports;
    }

    public static void jasperGeneration(Path outputFolderPath) throws ParserConfigurationException, IOException, TransformerException {
        File[] filesToDelete;
        CampaignReportConcatenatorGenerator.copyResource("summary.jrxml", outputFolderPath);
        CampaignReportConcatenatorGenerator.copyResource("suite.jrxml", outputFolderPath);
        CampaignReportConcatenatorGenerator.copyResource("test.jrxml", outputFolderPath);
        String outputPath = outputFolderPath.toAbsolutePath().toString();
        String reportName = "summary";
        for (File f : filesToDelete = outputFolderPath.toFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jrprint") || name.endsWith(".jasper") || name.equals("summary.pdf");
            }
        })) {
            try {
                f.delete();
                System.out.println("File : " + f.getAbsolutePath());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            CampaignReportConcatenatorGenerator.generatePdf("summary", outputPath);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private static void generatePdf(String reportName, String outputPath) throws JRException {
        outputPath = (String)outputPath + File.separator;
        String reportFullName = (String)outputPath + reportName + ".pdf";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("workingDir", outputPath);
        parameters.put("xmlSource", XML_SOURCE_NAME);
        parameters.put("xmlSourceRoot", "ats-report");
        AtsLogger.printLog("Generate reports templates ...");
        JasperCompileManager.compileReportToFile((String)((String)outputPath + "test.jrxml"), (String)((String)outputPath + "test.jasper"));
        JasperCompileManager.compileReportToFile((String)((String)outputPath + "suite.jrxml"), (String)((String)outputPath + "suite.jasper"));
        JasperCompileManager.compileReportToFile((String)((String)outputPath + "summary.jrxml"), (String)((String)outputPath + "summary.jasper"));
        String fileName = JasperFillManager.fillReportToFile((String)((String)outputPath + reportName + ".jasper"), parameters);
        JasperExportManager.exportReportToPdfFile((String)fileName, (String)reportFullName);
        AtsLogger.printLog("File -> " + reportFullName + " ... OK");
    }

    private static File copyResource(String resName, Path dest) throws IOException {
        Path filePath = dest.resolve(resName);
        if (!Files.exists(filePath, new LinkOption[0])) {
            int lengthRead;
            InputStream is = ResourceContent.class.getResourceAsStream(CUSTOM_TEMPLATES_FOLDER + resName);
            BufferedInputStream in = new BufferedInputStream(is);
            File targetFile = dest.resolve(resName).toFile();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
            byte[] buffer = new byte[1024];
            while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, lengthRead);
                ((OutputStream)out).flush();
            }
            ((InputStream)in).close();
            is.close();
            ((OutputStream)out).close();
        }
        return filePath.toFile();
    }

    private static String getBase64DefaultImages(byte[] b) throws IOException {
        return Base64.getEncoder().encodeToString(b);
    }

    static {
        try {
            builderTest = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        outputXmlDocument = null;
        concatRacineElement = null;
        trueList = Arrays.asList("on", "true", "1", "yes", "y");
    }
}

