/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.tools.report.SuitesReportItem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SuitesReport {
    public String projectId;
    public String projectUuid;
    public String projectName;
    public String projectVersion;
    public String projectDescription;
    public SuitesReportItem[] suites;
    public long started;
    private static final Pattern VERSION_REGEX = Pattern.compile("(.*)\\(([^)]+)\\)");

    public SuitesReport(SuitesReportItem suite) {
        Path projectProperties;
        this.suites = new SuitesReportItem[]{suite};
        this.projectId = suite.getProjectId();
        this.projectUuid = suite.getProjectUuid();
        this.started = suite.getStarted();
        Matcher m = VERSION_REGEX.matcher(this.projectId);
        if (m.find()) {
            this.projectName = m.group(1);
            this.projectVersion = m.group(2);
        }
        if (Files.exists(projectProperties = Paths.get(".atsProjectProperties", new String[0]), new LinkOption[0])) {
            try {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(projectProperties.toFile());
                Element root = doc.getDocumentElement();
                NodeList desc = root.getElementsByTagName("description");
                if (desc != null && desc.getLength() > 0) {
                    this.projectDescription = desc.item(0).getTextContent();
                }
            }
            catch (IOException | ParserConfigurationException | SAXException exception) {
                // empty catch block
            }
        }
    }

    public void add(SuitesReportItem suite) {
        this.suites = (SuitesReportItem[])Stream.concat(Arrays.stream(this.suites), Arrays.stream(new SuitesReportItem[]{suite})).toArray(SuitesReportItem[]::new);
    }
}

