/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.analytics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ActionsDuration {
    private static final Color LINE_COLOR = Color.decode("#699400");
    private static final Color GRID_COLOR = Color.decode("#5a6886");
    private DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
    private int index = 0;
    private int total = 0;

    public ActionsDuration() {
    }

    public ActionsDuration(List<Integer> data) {
        for (int l : data) {
            this.addDuration(l);
        }
    }

    public void addDuration(int value) {
        this.total += value;
        this.dataSet.addValue((double)value, (Comparable)((Object)"duration"), (Comparable)((Object)String.valueOf(this.index)));
        ++this.index;
    }

    public int getTotal() {
        return this.total;
    }

    public String getBase64Chart() {
        JFreeChart chart = ChartFactory.createLineChart(null, null, null, (CategoryDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.removeLegend();
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setFixedLegendItems(null);
        chart.setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
        plot.setBackgroundAlpha(0.0f);
        plot.getDomainAxis().setVisible(false);
        plot.getDomainAxis().setTickLabelsVisible(false);
        plot.getRangeAxis().setVisible(false);
        plot.getRangeAxis().setTickLabelsVisible(false);
        plot.setOutlinePaint(null);
        plot.setFixedLegendItems(null);
        float[] dash1 = new float[]{2.0f, 0.0f, 3.0f};
        plot.setRangeGridlineStroke((Stroke)new BasicStroke(0.3f, 0, 1, 1.0f, dash1, 2.0f));
        plot.setRangeGridlinePaint((Paint)GRID_COLOR);
        plot.getRenderer().setSeriesStroke(0, (Stroke)new BasicStroke(3.0f));
        plot.getRenderer().setSeriesPaint(0, (Paint)LINE_COLOR);
        NumberAxis yAxis = (NumberAxis)plot.getRangeAxis();
        yAxis.setTickUnit(new NumberTickUnit(500.0));
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(260, 80));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ChartUtils.writeChartAsPNG((OutputStream)baos, (JFreeChart)chart, (int)260, (int)80);
        }
        catch (IOException e) {
            return null;
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

