/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.analytics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class ActionsType {
    private static final Color MOUSE_COLOR = Color.decode("#027aca");
    private static final Color ASSERT_COLOR = Color.decode("#699400");
    private static final Color TEXT_COLOR = Color.decode("#6a3dac");
    private static final Color OTHER_COLOR = Color.decode("#464a57");
    private static final Color GRID_COLOR = Color.decode("#5a6886");
    private static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    private DefaultCategoryDataset dataSet = new DefaultCategoryDataset();
    private int mouseCount = 0;
    private int textCount = 0;
    private int assertCount = 0;
    private int otherCount = 0;

    public ActionsType() {
    }

    public ActionsType(int mouseCount, int textCount, int assertCount, int otherCount) {
        this.mouseCount = mouseCount;
        this.textCount = textCount;
        this.assertCount = assertCount;
        this.otherCount = otherCount;
    }

    public void addActionType(String type) {
        if (type.contains("ActionMouse")) {
            ++this.mouseCount;
        } else if (type.contains("ActionText")) {
            ++this.textCount;
        } else if (type.contains("ActionAssert")) {
            ++this.assertCount;
        } else {
            ++this.otherCount;
        }
    }

    public String getBase64Chart() {
        this.dataSet.addValue((double)this.mouseCount, (Comparable)((Object)"Mouse"), (Comparable)((Object)"s1"));
        this.dataSet.addValue((double)this.textCount, (Comparable)((Object)"Text"), (Comparable)((Object)"s1"));
        this.dataSet.addValue((double)this.assertCount, (Comparable)((Object)"Assert"), (Comparable)((Object)"s1"));
        this.dataSet.addValue((double)this.otherCount, (Comparable)((Object)"Other"), (Comparable)((Object)"s1"));
        JFreeChart chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)this.dataSet, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)MOUSE_COLOR);
        renderer.setSeriesPaint(1, (Paint)TEXT_COLOR);
        renderer.setSeriesPaint(2, (Paint)ASSERT_COLOR);
        renderer.setSeriesPaint(3, (Paint)OTHER_COLOR);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        renderer.setShadowVisible(false);
        chart.getLegend().setPosition(RectangleEdge.RIGHT);
        chart.getLegend().setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.getDomainAxis().setVisible(false);
        plot.getDomainAxis().setTickLabelsVisible(false);
        plot.getRangeAxis().setVisible(false);
        plot.getRangeAxis().setTickLabelsVisible(false);
        plot.setOutlinePaint(null);
        float[] dash1 = new float[]{1.0f, 0.0f, 2.0f};
        plot.setRangeGridlineStroke((Stroke)new BasicStroke(0.3f, 0, 1, 1.0f, dash1, 2.0f));
        plot.setRangeGridlinePaint((Paint)GRID_COLOR);
        chart.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        plot.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
        NumberAxis range = (NumberAxis)plot.getRangeAxis();
        range.setTickUnit(new NumberTickUnit(2.0));
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(260, 80));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ChartUtils.writeChartAsPNG((OutputStream)baos, (JFreeChart)chart, (int)260, (int)80);
        }
        catch (IOException e) {
            return null;
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

