/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report;

import com.ats.executor.TestBound;
import com.ats.recorder.TestError;
import com.ats.recorder.TestSummary;
import com.ats.recorder.VisualAction;
import com.ats.recorder.VisualElement;
import com.ats.recorder.VisualReport;
import com.ats.tools.ResourceContent;
import com.ats.tools.logger.ExecutionLogger;
import com.exadel.flamingo.flex.messaging.amf.io.AMF3Deserializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class htmlPlayerReport {
    public static String htmlPlayerParam = "htmlplayer";
    private static Map<String, String> executionData = new HashMap<String, String>();
    private static Map<String, String> testData = new HashMap<String, String>();
    private static Map<String, String> actionData = new HashMap<String, String>();
    private static Map<String, String> actionsData = new HashMap<String, String>();
    private static Map<String, String> iconsData = new HashMap<String, String>();
    private static Map<String, String> customImg = new HashMap<String, String>();
    private static Map<String, String> actionsImg = new HashMap<String, String>();
    private static final String REPORT_FOLDER = "reports";
    private static final String IMAGE_FOLDER = "images";
    private static final String HTML_FOLDER = "playerHTML";
    private static final String CUSTOM_TEMPLATES_FOLDER = "/reports/playerHTML/";
    private static final String CUSTOM_IMAGES_FOLDER = "/reports/images/";
    private static String c_testName = "";
    private static final Path reportPath = Paths.get("src", "assets", "resources", "reports");
    private static final Path imagesPath = Paths.get(reportPath.toString(), "images");
    private static final String[] imagesList = new String[]{"logo.png", "true.png", "false.png", "warning.png", "noStop.png", "api.png", "pdf.png", "watermark.png"};
    private static final String CUSTOM_GSAP_FOLDER = "/reports/playerHTML/gsap_file/";
    private static final String CSS_FILE_NAME = "open.css";
    private static final String GSAP_FILE_NAME = "gsap_3.11.1.min.js";
    private static final String GSAP_STP_FILE_NAME = "ScrollToPlugin_3.11.1.min.js";
    private static final String JSCODE_FILE_NAME = "script.js";
    private static boolean developper = false;
    private static PrintWriter devData = null;
    private static PrintWriter devImg = null;
    private static final String HTML_TEMPLATE_NAME = "player_tpl.html";
    private static final String HTML_PLAYER_NAME = "atsv.html";
    static Path outputFolder;
    static Path inputFolder;
    public static String REPORT_FILE;

    public static void main(String[] args) throws IOException {
        List<String> listArgs = Arrays.asList(args);
        if (args.length == 0 || listArgs.contains("--help") || listArgs.contains("-h") || listArgs.contains("--h") || listArgs.contains("/?") || listArgs.contains("\\?")) {
            htmlPlayerReport.usage();
            return;
        }
        String testName = null;
        boolean iconsConvert = false;
        boolean execution = false;
        block16: for (int i = 0; i < args.length; ++i) {
            String param = args[i];
            if (!param.startsWith("--")) continue;
            switch (param.substring(2)) {
                case "outputFolder": 
                case "output": {
                    if (i + 1 < args.length) {
                        outputFolder = Path.of(args[i + 1].replaceAll("\"", ""), new String[0]);
                    }
                    execution = true;
                    continue block16;
                }
                case "input": 
                case "inputFolder": {
                    if (i + 1 < args.length) {
                        inputFolder = Path.of(args[i + 1].replaceAll("\"", ""), new String[0]);
                    }
                    execution = true;
                    continue block16;
                }
                case "testName": {
                    c_testName = testName = args[i + 1];
                    execution = true;
                    continue block16;
                }
                case "iconsConvert": {
                    iconsConvert = true;
                    continue block16;
                }
                case "dev": {
                    developper = true;
                    continue block16;
                }
                default: {
                    System.out.println("\u001b[31munrecognized parameter : \u001b[0m" + param);
                    htmlPlayerReport.usage();
                    return;
                }
            }
        }
        if (iconsConvert) {
            System.out.println("iconsData Js file started");
            htmlPlayerReport.writeJSIconsFile();
            System.out.println("iconsData Js file ended");
        }
        if (execution) {
            if (inputFolder != null && inputFolder.toFile().isDirectory()) {
                if (outputFolder == null || !outputFolder.toFile().isDirectory()) {
                    System.out.println("Output Folder not specified or unavailabled \n\tInput folder used like output Folder");
                    outputFolder = inputFolder;
                }
                if (testName != null && inputFolder.resolve(testName + ".atsv").toFile().exists()) {
                    htmlPlayerReport.createHTMLPlayerReport(new ExecutionLogger(System.out), inputFolder, testName, outputFolder);
                } else {
                    System.out.println("[ERROR] invalid suite Name. GENETRATION ABORTED");
                }
            } else {
                System.out.println("[ERROR] Input folder Doesn't exist. GENETRATION ABORTED");
            }
        }
    }

    private static void usage() {
        System.out.print("Usage : Experiment dev\nThis class is use to extract data from ATSV, convert and generate to a html_player\n\nParameters usage (case sensitive):\n\t--inputFolder\t\t(mandatory)(absolute or relative path) : parameter used to specify\n\t  input\t\t\t\tthe input folder where the system can find the ATSV file\n\t--testName\t\t\t(mandatory) : ATSV file name without extension\n\t--outputFolder\t\t(optional)(absolute or relative path) : parameter used to\n\t  output\t\t\tspecify the output folder of generated player\n\n\n\n\n");
    }

    public static void createHTMLPlayerReport(ExecutionLogger logger, Path in, String qualifiedName, Path ... out) {
        File atsvFile;
        actionsData = new HashMap<String, String>();
        executionData = new HashMap<String, String>();
        testData = new HashMap<String, String>();
        actionsImg = new HashMap<String, String>();
        if (in == null || !in.toFile().isDirectory()) {
            logger.sendError("Input folder Doesn't exist", in != null ? in.toString() : "");
            return;
        }
        outputFolder = out.length > 0 ? out[0] : in;
        if (qualifiedName != "") {
            c_testName = qualifiedName;
        }
        if ((atsvFile = in.resolve(qualifiedName + ".atsv").toFile()).exists()) {
            File xmlFolder = in.resolve(qualifiedName + "_xml").toFile();
            logger.sendInfo("Create HTML player report", xmlFolder.getAbsolutePath());
            try {
                try {
                    FileInputStream fis = new FileInputStream(atsvFile);
                    AMF3Deserializer amf3 = new AMF3Deserializer((InputStream)fis);
                    VisualReport report = (VisualReport)amf3.readObject();
                    htmlPlayerReport.reportDataStruct(report);
                    htmlPlayerReport.testDataStruct(report);
                    int actionsNum = 0;
                    try {
                        amf3.readObject();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    while (amf3.available() > 0) {
                        Object obj = amf3.readObject();
                        if (obj instanceof VisualAction) {
                            VisualAction va = (VisualAction)obj;
                            actionData = new HashMap<String, String>();
                            htmlPlayerReport.actionDataStruct(va);
                            VisualElement ve = va.getElement();
                            if (ve != null) {
                                htmlPlayerReport.addActionData("element", htmlPlayerReport.elementDataStruct(ve));
                            }
                            htmlPlayerReport.addActionsDataStruct(String.valueOf(actionsNum), htmlPlayerReport.getStringElement(actionData, false));
                            htmlPlayerReport.addActionsImg(String.valueOf(actionsNum), htmlPlayerReport.imagesDataStruct(va));
                            ++actionsNum;
                            continue;
                        }
                        if (!(obj instanceof TestSummary)) continue;
                        TestSummary reportSummary = (TestSummary)obj;
                        htmlPlayerReport.summaryStruct(reportSummary);
                    }
                }
                catch (IOException e1) {
                    logger.sendError("ATSV report file error ->", e1.getMessage());
                }
                catch (Exception e2) {
                    logger.sendError("ATSV report exception ->", e2.getMessage());
                }
            }
            catch (Exception e4) {
                logger.sendError("ATSV report parser error ->", e4.getMessage());
            }
            htmlPlayerReport.copyRessources();
            htmlPlayerReport.extractFolderIcons("reports/playerHTML/icons", "png");
            htmlPlayerReport.extractFolderIcons("reports/playerHTML/icons", "gif");
            htmlPlayerReport.addDefaultRessources();
            htmlPlayerReport.writeHTMLFile();
            logger.sendInfo("HTML_player generated", xmlFolder.getAbsolutePath());
        } else {
            logger.sendError("No ATSV file, XML actions file cannot be generated", atsvFile.getAbsolutePath());
        }
    }

    private static void reportDataStruct(VisualReport report) {
        executionData.put("cpuSpeed", htmlPlayerReport.JSData(report.getCpuSpeed()));
        executionData.put("cpuCount", htmlPlayerReport.JSData(report.getCpuCount()));
        executionData.put("totalMemory", htmlPlayerReport.JSData(report.getTotalMemory()));
        executionData.put("osInfo", htmlPlayerReport.JSData(report.getOsInfo()));
    }

    private static void testDataStruct(VisualReport report) {
        testData.put("testId", htmlPlayerReport.JSData(report.getId()));
        testData.put("testName", htmlPlayerReport.JSData(report.getScript()));
        testData.put("externalId", htmlPlayerReport.JSData(report.getExternalId()));
        testData.put("description", htmlPlayerReport.JSData(report.getDescription()));
        testData.put("author", htmlPlayerReport.JSData(report.getAuthor()));
        testData.put("prerequisite", htmlPlayerReport.JSData(report.getPrerequisite()));
        testData.put("started", htmlPlayerReport.JSData(Long.valueOf(report.getStarted())));
        testData.put("quality", htmlPlayerReport.JSData(report.getQuality()));
        testData.put("groups", htmlPlayerReport.JSData(report.getGroups()));
    }

    private static void addTestData(String key, String value) {
        testData.put(key, value);
    }

    private static void addActionData(String key, String value) {
        actionData.put(key, value);
    }

    private static void actionDataStruct(VisualAction va) {
        actionData.put("index", htmlPlayerReport.JSData(va.getIndex()));
        actionData.put("type", htmlPlayerReport.JSData(va.getType()));
        actionData.put("line", htmlPlayerReport.JSData(va.getLine()));
        actionData.put("script", htmlPlayerReport.JSData(va.getScript()));
        actionData.put("timeLine", htmlPlayerReport.JSData(va.getTimeLine()));
        actionData.put("error", htmlPlayerReport.JSData(va.getError()));
        actionData.put("stop", htmlPlayerReport.JSData(va.isStop()));
        actionData.put("duration", htmlPlayerReport.JSData(va.getDuration()));
        actionData.put("passed", htmlPlayerReport.JSData(va.getError() == 0));
        actionData.put("value", htmlPlayerReport.JSData(va.getValue()));
        actionData.put("data", htmlPlayerReport.JSData(va.getData()));
        actionData.put("Channel", htmlPlayerReport.channelDataStruct(va));
    }

    private static void addActionsDataStruct(String key, String value) {
        actionsData.put(key, value);
    }

    private static void addActionsImg(String key, String value) {
        actionsImg.put(key, value);
    }

    private static String imagesDataStruct(VisualAction va) {
        HashMap<String, String> imagesData = new HashMap<String, String>();
        imagesData.put("imageType", htmlPlayerReport.JSData(va.getImageType()));
        HashMap<String, String> imageData = new HashMap<String, String>();
        int index = 0;
        for (byte[] img : va.getImages()) {
            if (img == null) continue;
            imageData.put(String.valueOf(index), htmlPlayerReport.JSData(Base64.getEncoder().encodeToString(img)));
            ++index;
        }
        imagesData.put("numImages", htmlPlayerReport.JSData(index));
        imagesData.put("imagesPool", htmlPlayerReport.getStringElement(imageData, false));
        return htmlPlayerReport.getStringElement(imagesData, false);
    }

    private static String channelDataStruct(VisualAction va) {
        HashMap<String, String> channelData = new HashMap<String, String>();
        channelData.put("name", htmlPlayerReport.JSData(va.getChannelName()));
        channelData.put("bound", htmlPlayerReport.boundDataStruct(va.getChannelBound()));
        return htmlPlayerReport.getStringElement(channelData, false);
    }

    private static String boundDataStruct(TestBound bound) {
        HashMap<String, String> boundData = new HashMap<String, String>();
        boundData.put("x", htmlPlayerReport.JSData(bound.getX().intValue()));
        boundData.put("y", htmlPlayerReport.JSData(bound.getY().intValue()));
        boundData.put("width", htmlPlayerReport.JSData(bound.getWidth().intValue()));
        boundData.put("height", htmlPlayerReport.JSData(bound.getHeight().intValue()));
        return htmlPlayerReport.getStringElement(boundData, false);
    }

    private static String elementDataStruct(VisualElement ve) {
        HashMap<String, String> elementData = new HashMap<String, String>();
        elementData.put("tag", htmlPlayerReport.JSData(ve.getTag()));
        elementData.put("criterias", htmlPlayerReport.JSData(ve.getCriterias()));
        elementData.put("foundElements", htmlPlayerReport.JSData(ve.getFoundElements()));
        elementData.put("searchDuration", htmlPlayerReport.JSData(ve.getSearchDuration()));
        elementData.put("bound", htmlPlayerReport.boundDataStruct(ve.getRectangle()));
        if (ve.getHpos() != null && ve.getVpos() != null) {
            elementData.put("extra", "{hPos : " + htmlPlayerReport.JSData(ve.getHpos()) + ",hVal : " + htmlPlayerReport.JSData(ve.getHposValue()) + ",vPos : " + htmlPlayerReport.JSData(ve.getVpos()) + ",vVal : " + htmlPlayerReport.JSData(ve.getVposValue()) + "}");
        }
        return htmlPlayerReport.getStringElement(elementData, false);
    }

    private static void summaryStruct(TestSummary summary) {
        htmlPlayerReport.addTestData("actions", htmlPlayerReport.JSData(summary.getActions()));
        htmlPlayerReport.addTestData("suiteName", htmlPlayerReport.JSData(summary.getSuiteName()));
        htmlPlayerReport.addTestData("status", htmlPlayerReport.JSData(summary.getStatus()));
        htmlPlayerReport.addTestData("data", htmlPlayerReport.JSData(summary.getSummary()));
        if (summary.getStatus() == 0 && summary.getError() != null) {
            TestError scriptError = summary.getError();
            htmlPlayerReport.addTestData("error", "{\nscript : " + htmlPlayerReport.JSData(scriptError.getScriptLine()) + ", line : " + htmlPlayerReport.JSData(scriptError.getLine()) + ", message : " + htmlPlayerReport.JSData(scriptError.getMessage()) + "\n}");
        }
    }

    private static String JSData(Object obj) {
        Object data = "";
        if (obj instanceof String) {
            Object tmp = (String)obj;
            if (((String)tmp).lastIndexOf("\\") != -1 && ((String)tmp).lastIndexOf("\\") == ((String)tmp).length() - 1) {
                tmp = ((String)tmp).substring(0, ((String)tmp).length() - 2) + "&#92;";
            }
            StringBuilder SB = new StringBuilder();
            SB.append("\"").append(((String)tmp).replaceAll("\"", "'")).append("\"");
            data = SB.toString();
        } else {
            data = obj instanceof Integer || obj instanceof Long ? String.valueOf(obj) : (obj instanceof Boolean ? ((Boolean)obj != false ? "1" : "0") : "\"\"");
        }
        return StandardCharsets.UTF_8.decode(StandardCharsets.UTF_8.encode((String)data)).toString();
    }

    private static String getStringElement(Map<String, String> data, boolean enter) {
        StringBuilder stringData = new StringBuilder("{");
        Set<String> elements = data.keySet();
        boolean first = true;
        for (String element : elements) {
            String value = data.get(element);
            if (!first) {
                stringData.append(",");
            } else {
                first = false;
            }
            if (enter) {
                stringData.append("\n");
            }
            stringData.append(element).append(" : ").append(value);
        }
        if (stringData.length() == 1) {
            return null;
        }
        return stringData.append("}").toString();
    }

    private static void writeHTMLFile() {
        try {
            String line;
            PrintWriter htmlOPS = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFolder.resolve(htmlPlayerReport.getHtmlPlayerName(c_testName)).toFile()), StandardCharsets.UTF_8));
            if (developper) {
                String date = new SimpleDateFormat("yyyy-MM-dd_hh-mm").format(new Date(Long.valueOf(testData.get("started"))));
                Path devPath = Paths.get(outputFolder.toString() + "\\" + date, new String[0]);
                System.out.println("path dev folder :" + devPath.toString());
                Files.createDirectories(devPath, new FileAttribute[0]);
                devData = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(devPath.resolve("data.js").toFile()), StandardCharsets.UTF_8));
                devImg = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(devPath.resolve("img.js").toFile()), StandardCharsets.UTF_8));
            }
            try {
                Files.deleteIfExists(outputFolder.resolve(HTML_TEMPLATE_NAME));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            FileInputStream htmlIPStream = new FileInputStream(htmlPlayerReport.copyResource(HTML_TEMPLATE_NAME, outputFolder));
            BufferedReader htmlTemplate = new BufferedReader(new InputStreamReader(htmlIPStream));
            while ((line = htmlTemplate.readLine()) != null) {
                StringBuilder data;
                if (line.contains("!%ATS%GSAP%ATS%!")) {
                    htmlPlayerReport.writeIntegratedFile(htmlOPS, "script", GSAP_FILE_NAME, CUSTOM_GSAP_FOLDER);
                    continue;
                }
                if (line.contains("!%ATS%GSAP_STP%ATS%!")) {
                    htmlPlayerReport.writeIntegratedFile(htmlOPS, "script", GSAP_STP_FILE_NAME, CUSTOM_GSAP_FOLDER);
                    continue;
                }
                if (line.contains("!%ATS%CSS%ATS%!")) {
                    htmlPlayerReport.writeIntegratedFile(htmlOPS, "style", CSS_FILE_NAME, new String[0]);
                    continue;
                }
                if (line.contains("!%ATS%JSCODE%ATS%!")) {
                    htmlPlayerReport.writeIntegratedFile(htmlOPS, "script", JSCODE_FILE_NAME, new String[0]);
                    continue;
                }
                if (line.contains("!%ATS%JSICONS%ATS%!")) {
                    data = new StringBuilder();
                    data.append("const icons = ").append(htmlPlayerReport.getStringElement(iconsData, true)).append("\n");
                    htmlOPS.write("\t<script > // auto-generated section\n");
                    htmlOPS.write(data.toString());
                    htmlOPS.write("\n\t /* end of auto-integrated section */ </script>\n\n");
                    continue;
                }
                if (line.contains("!%ATS%JSDATA%ATS%!")) {
                    data = new StringBuilder();
                    data.append("const execution = " + htmlPlayerReport.getStringElement(executionData, false) + "\n");
                    data.append("const test = " + htmlPlayerReport.getStringElement(testData, false) + "\n");
                    data.append("const actions = " + htmlPlayerReport.getStringElement(actionsData, true) + "\n");
                    data.append("const customsImg = " + htmlPlayerReport.getStringElement(customImg, true) + "\n");
                    data.append("dataLoaded = true;\n");
                    htmlOPS.write("\t<script > // auto-generated section\n");
                    htmlOPS.write(data.toString());
                    htmlOPS.write("\n\t /* end of auto-integrated section */ </script>\n\n");
                    htmlOPS.flush();
                    if (!developper || devData == null) continue;
                    devData.write(data.toString());
                    devData.flush();
                    continue;
                }
                if (line.contains("!%ATS%JSIMG%ATS%!")) {
                    htmlPlayerReport.writeImgStock(htmlOPS);
                    continue;
                }
                htmlOPS.write(line);
                htmlOPS.write(10);
                htmlOPS.flush();
            }
            ((InputStream)htmlIPStream).close();
            htmlTemplate.close();
            htmlOPS.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            Files.deleteIfExists(outputFolder.resolve(HTML_TEMPLATE_NAME));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (developper) {
            if (devData != null) {
                devData.close();
            }
            if (devImg != null) {
                devImg.close();
            }
        }
    }

    public static String getHtmlPlayerName(String name) {
        StringBuilder sb = new StringBuilder(name).append("_").append(HTML_PLAYER_NAME);
        return sb.toString();
    }

    private static File copyResource(String resName, Path dest) {
        Path filePath = dest.resolve(resName);
        try {
            if (!Files.exists(filePath, new LinkOption[0])) {
                int lengthRead;
                InputStream is = ResourceContent.class.getResourceAsStream(CUSTOM_TEMPLATES_FOLDER + resName);
                BufferedInputStream in = new BufferedInputStream(is);
                File targetFile = dest.resolve(resName).toFile();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                byte[] buffer = new byte[1024];
                while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                    ((OutputStream)out).write(buffer, 0, lengthRead);
                    ((OutputStream)out).flush();
                }
                ((InputStream)in).close();
                is.close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return filePath.toFile();
    }

    private static long writeIntegratedFile(PrintWriter out, String type, String fileToIntegrate, String ... specificInputPath) {
        String inputResourceFolder = "";
        inputResourceFolder = specificInputPath.length > 0 ? specificInputPath[0] : CUSTOM_TEMPLATES_FOLDER;
        InputStream is = ResourceContent.class.getResourceAsStream(inputResourceFolder + fileToIntegrate);
        BufferedInputStream in = new BufferedInputStream(is);
        byte[] buffer = new byte[1024];
        long byteRead = -1L;
        out.write("\n\t<" + type + "> /* auto-integrated section */ \n");
        out.flush();
        try {
            int lengthRead;
            while ((lengthRead = ((InputStream)in).read(buffer)) > 0) {
                byteRead += (long)lengthRead;
                String line = new String(buffer);
                line = lengthRead != 1024 ? line.substring(0, lengthRead - 1) : line;
                out.write(line);
                out.flush();
                buffer = new byte[1024];
            }
            out.write("\n\t/* end of auto-integrated section */ </" + type + ">\n");
            out.flush();
            ((InputStream)in).close();
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteRead;
    }

    private static void writeJSIconsFile() {
        BufferedOutputStream IconsOPS = null;
        try {
            IconsOPS = new BufferedOutputStream(new FileOutputStream(Path.of("T:\\env\\ATS\\ats-core\\src\\main\\resources\\reports\\playerHTML\\icons\\iconsData.js", new String[0]).toFile()));
            ArrayList iconsPath = new ArrayList();
            HashMap<String, String> icons = new HashMap<String, String>();
            HashMap<String, String> data = new HashMap<String, String>();
            Files.list(new File(String.valueOf(inputFolder) + "player\\32").toPath()).forEach(path -> {
                iconsPath.add(path.toString());
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), htmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("player_32", htmlPlayerReport.getStringElement(icons, true));
            Files.list(new File(String.valueOf(inputFolder) + "actions\\32").toPath()).forEach(path -> {
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), htmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("actions_32", htmlPlayerReport.getStringElement(icons, true));
            Files.list(new File(String.valueOf(inputFolder) + "actions\\24").toPath()).forEach(path -> {
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), htmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("actions_24", htmlPlayerReport.getStringElement(icons, true));
            Files.list(new File(String.valueOf(inputFolder) + "actions\\20").toPath()).forEach(path -> {
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), htmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("actions_20", htmlPlayerReport.getStringElement(icons, true));
            Files.list(new File(String.valueOf(inputFolder) + "actions\\16").toPath()).forEach(path -> {
                String fileNameExt = path.toString().substring(path.toString().lastIndexOf("\\") + 1);
                String fileName = fileNameExt.substring(0, fileNameExt.lastIndexOf("."));
                String format = fileNameExt.substring(fileNameExt.lastIndexOf(".") + 1);
                try {
                    icons.put(fileName.replaceAll("-", "_"), htmlPlayerReport.JSData("data:image/" + format + ";base64," + Base64.getEncoder().encodeToString(Files.readAllBytes(path))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            data.put("actions_16", htmlPlayerReport.getStringElement(icons, true));
            ((OutputStream)IconsOPS).write("const icons = ".getBytes());
            ((OutputStream)IconsOPS).write(htmlPlayerReport.getStringElement(data, true).getBytes());
            ((OutputStream)IconsOPS).write(10);
            ((OutputStream)IconsOPS).flush();
            ((OutputStream)IconsOPS).write(10);
            ((OutputStream)IconsOPS).flush();
            ((OutputStream)IconsOPS).close();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void writeImgStock(PrintWriter outputFile) {
        int size = actionsImg.size();
        StringBuilder imgData = new StringBuilder();
        for (int index = 0; index < size; ++index) {
            imgData = new StringBuilder();
            outputFile.write("<script>");
            imgData.append("imgStock[" + String.valueOf(index) + "] = " + actionsImg.get(String.valueOf(index)) + ";\n");
            imgData.append("imgStockLoaded = " + String.valueOf(index + 1) + ";");
            outputFile.write(imgData.toString());
            outputFile.write("</script>\n");
            outputFile.flush();
            if (!developper || devImg == null) continue;
            devImg.write(imgData.toString());
            devImg.flush();
        }
    }

    private static void copyRessources() {
        if (Files.exists(imagesPath, new LinkOption[0])) {
            for (String img : imagesList) {
                htmlPlayerReport.copyRessourcesImage(imagesPath.resolve(img));
            }
        } else {
            System.out.println("Images Folder do not exist");
        }
    }

    private static void extractFolderIcons(String prePath, String ext) {
        List<String> resToCopy = htmlPlayerReport.extractJarFolderRessourcesPath(prePath, ext);
        while (!resToCopy.isEmpty()) {
            String subPath = resToCopy.get(0).substring(0, resToCopy.get(0).lastIndexOf("/"));
            int loopSize = resToCopy.size();
            int index = 0;
            HashMap<String, String> icons = new HashMap<String, String>();
            while (index < loopSize) {
                String path = resToCopy.get(index);
                String subPathData = path.substring(0, path.lastIndexOf("/"));
                if (subPathData.startsWith(subPath)) {
                    byte[] imgBytes = null;
                    try {
                        imgBytes = ResourceContent.class.getResourceAsStream("/" + path).readAllBytes();
                        String fileName = path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf("."));
                        icons.put(fileName.replaceAll("/", "_").replaceAll("-", "_"), htmlPlayerReport.JSData("data:image/" + ext + ";base64," + htmlPlayerReport.getBase64DefaultImages(imgBytes)));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    resToCopy.remove(path);
                    --loopSize;
                    continue;
                }
                ++index;
            }
            String key = subPath.replace(prePath, "").substring(1).replaceAll("/", "_");
            if (iconsData.containsKey(key)) {
                String data = iconsData.get(key).substring(2, iconsData.get(key).lastIndexOf("}"));
                String[] table = data.split(",\n");
                for (int iconInd = 0; iconInd < table.length; ++iconInd) {
                    String ligne = table[iconInd];
                    int indCar = ligne.indexOf(":");
                    String iconName = ligne.substring(0, indCar - 1);
                    String iconData = iconInd == table.length - 1 ? ligne.substring(indCar + 1) : ligne.substring(indCar + 2);
                    icons.put(iconName, iconData);
                }
            }
            iconsData.put(key, htmlPlayerReport.getStringElement(icons, true));
        }
    }

    private static void copyRessourcesImage(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            File f = path.toFile();
            if (f.isFile()) {
                String fileName = f.getName().substring(0, f.getName().lastIndexOf("."));
                String imgData = htmlPlayerReport.getImg64(path.getParent(), f.getName());
                customImg.put(fileName.replaceAll("-", "_"), htmlPlayerReport.JSData(imgData));
            } else {
                System.out.println("path (" + path.toString() + ") is not file");
            }
        }
    }

    private static List<String> extractJarFolderRessourcesPath(String prePathFolder, String ext) {
        CodeSource src = ResourceContent.class.getProtectionDomain().getCodeSource();
        ArrayList<String> list = new ArrayList<String>();
        if (src != null) {
            URL jar = src.getLocation();
            ZipInputStream zip = null;
            try {
                zip = new ZipInputStream(jar.openStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ZipEntry ze = null;
            while (true) {
                try {
                    ze = zip.getNextEntry();
                    if (ze == null) {
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String entryName = ze.getName();
                if (!entryName.startsWith(prePathFolder) || !entryName.endsWith("." + ext)) continue;
                list.add(entryName);
            }
        }
        return list;
    }

    private static String getImg64(Path path, String imgFileName) {
        Object imgFile = "";
        byte[] imgBytes = null;
        String format = imgFileName.substring(imgFileName.lastIndexOf(".") + 1);
        if (Files.exists(path.resolve(imgFileName), new LinkOption[0])) {
            try {
                format = imgFileName.substring(imgFileName.lastIndexOf(".") + 1);
                imgBytes = Files.readAllBytes(path.resolve(imgFileName));
                imgFile = "data:image/" + format + ";base64," + htmlPlayerReport.getBase64DefaultImages(imgBytes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            imgBytes = ResourceContent.class.getResourceAsStream(CUSTOM_IMAGES_FOLDER + imgFileName).readAllBytes();
            imgFile = "data:image/" + format + ";base64," + htmlPlayerReport.getBase64DefaultImages(imgBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return imgFile;
    }

    private static String getBase64DefaultImages(byte[] b) throws IOException {
        return Base64.getEncoder().encodeToString(b);
    }

    private static void addDefaultRessources() {
        byte[] imgBytes = null;
        try {
            imgBytes = ResourceContent.class.getResourceAsStream("/reports/images/watermark.png").readAllBytes();
            customImg.put("defaultWM", htmlPlayerReport.JSData("data:image/png;base64," + htmlPlayerReport.getBase64DefaultImages(imgBytes)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        REPORT_FILE = "actions.xml";
    }
}

