/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.listeners;

import com.ats.AtsSingleton;
import com.ats.generator.ATS;
import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.HtmlCampaignReportGenerator;
import com.ats.tools.report.SuitesReport;
import com.ats.tools.report.SuitesReportItem;
import com.diogonunes.jcolor.Ansi;
import com.diogonunes.jcolor.Attribute;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.testng.IExecutionListener;

public class ExecutionListener
implements IExecutionListener {
    private static final Gson gson = new Gson();
    private static final String ATS_REPORT_LEVEL_FROM_COMMANDLINE = "ats.report";
    private static SuitesReport suiteReport = null;
    private static SuitesReportItem suiteItem = null;
    private static final List<String> trueList = Arrays.asList("on", "true", "1", "yes", "y");

    private static void setSuitesFile(File value) {
        File outputDir = value.getParentFile();
        outputDir.mkdirs();
        AtsSingleton.getInstance().setJsonSuitesFilePath(value.getAbsolutePath());
        AtsSingleton.getInstance().setAtsOutputFolder(outputDir.getAbsolutePath());
        AtsSingleton.getInstance().setProjectPath(outputDir.getParentFile().getAbsolutePath());
    }

    public static void startSuite(SuitesReportItem suite) {
        suiteItem = suite;
        try {
            File jsonSuiteFile = AtsSingleton.getInstance().getJsonSuitesFile();
            if (jsonSuiteFile == null) {
                jsonSuiteFile = suiteItem.getSuitesFile();
                ExecutionListener.setSuitesFile(jsonSuiteFile);
                suiteReport = new SuitesReport(suiteItem);
            } else {
                JsonReader reader = new JsonReader((Reader)new FileReader(jsonSuiteFile));
                suiteReport = (SuitesReport)gson.fromJson(reader, SuitesReport.class);
                reader.close();
                suiteReport.add(suiteItem);
            }
            FileWriter writer = new FileWriter(jsonSuiteFile);
            gson.toJson((Object)suiteReport, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void onExecutionStart() {
        super.onExecutionStart();
        System.out.println("-------------------------------------------------------");
        System.out.println("   ATS ver. " + ATS.getAtsVersion() + "   ( " + Ansi.colorize((String)"https://actiontestscript.org", (Attribute[])new Attribute[]{Attribute.BRIGHT_BLUE_TEXT()}) + " )");
        System.out.println("-------------------------------------------------------");
    }

    public void onExecutionFinish() {
        super.onExecutionFinish();
        if (suiteItem.isNoSuiteLaunch()) {
            AtsLogger.printLog(Ansi.colorize((String)" ----------------------------------------------- ", (Attribute[])new Attribute[]{Attribute.MAGENTA_BACK()}));
            AtsLogger.printLog(Ansi.colorize((String)"         ATS test execution complete             ", (Attribute[])new Attribute[]{Attribute.MAGENTA_BACK()}));
            AtsLogger.printLog(Ansi.colorize((String)" ----------------------------------------------- ", (Attribute[])new Attribute[]{Attribute.MAGENTA_BACK()}));
        } else {
            AtsLogger.printLog(Ansi.colorize((String)" ----------------------------------------------- ", (Attribute[])new Attribute[]{Attribute.CYAN_BACK()}));
            AtsLogger.printLog(Ansi.colorize((String)"         ATS suite execution complete            ", (Attribute[])new Attribute[]{Attribute.CYAN_BACK()}));
            AtsLogger.printLog(Ansi.colorize((String)" ----------------------------------------------- ", (Attribute[])new Attribute[]{Attribute.CYAN_BACK()}));
        }
        String outputFolder = AtsSingleton.getInstance().getAtsOutputFolder();
        Path outputFolderPath = Paths.get(outputFolder, new String[0]);
        String cmdATSReport = System.getProperty("ats-report");
        int devReport = 0;
        String atsReportEnv = System.getenv("ATS_REPORT");
        if (atsReportEnv != null) {
            devReport = Utils.string2Int(atsReportEnv, 0);
        }
        if (cmdATSReport != null) {
            devReport = Utils.string2Int(cmdATSReport, 0);
        }
        String cmdMGTReport = System.getProperty("mgt-report");
        int mgtReport = 0;
        if (cmdMGTReport != null) {
            mgtReport = Utils.string2Int(cmdMGTReport, 0);
        }
        String cmdvalidReport = System.getProperty("validation-report");
        int validReport = 0;
        if (cmdvalidReport != null) {
            validReport = trueList.indexOf(cmdvalidReport.toLowerCase()) > -1 ? 1 : 0;
        }
        boolean reportingAsk = false;
        for (SuitesReportItem item : ExecutionListener.suiteReport.suites) {
            if (!item.isReporting()) continue;
            reportingAsk = true;
        }
        String atsReportLevelProperty = System.getProperty(ATS_REPORT_LEVEL_FROM_COMMANDLINE);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{atsReportLevelProperty}) && devReport <= 0) {
            devReport = Integer.parseInt(atsReportLevelProperty);
        }
        if (devReport + mgtReport + validReport != 0 || reportingAsk) {
            AtsLogger.printLog("generate ATS report -> " + outputFolder);
            File jsonSuiteFile = AtsSingleton.getInstance().getJsonSuitesFile();
            if (jsonSuiteFile != null && jsonSuiteFile.exists()) {
                try {
                    new HtmlCampaignReportGenerator(outputFolderPath, jsonSuiteFile, devReport, validReport, suiteItem).generateSuitsHtmlReports();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

