/*
 * Decompiled with CFR 0.152.
 */
package com.ats.recorder;

import com.ats.AtsSingleton;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionStatus;
import com.ats.executor.ActionTestScript;
import com.ats.executor.channels.Channel;
import com.ats.executor.channels.EmptyChannel;
import com.ats.executor.drivers.desktop.DesktopResponse;
import com.ats.generator.objects.MouseDirection;
import com.ats.recorder.IVisualRecorder;
import com.ats.recorder.TestError;
import com.ats.recorder.TestSummary;
import com.ats.script.Project;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.Action;
import com.ats.script.actions.ActionChannelStart;
import com.ats.script.actions.ActionChannelSwitch;
import com.ats.script.actions.ActionGotoUrl;
import com.ats.script.actions.ActionMouse;
import com.ats.script.actions.ActionMouseDragDrop;
import com.ats.script.actions.ActionMouseKey;
import com.ats.script.actions.ActionMouseScroll;
import com.ats.script.actions.ActionMouseSwipe;
import com.ats.script.actions.ActionScripting;
import com.ats.script.actions.ActionText;
import com.ats.script.actions.ActionWindowResize;
import com.ats.script.actions.ActionWindowState;
import com.ats.script.actions.ActionWindowSwitch;
import com.ats.script.actions.IActionStoppable;
import com.ats.tools.logger.ExecutionLogger;
import com.ats.tools.report.HtmlPlayerReport;
import com.ats.tools.report.XmlReport;
import com.ats.tools.report.utils.ReportImageFormat;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class VisualRecorder
implements IVisualRecorder {
    private static final String ATSV_HTML = "atsv-html";
    private static final String CLEAN_ATSV = "clean-atsv";
    public static final String ENV_ATSV_HTML = "ATSV_HTML";
    private Channel channel;
    private String outputPath;
    private ScriptHeader scriptHeader;
    private int visualQuality = 3;
    private boolean xml = false;
    private boolean atsvHml = false;
    private ReportImageFormat format = null;
    private boolean recording = false;
    private TestSummary summary = new TestSummary();
    private ActionTestScript topScript;
    private ExecutionLogger logger;
    private boolean saveXmlPic = true;

    public VisualRecorder(ActionTestScript topScript, ScriptHeader header, Project project, boolean xml, boolean atsvHml, int quality, ReportImageFormat format, boolean saveXmlPic) {
        this.channel = AtsSingleton.getInstance().getCurrentChannel();
        this.topScript = topScript;
        this.logger = new ExecutionLogger();
        this.atsvHml = atsvHml;
        this.format = format;
        this.saveXmlPic = saveXmlPic;
        Path output = project.getReportFolder().resolve(header.getPackagePath());
        output.toFile().mkdirs();
        this.initAndStart(output, header, xml, quality);
    }

    public VisualRecorder(ActionTestScript topScript, File outputFolder, ScriptHeader header, boolean xml, boolean atsvHml, int quality, ExecutionLogger logger, ReportImageFormat format, boolean saveXmlPic) {
        this.channel = AtsSingleton.getInstance().getCurrentChannel();
        this.topScript = topScript;
        this.logger = logger;
        this.atsvHml = atsvHml;
        this.format = format;
        this.saveXmlPic = saveXmlPic;
        Path output = outputFolder.toPath();
        this.initAndStart(output, header, xml, quality);
    }

    private void initAndStart(Path output, ScriptHeader header, boolean xml, int quality) {
        this.outputPath = output.toFile().getAbsolutePath();
        this.scriptHeader = header;
        this.xml = xml;
        if (quality > 0) {
            this.visualQuality = quality;
        }
    }

    @Override
    public void updateSummary(String testName, int testLine, String data) {
        this.summary.appendData(data);
    }

    @Override
    public void updateSummaryFail(String testName, int testLine, String app, String errorMessage, TestError.TestErrorStatus testErrorStatus) {
        this.summary.setFailData(testName, testLine, errorMessage, testErrorStatus);
    }

    @Override
    public void updateSummaryFailPass(String testName, int testLine, String errorMessage, TestError.TestErrorStatus testErrorStatus) {
        this.summary.addFailPassData(testName, testLine, errorMessage);
    }

    @Override
    public void terminate() {
        if (this.channel != null) {
            Path path = Paths.get(this.outputPath, new String[0]);
            boolean isCommandLineExecution = path.toString().contains("Command line suite");
            this.logger.sendInfo("stop visual recording", this.scriptHeader.getQualifiedName());
            this.channel.stopVisualRecord(this.topScript.getStatus(), this.summary);
            this.channel.saveVisualReportFile(path, this.scriptHeader.getQualifiedName() + ".atsv", this.logger);
            if (Boolean.parseBoolean(System.getProperty(ATSV_HTML)) || this.atsvHml || Boolean.parseBoolean(System.getenv(ENV_ATSV_HTML)) || "1".equals(System.getenv(ENV_ATSV_HTML))) {
                HtmlPlayerReport.createHTMLPlayerReport(this.logger, path, this.scriptHeader.getQualifiedName(), new Path[0]);
            }
            boolean isAtsvExists = Path.of(this.outputPath, new String[0]).resolve(this.scriptHeader.getName() + ".atsv").toFile().exists();
            if (this.xml || isCommandLineExecution || isAtsvExists) {
                XmlReport.createReport(this.topScript, path, this.scriptHeader, this.logger, this.format, Boolean.parseBoolean(System.getProperty(CLEAN_ATSV)), this.saveXmlPic);
            }
        }
    }

    private void setChannel(Channel channel) {
        if (!this.recording && channel != null && !(channel instanceof EmptyChannel)) {
            this.recording = true;
            DesktopResponse resp = channel.startVisualRecord(this.scriptHeader, this.visualQuality, this.topScript.getStarted());
            if (resp != null && resp.getErrorCode() < 0) {
                channel.sendLog(resp.getErrorCode(), "unable to start visual recording", resp.getErrorMessage());
            }
        }
        this.channel = channel;
    }

    private boolean isSyncAction(String actionName) {
        return actionName == ActionMouse.class.getName() || actionName == ActionGotoUrl.class.getName() || actionName == ActionMouseKey.class.getName() || actionName == ActionMouseScroll.class.getName() || actionName == ActionText.class.getName() || actionName == ActionScripting.class.getName() || actionName == ActionWindowState.class.getName() || actionName == ActionWindowSwitch.class.getName() || actionName == ActionMouseDragDrop.class.getName() || actionName == ActionMouseSwipe.class.getName() || actionName == ActionChannelSwitch.class.getName() || actionName == ActionWindowResize.class.getName();
    }

    @Override
    public void createVisualStartChannelAction(ActionChannelStart action, long duration, String scriptName, int scriptLine) {
        this.setChannel(action.getStatus().getChannel());
        this.channel.createVisualAction(true, action, scriptLine, scriptName, this.topScript.getTimeLine() - duration, this.isSyncAction(action.getClass().getName()));
        this.channel.sleep(100);
        this.update(action.getStatus().getCode(), duration, action.getName(), action.getActionData().toString());
    }

    @Override
    public String createVisualAction(Action action, String scriptName, int scriptLine) {
        this.setChannel(action.getStatus().getChannel());
        boolean stop = false;
        if (action instanceof IActionStoppable) {
            stop = ((IActionStoppable)((Object)action)).isStop();
        }
        long timeLine = this.topScript.getTimeLine();
        String uid = this.channel.createVisualAction(stop, action, scriptLine, scriptName, timeLine, this.isSyncAction(action.getClass().getName()));
        return uid;
    }

    @Override
    public void update(int error, long duration, String value, String data) {
        this.channel.updateVisualAction(error, duration, value, data);
    }

    @Override
    public void update(int error, long duration, String value) {
        this.channel.updateVisualAction(error, duration, value);
    }

    @Override
    public void updateScreen(boolean ref) {
        this.channel.sleep(100);
        this.channel.updateVisualAction(ref);
    }

    @Override
    public void update(String value) {
        this.channel.updateVisualAction(value);
    }

    @Override
    public void update(String value, String data) {
        this.channel.updateVisualAction(value, data);
    }

    @Override
    public void update(String type, MouseDirection position) {
        this.channel.updateVisualAction(type, position.getHorizontalPos(), position.getVerticalPos());
    }

    @Override
    public void update(int error, long duration) {
        this.channel.updateVisualAction(error, duration);
    }

    @Override
    public void update(TestElement element) {
        this.channel.updateVisualAction(element);
    }

    @Override
    public void updateScreen(TestElement element) {
        this.channel.updateVisualAction(element);
    }

    @Override
    public void updateScreen(ActionStatus st) {
        this.update(st.getCode(), st.getDuration());
    }

    @Override
    public void updateScreen(ActionStatus st, String value) {
        this.update(st.getCode(), st.getDuration(), value);
    }

    @Override
    public void updateTextScreen(ActionStatus st, String value) {
        this.update(st.getCode(), st.getDuration(), value, st.getMessage());
    }

    @Override
    public void updateScreen(ActionStatus st, String type, MouseDirection position) {
        this.update(st.getCode(), st.getDuration());
        this.update(type, position);
    }

    @Override
    public void update(int error, long duration, TestElement element) {
        this.update(error, duration);
        this.update(element);
    }

    @Override
    public void update(int error, long duration, String value, String data, TestElement element) {
        this.update(error, duration, value, data);
        this.update(element);
    }

    @Override
    public void terminateAsSuite() {
        this.summary.setStatus(2);
    }
}

