/*
 * Decompiled with CFR 0.152.
 */
package com.ats.script.actions;

import com.ats.AtsSingleton;
import com.ats.driver.AtsManager;
import com.ats.element.SearchedElement;
import com.ats.element.test.TestElement;
import com.ats.executor.ActionTestScript;
import com.ats.executor.AtsCallscriptLogs;
import com.ats.executor.channels.Channel;
import com.ats.executor.scripts.AtsCallSubscriptException;
import com.ats.executor.scripts.AtsCallSubscriptJavascript;
import com.ats.executor.scripts.AtsCallSubscriptPython;
import com.ats.executor.scripts.AtsCallSubscriptScript;
import com.ats.generator.variables.CalculatedValue;
import com.ats.generator.variables.TableSplit;
import com.ats.generator.variables.Variable;
import com.ats.generator.variables.parameter.Parameter;
import com.ats.generator.variables.parameter.ParameterDataFile;
import com.ats.generator.variables.parameter.ParameterList;
import com.ats.recorder.VisualAction;
import com.ats.script.AtsScript;
import com.ats.script.Script;
import com.ats.script.ScriptHeader;
import com.ats.script.actions.ActionReturnVariableArray;
import com.ats.script.actions.IActionStoppable;
import com.ats.script.actions.condition.ExecuteOptions;
import com.ats.tools.Utils;
import com.ats.tools.logger.levels.AtsFailError;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.testng.ITestNGListener;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ActionCallscript
extends ActionReturnVariableArray
implements IActionStoppable {
    public static final String SCRIPT_LABEL = "subscript";
    public static final String CALLSCRIPT_LABEL = "callscript";
    public static final String CALL_SUBSCRIPT_LABEL = "call-subscript";
    public static final Predicate<String> PREDICATE_OLD = g -> SCRIPT_LABEL.equals(g);
    public static final Predicate<String> PREDICATE = g -> CALLSCRIPT_LABEL.equals(g);
    public static final Predicate<String> PREDICATE_NEW = g -> CALL_SUBSCRIPT_LABEL.equals(g);
    public static final String RANGE = "range";
    public static final String IF_LABEL = "if(";
    public static final String LOOP = "loop";
    public static final String TABLE = "table";
    public static final Pattern LOOP_REGEXP = Pattern.compile("loop ?\\((\\d+)\\)", 2);
    public static final String ASSETS_PROTOCOLE = "assets:///";
    public static final String FILE_PROTOCOLE = "file://";
    public static final String HTTP_PROTOCOLE = "http://";
    public static final String HTTPS_PROTOCOLE = "https://";
    public static final String JAR_PROTOCOLE = "jar";
    public static final String JAVASCRIPT_PROTOCOLE = "js://";
    public static final String JAVA_PROTOCOLE = "java://";
    public static final String PYTHON_PROTOCOLE = "py://";
    public static final String CS_PROTOCOLE = "cs://";
    private CalculatedValue name;
    private int type = -1;
    private SearchedElement searchElement;
    private ArrayList<Variable> scriptVariables;
    private ParameterList parameters;
    private int loop = 1;
    private CalculatedValue parameterFilePath;
    private boolean suite = false;
    private String range = null;
    private boolean random = false;
    private JsonObject paramsData;
    private TableSplit tableSplit;
    private String calledScript = "";
    private AtsCallscriptLogs calledScriptLogs;

    public ActionCallscript() {
    }

    public ActionCallscript(AtsScript script, ExecuteOptions options, String name, String[] parameters, String[] returnValue, String csvFilePath, ArrayList<String> dataArray) {
        super(script, options);
        String firstParam;
        this.setName(new CalculatedValue(script, name));
        if (csvFilePath != null) {
            this.setParameterFilePath(new CalculatedValue(script, csvFilePath));
        } else if (dataArray != null && dataArray.size() > 0) {
            this.searchElement = new SearchedElement(script, dataArray);
        } else if (parameters.length > 0 && !this.setParameterFilePathData(firstParam = parameters[0].trim())) {
            ArrayList<CalculatedValue> paramsValues = new ArrayList<CalculatedValue>();
            String[] stringArray = parameters;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String param = stringArray[i];
                Matcher match = LOOP_REGEXP.matcher(param = param.replaceAll("\n", ","));
                if (match.find()) {
                    this.loop = Utils.string2Int(match.group(1), 1);
                    continue;
                }
                paramsValues.add(new CalculatedValue(script, param.trim()));
            }
            this.setParameters(paramsValues);
        }
        if (returnValue.length > 0 && this.loop == 1) {
            ArrayList<Variable> variableValues = new ArrayList<Variable>();
            for (String varName : returnValue) {
                variableValues.add(script.getVariable(varName.trim(), true));
            }
            this.setVariables(variableValues);
        }
        options.updateCallScript(this, dataArray, script);
    }

    public ActionCallscript(AtsScript script, ExecuteOptions options, String name, String[] parameters, String[] returnValue, String csvFilePath, ArrayList<String> dataArray, String tableSplit) {
        this(script, options, name, parameters, returnValue, csvFilePath, dataArray);
        if (tableSplit != null) {
            this.setTableSplit(new TableSplit(tableSplit, this.getParameters()));
        }
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name) {
        super(script, options);
        this.setName(name);
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, SearchedElement element) {
        this(script, options, name);
        this.setSearchElement(element);
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, CalculatedValue[] parameters) {
        this(script, options, name);
        this.setParameters(new ArrayList<CalculatedValue>(Arrays.asList(parameters)));
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, Variable ... variables) {
        this(script, options, name);
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, SearchedElement element, Variable ... variables) {
        this(script, options, name);
        this.setSearchElement(element);
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, CalculatedValue[] parameters, Variable ... variables) {
        this(script, options, name);
        this.setParameters(new ArrayList<CalculatedValue>(Arrays.asList(parameters)));
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, boolean random, boolean suite, CalculatedValue csvFilePath, String range) {
        this(script, options, name);
        this.setRandom(random);
        this.setSuite(suite);
        this.setParameterFilePath(csvFilePath);
        this.setRange(range);
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, boolean random, boolean suite, CalculatedValue csvFilePath, String range, Variable ... variables) {
        this(script, options, name);
        this.setRandom(random);
        this.setSuite(suite);
        this.setParameterFilePath(csvFilePath);
        this.setRange(range);
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, CalculatedValue[] parameters, int loop) {
        this(script, options, name, parameters);
        this.setLoop(loop);
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, int loop) {
        this(script, options, name);
        this.setLoop(loop);
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, TableSplit splitter) {
        this(script, options, name);
        this.setTableSplit(splitter);
    }

    public ActionCallscript(Script script, ExecuteOptions options, CalculatedValue name, TableSplit splitter, Variable ... variables) {
        this(script, options, name);
        this.setTableSplit(splitter);
        this.setVariables(new ArrayList<Variable>(Arrays.asList(variables)));
    }

    @Override
    public boolean isStop() {
        return true;
    }

    public static String getScriptLog(String testName, int line, JsonObject log) {
        log.addProperty("name", testName);
        log.addProperty("line", (Number)line);
        StringBuilder sb = new StringBuilder("Subscript").append(" -> ").append(log.toString());
        return sb.toString();
    }

    public boolean isSubscriptCalled(String scriptName) {
        return this.name.getCalculated().equals(scriptName);
    }

    private boolean setParameterFilePathData(String value) {
        if (value != null && (value.startsWith(ASSETS_PROTOCOLE) || value.startsWith(FILE_PROTOCOLE) || value.startsWith(HTTP_PROTOCOLE) || value.startsWith(HTTPS_PROTOCOLE))) {
            this.setParameterFilePath(new CalculatedValue(this.script, value));
            return true;
        }
        return false;
    }

    public void updateTableSplit(String option) {
        if (this.parameters != null) {
            this.setTableSplit(new TableSplit(option, this.parameters));
        }
    }

    @Override
    public StringBuilder getJavaCode() {
        StringBuilder codeBuilder = super.getJavaCode();
        codeBuilder.append(this.name.getJavaCode());
        if (this.parameterFilePath != null) {
            codeBuilder.append(", ").append(this.random).append(", ").append(this.suite).append(", ").append(this.parameterFilePath.getJavaCode()).append(", ");
            if (this.range == null || this.range.isEmpty()) {
                codeBuilder.append("null");
            } else {
                codeBuilder.append("\"").append(this.range).append("\"");
            }
        } else if (this.searchElement != null) {
            codeBuilder.append(", ").append(this.searchElement.getJavaCode());
        } else if (this.tableSplit != null) {
            codeBuilder.append(", ").append(this.tableSplit.getJavaCode());
        } else {
            if (this.parameters != null) {
                this.parameters.appendJavaCode(codeBuilder);
            }
            if (this.loop > 1) {
                codeBuilder.append(", ").append(this.loop);
            }
        }
        if (this.getVariables() != null) {
            StringJoiner joiner = new StringJoiner(", ");
            for (Variable variable : this.getVariables()) {
                joiner.add(variable.getName());
            }
            codeBuilder.append(", ").append(joiner.toString());
        }
        codeBuilder.append(")");
        return codeBuilder;
    }

    @Override
    public ArrayList<String> getKeywords() {
        ArrayList<String> keywords = super.getKeywords();
        keywords.add(this.name.getData());
        if (this.parameterFilePath != null) {
            keywords.add(this.parameterFilePath.getKeywords());
        }
        if (this.searchElement != null) {
            keywords.addAll(this.searchElement.getKeywords());
        }
        return keywords;
    }

    @Override
    public Element getXmlElement(Document document, ScriptHeader header, int index, String errorText) {
        Element e = super.getXmlElement(document, header, index, errorText);
        e.appendChild(document.createElement("value")).setTextContent(this.calledScript);
        Element dataJson = document.createElement("dataJson");
        e.appendChild(dataJson);
        Element param = document.createElement("parameter");
        param.setAttribute("type", "asset");
        if (this.parameterFilePath != null) {
            param.setAttribute("value", this.parameterFilePath.getCalculated());
        }
        dataJson.appendChild(param);
        return e;
    }

    @Override
    public VisualAction getVisualAction() {
        return new VisualAction(this, this.timeLine, this.calledScript, this.parameterFilePath);
    }

    private URL loopAssetsFiles(File[] files, String path) {
        if (files != null) {
            for (File f : files) {
                if (f == null || !f.canRead()) continue;
                if (f.isDirectory()) {
                    return this.loopAssetsFiles(f.listFiles(), path);
                }
                if (!f.isFile() || !f.getPath().toLowerCase().endsWith(path)) continue;
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private URL getAssetDataFile(String path) {
        return this.loopAssetsFiles(new File(this.getClass().getClassLoader().getResource("assets").getPath()).listFiles(), path.replace("\\", File.separator).replace("/", File.separator).toLowerCase());
    }

    private ActionTestScript getNewAtsInstance(Class<ActionTestScript> clazz, ActionTestScript topScript, String scriptName, String scriptCode) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ActionTestScript ats = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (scriptCode != null && ats instanceof AtsCallSubscriptScript) {
            ((AtsCallSubscriptScript)ats).setScripCode(scriptCode);
        }
        ats.setTopScript(topScript, scriptName);
        return ats;
    }

    private String getScriptCode(ActionTestScript ts, String testName, String scriptType) {
        int lastDot = this.calledScript.lastIndexOf(".");
        String scriptExtension = this.calledScript.substring(lastDot);
        String scriptPath = this.calledScript.substring(0, lastDot).replace(".", "/");
        String result = null;
        String scriptSourcePath = Paths.get("", new String[0]).toAbsolutePath().resolve("src").resolve("main").resolve(scriptType).resolve(scriptPath + scriptExtension).toString();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(scriptSourcePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(AtsManager.SCRIPTS_FOLDER_URL + "/" + scriptType + "/" + this.calledScript);
        }
        if (inputStream == null) {
            String errorMessage = "Script file not found -> " + scriptSourcePath;
            this.status.setError(422, errorMessage);
            this.status.endDuration();
            ts.callScriptFailed(testName, this.line, 422, errorMessage);
            throw new AtsCallSubscriptException(errorMessage);
        }
        try {
            result = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public String getCalledScriptLogs() {
        if (this.calledScriptLogs != null) {
            return this.calledScriptLogs.terminate();
        }
        return "";
    }

    @Override
    public void execute(ActionTestScript ts, String testName, int line, int tryNum) {
        block50: {
            super.execute(ts, testName, line, 0);
            this.status.setNoError();
            this.calledScript = this.name.getCalculated().replace("\n", "");
            this.calledScriptLogs = null;
            String scriptCode = null;
            Class<ActionTestScript> clazz = null;
            if (this.calledScript.startsWith(JAVASCRIPT_PROTOCOLE) || this.calledScript.startsWith(PYTHON_PROTOCOLE) || this.calledScript.startsWith(CS_PROTOCOLE)) {
                if (this.calledScript.startsWith(JAVASCRIPT_PROTOCOLE)) {
                    this.calledScript = this.calledScript.substring(JAVASCRIPT_PROTOCOLE.length()) + ".js";
                    scriptCode = this.getScriptCode(ts, testName, "javascript");
                    clazz = AtsSingleton.getInstance().loadTestScriptClass(this.status, AtsCallSubscriptJavascript.class.getCanonicalName());
                    this.calledScriptLogs = new AtsCallscriptLogs();
                } else if (this.calledScript.startsWith(PYTHON_PROTOCOLE)) {
                    this.calledScript = this.calledScript.substring(PYTHON_PROTOCOLE.length()) + ".py";
                    scriptCode = this.getScriptCode(ts, testName, "python");
                    clazz = AtsSingleton.getInstance().loadTestScriptClass(this.status, AtsCallSubscriptPython.class.getCanonicalName());
                    this.calledScriptLogs = new AtsCallscriptLogs();
                }
            } else {
                if (this.calledScript.startsWith(JAVA_PROTOCOLE)) {
                    this.calledScript = this.calledScript.substring(JAVA_PROTOCOLE.length());
                    this.calledScriptLogs = new AtsCallscriptLogs();
                }
                clazz = AtsSingleton.getInstance().loadTestScriptClass(this.status, this.calledScript);
            }
            if (!this.status.isPassed() || clazz == null) {
                ts.callScriptFailed(testName, line, this.status.getCode(), this.status.getFailMessage());
                return;
            }
            if (this.getVariables() != null) {
                this.getVariables().forEach(v -> v.clean());
            }
            this.getCurrentChannel().updateVisualCallScript(this.calledScript, ts.getRecorder(), this, testName, line);
            this.addParamsToData(ts);
            ActionTestScript topScript = ts.getTopScript();
            try {
                if (this.parameterFilePath != null) {
                    String errorMessage;
                    String csvPath = this.parameterFilePath.getCalculated().replace("\\", "/");
                    URL csvUrl = null;
                    if (csvPath.startsWith(ASSETS_PROTOCOLE)) {
                        Object csvFilePath = csvPath.replace(ASSETS_PROTOCOLE, "");
                        csvUrl = this.getAssetDataFile((String)csvFilePath);
                        if (csvUrl == null) {
                            csvFilePath = "assets/" + (String)csvFilePath;
                            csvUrl = this.getClass().getClassLoader().getResource((String)csvFilePath);
                            if (csvUrl == null && (csvUrl = this.getClass().getClassLoader().getResource((String)csvFilePath + ".csv")) == null) {
                                csvUrl = this.getClass().getClassLoader().getResource((String)csvFilePath + ".json");
                            }
                        }
                    } else {
                        try {
                            csvUrl = new URI(csvPath).toURL();
                        }
                        catch (MalformedURLException | URISyntaxException csvFilePath) {
                            // empty catch block
                        }
                    }
                    this.getCurrentChannel().updateRecorderFilePathData(ts, this.calledScript, this.paramsData, csvPath);
                    if (csvUrl == null) {
                        String errorMessage2 = "Parameter data file not found -> " + csvPath;
                        this.status.setError(-20, errorMessage2);
                        this.status.endDuration();
                        ts.callScriptFailed(testName, line, -20, errorMessage2);
                        return;
                    }
                    if (csvPath.startsWith(FILE_PROTOCOLE)) {
                        try {
                            File f = new File(csvUrl.toURI());
                            if (!f.isFile()) {
                                errorMessage = "URL path is not a file -> " + csvPath;
                                this.status.setError(-20, (String)errorMessage + "\n");
                                ts.callScriptFailed(testName, line, -20, errorMessage);
                            }
                        }
                        catch (IllegalArgumentException | URISyntaxException e1) {
                            errorMessage = "URL path is not valid -> " + String.valueOf(e1);
                            this.status.setError(-20, errorMessage + "\n");
                            ts.callScriptFailed(testName, line, -20, errorMessage);
                        }
                    }
                    ParameterDataFile data = Utils.loadData(this.status, csvUrl);
                    if (this.status.isPassed()) {
                        String csvAbsoluteFilePath = null;
                        try {
                            csvAbsoluteFilePath = csvPath.startsWith(HTTP_PROTOCOLE) || csvPath.startsWith(HTTPS_PROTOCOLE) ? csvUrl.toString() : (JAR_PROTOCOLE.equals(csvUrl.getProtocol()) ? csvUrl.toString() : new File(csvUrl.toURI()).getAbsolutePath());
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            // empty catch block
                        }
                        this.getCurrentChannel().updateRecorderFilePathData(ts, this.calledScript, this.paramsData, csvPath);
                        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
                        if (this.range != null) {
                            String[] rangeData = this.range.split(";");
                            for (String singleRange : rangeData) {
                                int mainIndex;
                                String[] singleRangeData = singleRange.split("-");
                                if (singleRangeData.length > 1) {
                                    int firstIndex = Utils.string2Int(singleRangeData[0], 0);
                                    int lastIndex = Utils.string2Int(singleRangeData[1], 0);
                                    if (firstIndex <= 0 || lastIndex <= 0) continue;
                                    if (firstIndex == lastIndex) {
                                        selectedIndexes.add(firstIndex);
                                        continue;
                                    }
                                    if (firstIndex >= lastIndex) continue;
                                    for (int i = firstIndex; i <= lastIndex; ++i) {
                                        selectedIndexes.add(i);
                                    }
                                    continue;
                                }
                                if (singleRangeData.length != 1 || (mainIndex = Utils.string2Int(singleRangeData[0], 0)) <= 0) continue;
                                selectedIndexes.add(mainIndex);
                            }
                        }
                        ArrayList<ParameterList> selectedParameters = new ArrayList<ParameterList>();
                        if (!selectedIndexes.isEmpty()) {
                            Iterator iterator = selectedIndexes.iterator();
                            while (iterator.hasNext()) {
                                int index = (Integer)iterator.next();
                                if (index > data.getData().size()) continue;
                                ParameterList params = data.getData().get(index - 1);
                                selectedParameters.add(params);
                            }
                        } else {
                            selectedParameters.addAll(data.getData());
                        }
                        if (this.random) {
                            ParameterList randomParam = (ParameterList)selectedParameters.get((int)(Math.random() * (double)selectedParameters.size()));
                            selectedParameters.clear();
                            selectedParameters.add(randomParam);
                        }
                        int iterationsCount = selectedParameters.size();
                        int iteration = 1;
                        if (this.suite) {
                            topScript.stopRecorder(true);
                            Path outputDirectory = topScript.getSuiteOutputPath().getParent();
                            String suiteName = ActionCallscript.getSuiteName(1, outputDirectory, this.calledScript);
                            Map<String, String> suiteParameters = topScript.getTestExecutionVariables();
                            suiteParameters.put("ats-callscript-iteration", testName + ":" + line);
                            suiteParameters.put("ats-callscript-parameters", csvPath);
                            suiteParameters.putAll(AtsSingleton.getInstance().getGlobalVariables());
                            XmlSuite suite = new XmlSuite();
                            suite.setName(suiteName);
                            suite.setParameters(suiteParameters);
                            for (ParameterList params : selectedParameters) {
                                XmlTest xmlTest = new XmlTest(suite);
                                xmlTest.setName("iter" + iteration);
                                xmlTest.addParameter("ats-iteration", String.valueOf(iteration));
                                int loop = 0;
                                for (Parameter param : params.getList()) {
                                    param.updateCalculated(ts);
                                    xmlTest.addParameter("#" + loop, param.getCalculated());
                                    xmlTest.addParameter(param.getName(), param.getCalculated());
                                    ++loop;
                                }
                                xmlTest.setXmlClasses(new ArrayList<XmlClass>(Arrays.asList(new XmlClass(this.calledScript))));
                                ++iteration;
                            }
                            suite.setVerbose(Integer.valueOf(topScript.getVerbosity()));
                            TestNG tng = new TestNG();
                            tng.setUseDefaultListeners(false);
                            tng.addListener((ITestNGListener)new TestListenerAdapter());
                            tng.setOutputDirectory(outputDirectory.toAbsolutePath().toString());
                            tng.setXmlSuites(new ArrayList<XmlSuite>(Arrays.asList(suite)));
                            tng.setDefaultSuiteName("Callscript as a suite -> " + suiteName);
                            tng.run();
                            topScript.setTestList(tng.getTestListeners());
                        } else {
                            Method tc = clazz.getDeclaredMethod("testMain", new Class[0]);
                            ActionTestScript ats = this.getNewAtsInstance(clazz, topScript, this.calledScript, scriptCode);
                            String[] returns = null;
                            for (ParameterList row : selectedParameters) {
                                this.callScriptWithParametersFile(tc, ats, ts, testName, line, row, this.getVariables(), iteration, iterationsCount, this.calledScript, csvAbsoluteFilePath);
                                ++iteration;
                                returns = ats.getReturnValues();
                            }
                            this.status.setData(returns);
                        }
                        break block50;
                    }
                    errorMessage = "URL path is not valid -> " + csvPath;
                    this.status.setError(-20, errorMessage + "\n");
                    ts.callScriptFailed(testName, line, -20, errorMessage);
                    break block50;
                }
                ActionTestScript ats = this.getNewAtsInstance(clazz, topScript, this.calledScript, scriptCode);
                Method mainFunc = clazz.getDeclaredMethod("testMain", new Class[0]);
                if (this.searchElement != null) {
                    List<ParameterList> data = ActionCallscript.getCallScriptElementData(ts, AtsSingleton.getInstance().getCurrentChannel(), this.searchElement);
                    int iterationMax = data.size();
                    if (data.size() == 0) {
                        String errorMessage = "callscript failed: no element found";
                        this.status.setError(-1, "callscript failed: no element found\n");
                        ts.callScriptFailed(testName, line, -1, "callscript failed: no element found");
                        throw new AtsCallSubscriptException("callscript failed: no element found");
                    }
                    for (int iteration = 1; iteration <= iterationMax; ++iteration) {
                        ats.initCalledScript(this, ts, testName, line, data.get(iteration - 1), this.getVariables(), iteration, iterationMax, this.calledScript, LOOP, null);
                        mainFunc.invoke((Object)ats, new Object[0]);
                    }
                } else if (this.tableSplit != null) {
                    List<ParameterList> data = this.tableSplit.getData();
                    int iterationMax = data.size();
                    for (int iteration = 1; iteration <= iterationMax; ++iteration) {
                        ats.initCalledScript(this, ts, testName, line, data.get(iteration - 1), this.getVariables(), iteration, iterationMax, this.calledScript, TABLE, null);
                        mainFunc.invoke((Object)ats, new Object[0]);
                    }
                } else {
                    for (int iteration = 1; iteration <= this.loop; ++iteration) {
                        ats.initCalledScript(this, ts, testName, line, this.parameters, this.getVariables(), iteration, this.loop, this.calledScript, LOOP, null);
                        mainFunc.invoke((Object)ats, new Object[0]);
                    }
                }
                this.status.setData(ats.getReturnValues());
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
                ts.callScriptFailed(testName, line, -99, e.getMessage());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof AtsFailError) {
                    AtsFailError target = (AtsFailError)((Object)e.getTargetException());
                    ts.callScriptFailed(testName, line, -99, target.getInfo());
                    this.status.setError(-25, target.getFullMessage(ts.getLogger()));
                }
                if (e.getTargetException() instanceof AtsCallSubscriptException) {
                    AtsCallSubscriptException target = (AtsCallSubscriptException)e.getTargetException();
                    this.status.setError(-18, target.getMessage() + "\n");
                }
                String errorMessage = Utils.getCauseStackTraceString(e, "");
                this.status.setError(-18, errorMessage + "\n");
                ts.callScriptFailed(testName, line, -18, errorMessage);
            }
        }
        this.status.endDuration();
    }

    private static String getSuiteName(int i, Path folder, String name) {
        String suiteName = name + "-suite" + i;
        if (folder.resolve(suiteName).toFile().exists()) {
            return ActionCallscript.getSuiteName(i + 1, folder, name);
        }
        return suiteName;
    }

    public static List<ParameterList> getCallScriptElementData(ActionTestScript script, Channel channel, SearchedElement element) {
        TestElement testElement = new TestElement(script, channel, 10, p -> p > 0, element);
        for (int max = 10; max > 0 && testElement.getCount() == 0; --max) {
            channel.sleep(500);
            testElement = new TestElement(script, channel, 10, p -> p > 0, element);
        }
        channel.updateVisualAction(testElement);
        if (testElement.getCount() > 0) {
            return testElement.getTextData();
        }
        return Collections.emptyList();
    }

    private void callScriptWithParametersFile(Method mainFunc, ActionTestScript ats, ActionTestScript atsCaller, String testName, int line, ParameterList row, List<Variable> variables, int iteration, int iterationsCount, String scriptName, String csvAbsoluteFilePath) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        row.updateCalculated(atsCaller);
        ats.initCalledScript(this, atsCaller, testName, line, row, variables, iteration, iterationsCount, scriptName, "dataFile", csvAbsoluteFilePath);
        mainFunc.invoke((Object)ats, new Object[0]);
    }

    @Override
    public StringBuilder getActionLogs(String scriptName, int scriptLine, JsonObject data) {
        data.addProperty("status", "terminated");
        return super.getActionLogs(scriptName, scriptLine, data);
    }

    public void addParamsToData(ActionTestScript ts) {
        ParameterList paramsList;
        if (this.paramsData == null) {
            this.paramsData = new JsonObject();
        }
        if ((paramsList = this.getParameters()) != null && paramsList.getParametersSize() > 0) {
            String[] paramsArray = paramsList.getParameters();
            for (int ind = 0; ind < paramsList.getParametersSize(); ++ind) {
                this.paramsData.addProperty(Integer.toString(ind), paramsArray[ind]);
            }
            this.getCurrentChannel().updateRecorderData(ts, this.calledScript, this.paramsData);
        }
    }

    public CalculatedValue getName() {
        return this.name;
    }

    public void setName(CalculatedValue name) {
        this.name = name;
    }

    @Override
    public void setVariables(ArrayList<Variable> value) {
        if (value != null && value.size() > 0) {
            super.setVariables(value);
        }
    }

    public ParameterList getParameters() {
        return this.parameters;
    }

    public void setParameters(ParameterList value) {
        if (value != null && value.getParametersSize() > 0) {
            this.parameters = value;
            this.parameterFilePath = null;
        }
    }

    public void setParameters(ArrayList<CalculatedValue> calcs) {
        this.parameters = new ParameterList(1);
        int i = 0;
        for (CalculatedValue calc : calcs) {
            this.parameters.addParameter(new Parameter(i, calc));
            ++i;
        }
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int loop) {
        if (loop <= 0) {
            loop = 1;
        }
        if (loop > 1) {
            this.parameterFilePath = null;
        }
        this.loop = loop;
    }

    public SearchedElement getSearchElement() {
        return this.searchElement;
    }

    public void setSearchElement(SearchedElement value) {
        this.searchElement = value;
    }

    public boolean isSuite() {
        return this.suite;
    }

    public void setSuite(boolean suite) {
        this.suite = suite;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String value) {
        this.range = value;
    }

    public boolean isRandom() {
        return this.random;
    }

    public void setRandom(boolean random) {
        this.random = random;
    }

    public CalculatedValue getParameterFilePath() {
        return this.parameterFilePath;
    }

    public void setParameterFilePath(CalculatedValue value) {
        this.parameterFilePath = value;
        if (value != null) {
            this.parameters = null;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ArrayList<Variable> getScriptVariables() {
        return this.scriptVariables;
    }

    public void setScriptVariables(ArrayList<Variable> scriptVariable) {
        this.scriptVariables = scriptVariable;
    }

    public static StringBuilder getAtsCodeStr() {
        return new StringBuilder().append(SCRIPT_LABEL).append(" -> ");
    }

    public TableSplit getTableSplit() {
        return this.tableSplit;
    }

    public void setTableSplit(TableSplit value) {
        this.tableSplit = value;
        if (value != null) {
            this.parameters = null;
        }
    }
}

