/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.general;

import com.ats.script.Project;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.SuiteInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HtmlReportPlaylist {
    public static final String PLAYLIST_INFO_ONLY_CSS = "playlist-info-only";
    public static final String PLAYLIST_INFO_DATA_FRAME_WITH_HEADER_CSS = "playlist-info-data-frame-with-header";
    public static final String PLAYLIST_INFO_DATA_FRAME_WITH_HEADER_WIDTH_100_CSS = "playlist-info-data-frame-with-header width-100";
    public static final String GROUP_FILTERS_CSS = "group-filters";
    private final String PLAYLIST_NAME = "${playlistName}";
    private final String PLAYLIST_NAME_URI = "${playlistNameUri}";
    private final String PLAYLIST_TESTS_PASSED = "${playlistTestsPassed}";
    private final String PLAYLIST_TESTS_FAILED = "${playlistTestsFailed}";
    private final String PLAYLIST_TESTS_FILTERED = "${playlistTestsFiltered}";
    private final String PLAYLIST_EXECUTION_TIME_SEC = "${playlistExecutionTimeSec}";
    private final String PLAYLIST_EXECUTION_TIME_MIN = "${playlistExecutionTimeMin}";
    private final String PLAYLIST_EXECUTION_TIME_HRS = "${playlistExecutionTimeHrs}";
    private final String PLAYLIST_DESCRIPTION = "${playlistDescription}";
    private final String PLAYLIST_PARAMETERS = "${playlistParameters}";
    private final String PLAYLIST_GROUPS_INCLUDED = "${playlistGroupsIncluded}";
    private final String PLAYLIST_GROUPS_EXCLUDED = "${playlistGroupsExcluded}";
    private final String PLAYLIST_EXECUTION_RESULT = "result-pass-icon-transparent";
    private final String PLAYLIST_EXECUTION_DETAILS = "suite-execution-details";
    private final String GROUP_DISPLAY_PLACEHOLDER_NOT_EXECUTE = "${donotexecutedisplayplaceholder}";
    private final String GROUP_DISPLAY_PLACEHOLDER_EXECUTE = "${executedisplayplaceholder}";
    private final List<Script> scripts;
    public static final String PLAYLIST_NAME_HTML_TEMPLATE = "<a style='color: white;display: flex;align-items: center;' class='hover-underline' href='ats://${playlistNameUri}' target='_self'><div class='external-link-icon external-link-icon-large'></div><div style='font-weight: 100; color: rgba(194, 200, 209)'>Playlist:&nbsp;</div><div class='playlist-info-name-text'>${playListName}</div></a>";
    public static final String GROUP_NAME_HTML_TEMPLATE = "<a style='text-decoration: none; color: rgba(56, 63, 79, 1); display: flex;' href='ats://${groupUri}' target='_self'><div class='external-link-icon'></div>${groupName}</a>";
    private final String PLAYLIST_PARAMETER_HTML_TEMPLATE = "<div class=\"playlist-parameter\">\n                            <div class=\"pp-title\">${title}</div>\n                            <div class=\"pp-value\">${value}</div>\n                        </div>";
    public static final String GROUP_TEMPLATE = "<div class='item-with-frame hover-underline'>${groupWithUri}</div>";
    private final boolean isValidationReport;
    private Suite suite;
    private String playlistTemplate;
    private String result;
    private OutputStream fileWriter;
    private OutputStream validationFileWriter;
    private HtmlReportProject project;
    private boolean isNoSuiteLunch;
    private boolean isCommandLineExecution;
    private String scriptsStatus;
    private long passed = 0L;
    private long failed = 0L;
    private long filtered = 0L;
    private long durationInSecond = 0L;

    public HtmlReportPlaylist(String playlistTemplate, Suite suite, OutputStream fileWriter, OutputStream validationFileWriter, HtmlReportProject project, List<Script> scripts, boolean isValidationReport, boolean noSuiteLaunch, String scriptsStatus) {
        this.suite = suite;
        this.playlistTemplate = playlistTemplate;
        this.fileWriter = fileWriter;
        this.validationFileWriter = validationFileWriter;
        this.project = project;
        this.scripts = scripts;
        this.isValidationReport = isValidationReport;
        this.isNoSuiteLunch = noSuiteLaunch;
        this.isCommandLineExecution = suite.getName().toLowerCase().contains("command line suite");
        this.scriptsStatus = scriptsStatus;
    }

    public void processPlaylistFooter() {
        try {
            this.fileWriter.write("</div></div></div>".getBytes());
            if (this.isValidationReport) {
                this.validationFileWriter.write("</div></div></div>".getBytes());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processPlaylistData() {
        this.passed = this.scripts.stream().filter(Script::isPassed).count();
        this.failed = this.scripts.stream().filter(script -> !script.isPassed()).count();
        this.filtered = (long)this.suite.getTests().size() - this.passed - this.failed;
        this.result = StringUtils.replace((String)this.playlistTemplate, (String)"${playlistName}", (String)this.suite.getName());
        this.result = this.result.replace("${playlistNameUri}", this.buildPlaylistName(this.suite));
        this.result = this.result.replace("${playlistTestsPassed}", String.valueOf(this.passed));
        this.result = this.result.replace("${playlistTestsFailed}", String.valueOf(this.failed));
        this.result = this.result.replace("${playlistTestsFiltered}", String.valueOf(this.filtered));
        if (this.suite.getSuiteInfo() == null) {
            SuiteInfo suiteInfo = new SuiteInfo();
            suiteInfo.setDuration(0L);
            suiteInfo.setStatus("");
            this.suite.setSuiteInfo(suiteInfo);
        }
        if (!(this.isCommandLineExecution || this.suite.getSuiteInfo().getStatus().equals(this.scriptsStatus) && !this.testsCountsMismatch(this.suite, this.scripts))) {
            this.suite.setDescription("<div class='inconsistency-warning'><div class='warning-icon'></div><div>Inconsistency in execution results has been found! Please contact support.</div></div>" + this.suite.getDescription());
        }
        if (this.isNoSuiteLunch && this.isCommandLineExecution) {
            this.result = this.result.replace("suite-execution-details", "display-none");
            if (!this.suite.getDescription().contains("<div class='inconsistency-warning'><div class='warning-icon'></div><div>Inconsistency in execution results has been found! Please contact support.</div></div>")) {
                this.result = this.result.replace(PLAYLIST_INFO_ONLY_CSS, "display-none");
            }
            this.result = this.result.replace(GROUP_FILTERS_CSS, "display-none");
            this.result = this.result.replace(PLAYLIST_INFO_DATA_FRAME_WITH_HEADER_CSS, PLAYLIST_INFO_DATA_FRAME_WITH_HEADER_WIDTH_100_CSS);
            this.suite.setParameters(this.buildParametersForNoSuiteLunch());
        }
        this.durationInSecond = this.suite.getSuiteInfo().getDuration() / 1000L;
        this.result = this.result.replace("${playlistExecutionTimeSec}", this.suite.getSuiteInfo().getDuration() / 1000L % 60L + " sec");
        this.result = this.result.replace("${playlistExecutionTimeMin}", this.suite.getSuiteInfo().getDuration() / 1000L % 3600L / 60L + " min");
        this.result = this.result.replace("${playlistExecutionTimeHrs}", this.suite.getSuiteInfo().getDuration() / 3600000L + " hr");
        this.result = this.result.replace("${playlistDescription}", this.suite.getDescription());
        this.result = this.result.replace("${playlistParameters}", this.processParameters(this.suite.getParameters()));
        CharSequence includedGroupsString = this.processGroups(this.suite.getIncludedGroups());
        CharSequence excludedGroupsString = this.processGroups(this.suite.getExcludedGroups());
        this.result = this.result.replace("${executedisplayplaceholder}", this.buildDisplayGroupsBlockProperty(includedGroupsString));
        this.result = this.result.replace("${donotexecutedisplayplaceholder}", this.buildDisplayGroupsBlockProperty(excludedGroupsString));
        this.result = this.result.replace("${playlistGroupsIncluded}", includedGroupsString);
        this.result = this.result.replace("${playlistGroupsExcluded}", excludedGroupsString);
        if (this.suite.getSuiteInfo() == null || !this.suite.getSuiteInfo().getStatus().equals("PASS")) {
            this.result = this.result.replace("result-pass-icon-transparent", "result-failed-icon-transparent");
        }
        try {
            this.fileWriter.write(this.result.getBytes());
            if (this.isValidationReport) {
                this.validationFileWriter.write(this.result.getBytes());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean testsCountsMismatch(Suite suite, List<Script> scripts) {
        if (suite.getSuiteInfo().getTestsFiltered() != 0) {
            // empty if block
        }
        List filteredScripts = scripts.stream().filter(script -> script.getSuite().equals(suite.getName())).collect(Collectors.toList());
        long passedScriptsCount = filteredScripts.stream().filter(Script::isPassed).count();
        long failedScriptsCount = filteredScripts.stream().filter(script -> !script.isPassed()).count();
        boolean isPassedMismatch = (long)suite.getSuiteInfo().getTestsPassed() != passedScriptsCount;
        boolean isFailedMismatch = (long)suite.getSuiteInfo().getTestsFailed() != failedScriptsCount;
        return isPassedMismatch || isFailedMismatch;
    }

    private Map<String, String> buildParametersForNoSuiteLunch() {
        ArrayList<String> parametersNames = new ArrayList<String>();
        HashMap<String, String> parameters = new HashMap<String, String>();
        NodeList nodeList = null;
        try {
            nodeList = Project.getProjectProperties().getElementsByTagName("environment");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
        Node node = nodeList.item(0);
        if (node.getNodeType() == 1) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1) continue;
                parametersNames.add(child.getTextContent().trim());
            }
        }
        parametersNames.forEach(parameterName -> parameters.put((String)parameterName, System.getProperty(parameterName)));
        parameters.entrySet().removeIf(stringStringEntry -> stringStringEntry.getValue() == null);
        return parameters;
    }

    private CharSequence buildDisplayGroupsBlockProperty(CharSequence groups) {
        return StringUtils.isEmpty((CharSequence)groups) ? "style='display: none;'" : "";
    }

    private CharSequence buildPlaylistName(Suite suite) {
        return this.isNoSuiteLunch && this.isCommandLineExecution ? "Single test execution" : PLAYLIST_NAME_HTML_TEMPLATE.replace("${playlistNameUri}", this.project.getProjectUuid() + "/exec/" + suite.getName()).replace("${playListName}", suite.getName());
    }

    private CharSequence buildGroupWithUri(String group) {
        return GROUP_NAME_HTML_TEMPLATE.replace("${groupUri}", this.project.getProjectUuid() + "/group/" + group).replace("${groupName}", group);
    }

    public void processPlaylistTestInfo(String testInfo) {
        try {
            String finalTestInfo = testInfo.replace("class='general-report-layout-single'", "class='general-report-layout'");
            this.fileWriter.write(finalTestInfo.getBytes());
            if (this.isValidationReport) {
                this.validationFileWriter.write(finalTestInfo.getBytes());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processPlaylistTestAction(String testAction, boolean isValidationReportEnabled, boolean writeAction) {
        try {
            this.fileWriter.write(testAction.getBytes());
            if (isValidationReportEnabled && writeAction) {
                this.validationFileWriter.write(testAction.getBytes());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CharSequence processGroups(List<String> groups) {
        return groups.stream().map(group -> GROUP_TEMPLATE.replace("${groupWithUri}", this.buildGroupWithUri((String)group))).collect(Collectors.joining());
    }

    private CharSequence processParameters(Map<String, String> parameters) {
        return parameters.entrySet().stream().map(stringStringEntry -> {
            String parametersHtml = "<div class=\"playlist-parameter\">\n                            <div class=\"pp-title\">${title}</div>\n                            <div class=\"pp-value\">${value}</div>\n                        </div>".replace("${title}", (CharSequence)stringStringEntry.getKey());
            parametersHtml = parametersHtml.replace("${value}", (CharSequence)stringStringEntry.getValue());
            return parametersHtml;
        }).collect(Collectors.joining());
    }

    public void processTestCaseFooter() throws IOException {
        this.fileWriter.write("</div></div></div></div></div>".getBytes());
        if (this.isValidationReport) {
            this.validationFileWriter.write("</div></div></div></div></div>".getBytes());
        }
    }

    public long getPassed() {
        return this.passed;
    }

    public long getFailed() {
        return this.failed;
    }

    public long getFiltered() {
        return this.filtered;
    }

    public long getDurationInSecond() {
        return this.durationInSecond;
    }
}

