/*
 * Decompiled with CFR 0.152.
 */
package com.ats.tools.report.utils;

import com.ats.generator.ATS;
import com.ats.script.Project;
import com.ats.tools.logger.levels.AtsLogger;
import com.ats.tools.report.models.HtmlReportProject;
import com.ats.tools.report.models.Results;
import com.ats.tools.report.models.Script;
import com.ats.tools.report.models.Suite;
import com.ats.tools.report.models.Summary;
import com.ats.tools.report.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class AtsReportXmlGenerator {
    private XMLStreamWriter xmlStreamWriter;
    private FileOutputStream fileOutputStream;
    private XMLOutputFactory outputFactory;
    private List<Summary> testSummaries;
    private HtmlReportProject project;
    private Results results;
    private List<Script> scripts;
    private int devReportLevel;
    private Path outputFolderPath;
    private int validReportLevel;
    private List<Summary> testSummariesForExecution;
    private String outputFilename;

    public AtsReportXmlGenerator(HtmlReportProject project, Results results, List<Script> scripts, int devReportLevel, Path outputFolderPath, int validReportLevel, String outputFilename) {
        this.project = project;
        this.results = results;
        this.scripts = scripts;
        this.devReportLevel = devReportLevel;
        this.outputFolderPath = outputFolderPath;
        this.validReportLevel = validReportLevel;
        this.testSummariesForExecution = this.getTestSummariesForExecutions(outputFolderPath, project.getSuites());
        this.outputFilename = outputFilename;
    }

    public void writeProjectInfo() throws FileNotFoundException, XMLStreamException {
        this.initialize(this.outputFolderPath);
        this.testSummaries = this.testSummariesForExecution;
        long testsFailed = this.scripts.stream().filter(script -> !script.isPassed()).count();
        long testsPassed = this.scripts.stream().filter(Script::isPassed).count();
        String base64LogoProperty = FileUtils.getBase64ImageProperty(Project.REPORT_LOGO_URL, this.project, this.outputFolderPath.toString());
        int actionsCount = this.testSummariesForExecution.stream().mapToInt(summary -> Integer.parseInt(summary.getActions())).sum();
        this.xmlStreamWriter.writeStartDocument();
        this.xmlStreamWriter.writeStartElement("ats-report");
        this.xmlStreamWriter.writeAttribute("actions", Integer.toString(actionsCount));
        this.xmlStreamWriter.writeAttribute("atsVersion", ATS.getAtsVersion());
        this.xmlStreamWriter.writeAttribute("devReportLevel", String.valueOf(this.devReportLevel));
        this.xmlStreamWriter.writeAttribute("duration", String.valueOf(this.results.getDuration()));
        this.xmlStreamWriter.writeAttribute("path", "file:" + File.separator + String.valueOf(this.outputFolderPath));
        this.xmlStreamWriter.writeAttribute("projectDescription", this.project.getProjectDescription());
        this.xmlStreamWriter.writeAttribute("projectId", this.project.getProjectId());
        this.xmlStreamWriter.writeAttribute("projectName", this.project.getProjectName());
        this.xmlStreamWriter.writeAttribute("projectUuid", this.project.getProjectUuid());
        this.xmlStreamWriter.writeAttribute("projectVersion", this.project.getProjectVersion());
        this.xmlStreamWriter.writeAttribute("started", String.valueOf(this.project.getStarted()));
        this.xmlStreamWriter.writeAttribute("startedFormated", this.project.getStartedFormatted());
        this.xmlStreamWriter.writeAttribute("startedFormatedZulu", this.project.getStartedFormattedZulu());
        this.xmlStreamWriter.writeAttribute("suitesCount", String.valueOf(this.results.getSuitesCount()));
        this.xmlStreamWriter.writeAttribute("suitesPassed", String.valueOf(this.results.getSuitesPassed()));
        this.xmlStreamWriter.writeAttribute("tests", String.valueOf(testsFailed + testsPassed));
        this.xmlStreamWriter.writeAttribute("testsFailed", String.valueOf(testsFailed));
        this.xmlStreamWriter.writeAttribute("testsPassed", String.valueOf(testsPassed));
        this.xmlStreamWriter.writeAttribute("validReportLevel", String.valueOf(this.validReportLevel));
        this.xmlStreamWriter.writeStartElement("pics");
        this.xmlStreamWriter.writeStartElement("pic");
        this.xmlStreamWriter.writeAttribute("name", "logo");
        this.xmlStreamWriter.writeCharacters(base64LogoProperty);
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeStartElement("pic");
        this.xmlStreamWriter.writeAttribute("name", "true");
        this.xmlStreamWriter.writeCharacters(this.project.getICON_TRUE());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeStartElement("pic");
        this.xmlStreamWriter.writeAttribute("name", "false");
        this.xmlStreamWriter.writeCharacters(this.project.getICON_FALSE());
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.flush();
    }

    public void writeSuiteData(Suite suite, List<Script> scripts) {
        List suiteScripts = scripts.stream().filter(script -> script.getSuite().equals(suite.getName())).collect(Collectors.toList());
        long scriptsPassed = suiteScripts.stream().filter(Script::isPassed).count();
        long scriptsFailed = suiteScripts.stream().filter(script -> !script.isPassed()).count();
        int suiteActionsCount = this.testSummaries.stream().filter(summary -> summary.getSuiteName().equals(suite.getName())).mapToInt(summary -> Integer.parseInt(summary.getActions())).sum();
        try {
            this.xmlStreamWriter.writeStartElement("suite");
            this.xmlStreamWriter.writeAttribute("actions", String.valueOf(suiteActionsCount));
            this.xmlStreamWriter.writeAttribute("dateOrder", suite.getDateOrder());
            this.xmlStreamWriter.writeAttribute("description", suite.getDescription());
            this.xmlStreamWriter.writeAttribute("duration", String.valueOf(suite.getSuiteInfo().getDuration()));
            this.xmlStreamWriter.writeAttribute("name", suite.getName());
            this.xmlStreamWriter.writeAttribute("passed", String.valueOf(suite.getSuiteInfo().getStatus().equals("PASS")));
            this.xmlStreamWriter.writeAttribute("started", String.valueOf(suite.getStarted()));
            this.xmlStreamWriter.writeAttribute("startedFormated", suite.getStartedFormatted());
            this.xmlStreamWriter.writeAttribute("startedFormatedZulu", suite.getStartedFormattedZulu());
            this.xmlStreamWriter.writeAttribute("testsCount", String.valueOf(suite.getTests().size()));
            this.xmlStreamWriter.writeAttribute("testsFailed", String.valueOf(scriptsFailed));
            this.xmlStreamWriter.writeAttribute("testsPassed", String.valueOf(scriptsPassed));
            this.xmlStreamWriter.writeStartElement("parameters");
            this.xmlStreamWriter.writeStartElement("parameter");
            this.xmlStreamWriter.writeAttribute("name", "ats-image-quality");
            this.xmlStreamWriter.writeAttribute("value", this.getVisualQualityLabel(suite.getVisualQuality()));
            this.xmlStreamWriter.writeEndElement();
            this.writeSuiteParameters(suite.getParameters());
            this.xmlStreamWriter.writeEndElement();
            this.writeSuiteGroups(suite);
            this.xmlStreamWriter.writeCharacters(" ");
            this.xmlStreamWriter.writeStartElement("tests");
            this.xmlStreamWriter.writeCharacters(" ");
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSuiteGroups(Suite suite) throws XMLStreamException {
        if (!suite.getIncludedGroups().isEmpty() || !suite.getExcludedGroups().isEmpty()) {
            this.xmlStreamWriter.writeStartElement("groups");
            if (!suite.getIncludedGroups().isEmpty()) {
                suite.getIncludedGroups().stream().forEach(includedGroup -> this.writeGroup((String)includedGroup, "included"));
            }
            if (!suite.getExcludedGroups().isEmpty()) {
                suite.getExcludedGroups().stream().forEach(excludedGroup -> this.writeGroup((String)excludedGroup, "excluded"));
            }
            this.xmlStreamWriter.writeEndElement();
        }
    }

    private void writeSuiteParameters(Map<String, String> parameters) {
        parameters.entrySet().stream().forEach(parameterEntry -> {
            try {
                this.xmlStreamWriter.writeStartElement("parameter");
                this.xmlStreamWriter.writeAttribute("name", (String)parameterEntry.getKey());
                this.xmlStreamWriter.writeAttribute("value", (String)parameterEntry.getValue());
                this.xmlStreamWriter.writeEndElement();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void writeScript(File filePath, int devReportLVL) {
        byte[] buffer = new byte[4096];
        boolean devReportLvlReplaced = false;
        boolean startElementReplaced = false;
        try (FileInputStream fs = new FileInputStream(filePath);){
            int content;
            while ((content = fs.read(buffer)) != -1) {
                byte[] replacement;
                byte[] searchString;
                if (!devReportLvlReplaced) {
                    searchString = "devReportLVL=\"0\"".getBytes();
                    replacement = ("devReportLVL=\"" + devReportLVL + "\"").getBytes();
                    devReportLvlReplaced = this.replaceSpecificString(content, searchString, buffer, replacement);
                }
                if (!(startElementReplaced || (startElementReplaced = this.replaceSpecificString(content, searchString = "<?xml version='1.0' encoding='UTF-8'?>".getBytes(), buffer, replacement = "                                      ".getBytes())) || (startElementReplaced = this.replaceSpecificString(content, searchString = "<?xml version='1.0' encoding='UTF-8' standalone='no'?>".getBytes(), buffer, replacement = "                                                      ".getBytes())))) {
                    searchString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes();
                    replacement = "                                      ".getBytes();
                    startElementReplaced = this.replaceSpecificString(content, searchString, buffer, replacement);
                }
                this.fileOutputStream.write(buffer, 0, content);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean replaceSpecificString(int content, byte[] searchString, byte[] buffer, byte[] replacement) {
        boolean findMatch = false;
        for (int i = 0; i <= content - searchString.length; ++i) {
            boolean match = true;
            for (int j = 0; j < searchString.length; ++j) {
                if (buffer[i + j] == searchString[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            System.arraycopy(replacement, 0, buffer, i, replacement.length);
            i += searchString.length - 1;
            findMatch = true;
        }
        return findMatch;
    }

    private void initialize(Path outputFilePath) throws FileNotFoundException, XMLStreamException {
        this.outputFactory = XMLOutputFactory.newInstance();
        this.fileOutputStream = new FileOutputStream(outputFilePath.resolve(this.outputFilename).toFile());
        this.xmlStreamWriter = this.outputFactory.createXMLStreamWriter(this.fileOutputStream);
    }

    public void writeFileEnd() throws XMLStreamException {
        this.xmlStreamWriter.writeEndDocument();
        this.xmlStreamWriter.flush();
        this.xmlStreamWriter.close();
    }

    public void writeSuiteEnd() {
        try {
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private String getVisualQualityLabel(int visualQuality) {
        switch (visualQuality) {
            case 1: {
                return "size-optimized";
            }
            case 2: {
                return "speed-optimized";
            }
            case 3: {
                return "quality";
            }
            case 4: {
                return "max-quality";
            }
        }
        return "undefined";
    }

    private void writeGroup(String group, String groupType) {
        try {
            this.xmlStreamWriter.writeStartElement(groupType);
            this.xmlStreamWriter.writeCharacters(group);
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public List<Summary> getTestSummariesForExecutions(Path outputFolderPath, List<Suite> suites) {
        ArrayList<Summary> summaries = new ArrayList<Summary>();
        suites.forEach(suite -> suite.getTests().forEach(testName -> {
            Path targetPath = outputFolderPath.resolve(suite.getName()).resolve(testName + "_xml");
            File testReportFolder = targetPath.resolve("actions.xml").toFile();
            if (testReportFolder.exists()) {
                try {
                    XMLInputFactory factory = XMLInputFactory.newInstance();
                    XMLEventReader eventReader = factory.createXMLEventReader(new FileInputStream(testReportFolder));
                    boolean summaryAdded = false;
                    while (eventReader.hasNext() && !summaryAdded) {
                        StartElement startElement;
                        XMLEvent event = eventReader.nextEvent();
                        if (!event.isStartElement() || !(startElement = event.asStartElement()).getName().getLocalPart().equals("summary")) continue;
                        Summary summary = new Summary();
                        Attribute actionsAttr = startElement.getAttributeByName(new QName("actions"));
                        Attribute durationAttr = startElement.getAttributeByName(new QName("duration"));
                        Attribute statusAttr = startElement.getAttributeByName(new QName("status"));
                        summary.setActions(actionsAttr != null ? actionsAttr.getValue() : "");
                        summary.setDuration(durationAttr != null ? durationAttr.getValue() : "");
                        summary.setStatus(statusAttr != null ? statusAttr.getValue() : "");
                        summary.setSuiteName(suite.getName());
                        summary.setTestName((String)testName);
                        summaries.add(summary);
                        summaryAdded = true;
                    }
                    eventReader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                AtsLogger.printLog("test case filtered and not executed -> " + testName);
            }
        }));
        return summaries;
    }

    public List<Summary> getTestSummariesForExecutionsResult() {
        return this.testSummariesForExecution;
    }
}

