/*
 * Decompiled with CFR 0.152.
 */
package com.ats.executor.drivers;

import com.ats.driver.AtsRemoteWebDriver;
import com.ats.executor.ActionTestScript;
import com.ats.executor.drivers.DriverInfo;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerOptions;

public class DriverInfoGrid
extends DriverInfo {
    public static final String ATS_GRID_PREFIX = "ats-grid-";
    public static final String ATS_GRID_ENDPOINT = "ats-grid-endpoint";
    public static final String SE_KEY_REGEX = "^se-";
    public static final String SE_KEY_REPLACEMENT = "se:";
    public static final String ATS_GRID_CAPS_PREFIX = "ats-grid-caps-";
    public static final String ATS_GRID_ARGS_PREFIX = "ats-grid-arg";
    public static final String ATS_GRID_SCREEN_RESOLUTION = "screenresolution=";
    public static final String ATS_GRID_TAGS = "tags=";
    public static final String ATS_GRID_RECORD_VIDEO = "recordvideo=";
    private Map<String, Object> caps = new HashMap<String, Object>();
    private List<String> args = new ArrayList<String>();

    public DriverInfoGrid(String name, String uri, ActionTestScript script) {
        super(name, uri, script);
        this.setHeadless(true);
        Object driverUriString = uri;
        String driverPort = "4444";
        if (uri.contains(":")) {
            String[] data = uri.split(":");
            driverUriString = data[0];
            driverPort = data[1];
        }
        driverUriString = "http://" + ((String)driverUriString).replace("http://", "") + ":" + driverPort;
        try {
            this.setDriverServerUri(new URI((String)driverUriString));
        }
        catch (URISyntaxException data) {
            // empty catch block
        }
        System.getProperties().entrySet().forEach(p -> this.checkProperty(p.getKey().toString(), p.getValue().toString()));
        if (!this.caps.containsKey("se:tags")) {
            this.caps.put("se:tags", "");
        }
        if (!this.caps.containsKey("se:recordVideo")) {
            this.caps.put("se:recordVideo", false);
        }
        if (!this.caps.containsKey("se:screenResolution")) {
            this.caps.put("se:screenResolution", "1920x1080");
        }
        if (!this.caps.containsKey("se:name")) {
            this.caps.put("se:name", script.getTestName());
        }
        Gson gson = new Gson();
        JsonObject logs = new JsonObject();
        logs.add("capabilities", gson.toJsonTree(this.caps));
        logs.add("arguments", gson.toJsonTree(this.args));
        logs.addProperty("endpoint", (String)driverUriString);
        script.getLogger().sendScriptInfo("start SE Grid remote driver", gson.toJson((JsonElement)logs));
    }

    @Override
    public boolean isHeadless() {
        return true;
    }

    @Override
    public void setHeadless(boolean value) {
    }

    private void checkProperty(String k, String v) {
        if (k.startsWith(ATS_GRID_PREFIX)) {
            if (k.startsWith(ATS_GRID_CAPS_PREFIX)) {
                this.caps.put(k.substring(ATS_GRID_CAPS_PREFIX.length()).replaceAll(SE_KEY_REGEX, SE_KEY_REPLACEMENT), v);
            } else if (k.equals(ATS_GRID_ARGS_PREFIX)) {
                this.args.add(v);
            } else if (k.equals("ats-grid-args")) {
                String[] arguments = v.split(",");
                Arrays.asList(arguments).forEach(a -> this.args.add((String)a));
            }
        }
    }

    @Override
    public boolean isGrid() {
        return true;
    }

    @Override
    public AtsRemoteWebDriver getAtsRemoteWebDriver(Capabilities cap) throws MalformedURLException {
        return new AtsRemoteWebDriver(this.driverServerUri.resolve("/wd/hub").toURL(), this.getGridCapabilities(cap));
    }

    private Capabilities getGridCapabilities(Capabilities cap) {
        if ("firefox".equals(this.name)) {
            FirefoxOptions options = new FirefoxOptions();
            for (Map.Entry<String, Object> entry : this.caps.entrySet()) {
                options.setCapability(entry.getKey(), entry.getValue());
            }
            options.addArguments(this.args);
            return cap.merge((Capabilities)options);
        }
        if ("msedge".equals(this.name)) {
            EdgeOptions options = new EdgeOptions();
            for (Map.Entry<String, Object> entry : this.caps.entrySet()) {
                options.setCapability(entry.getKey(), entry.getValue());
            }
            options.addArguments(this.args);
            return cap.merge((Capabilities)options);
        }
        if ("ie".equals(this.name)) {
            InternetExplorerOptions options = new InternetExplorerOptions();
            for (Map.Entry<String, Object> entry : this.caps.entrySet()) {
                options.setCapability(entry.getKey(), entry.getValue());
            }
            return cap.merge((Capabilities)options);
        }
        ChromeOptions options = new ChromeOptions();
        for (Map.Entry<String, Object> entry : this.caps.entrySet()) {
            options.setCapability(entry.getKey(), entry.getValue());
        }
        options.addArguments(this.args);
        return cap.merge((Capabilities)options);
    }
}

