/*
 * Decompiled with CFR 0.152.
 */
package com.ats.generator.variables.parameter;

import com.ats.executor.ActionTestScript;
import com.ats.generator.variables.CalculatedProperty;
import com.ats.generator.variables.CalculatedValue;
import com.ats.script.Script;
import com.google.gson.JsonElement;
import java.util.List;

public class Parameter {
    private int index;
    private String name;
    private String data;
    private CalculatedValue value;

    public Parameter() {
    }

    public Parameter(int index, String name, String data) {
        this.index = index;
        this.name = name;
        this.data = data;
    }

    public Parameter(int index, String name, JsonElement elem) {
        this.index = index;
        this.name = name;
        this.data = elem == null || elem.isJsonNull() ? "" : elem.getAsString();
    }

    public Parameter(int index, CalculatedProperty prop) {
        this(index, prop.getName(), prop.getValue());
    }

    public Parameter(int index, String name, CalculatedValue value) {
        this(index, name, value.getCalculated());
        this.value = value;
    }

    public Parameter(int index, String data) {
        this(index, "#" + index, data);
    }

    public Parameter(int index, CalculatedValue value) {
        this(index, value.getCalculated());
        this.value = value;
    }

    public Parameter(int lineIndex, int colIndex, String[] cols, List<String> data) {
        this(lineIndex, cols[colIndex], data.get(colIndex));
    }

    public CharSequence getJavaCode() {
        return this.value.getJavaCode();
    }

    public String getCalculated() {
        if (this.value != null) {
            return this.value.getCalculated();
        }
        return this.data;
    }

    public void updateCalculated(ActionTestScript ts) {
        if (this.value == null) {
            this.value = new CalculatedValue((Script)ts, this.data);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public CalculatedValue getValue() {
        return this.value;
    }

    public void setValue(CalculatedValue value) {
        this.value = value;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

